/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model;

import org.eclipse.draw2d.geometry.Point;

import org.eclipse.emf.common.util.EList;
import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Do Model</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getDoTyp <em>Do Typ</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getSystemObject <em>System Object</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getRelativZu <em>Relativ Zu</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getAbsoluteLocation <em>Absolute Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getAusgehendeVerbindungen <em>Ausgehende Verbindungen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getEingehendeVerbindungen <em>Eingehende Verbindungen</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel()
 * @model
 * @generated
 */
public interface DoModel extends Named, Located, DoKomponente {
	/**
	 * Returns the value of the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Do Typ</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Do Typ</em>' reference.
	 * @see #setDoTyp(DoTyp)
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel_DoTyp()
	 * @model required="true"
	 * @generated
	 */
	DoTyp getDoTyp();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getDoTyp <em>Do Typ</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param value the new value of the '<em>Do Typ</em>' reference.
	 * @see #getDoTyp()
	 * @generated
	 */
	void setDoTyp(DoTyp value);

	/**
	 * Returns the value of the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>System Object</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>System Object</em>' attribute.
	 * @see #setSystemObject(SystemObject)
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel_SystemObject()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.SystemObject"
	 * @generated
	 */
	SystemObject getSystemObject();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getSystemObject <em>System Object</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>System Object</em>' attribute.
	 * @see #getSystemObject()
	 * @generated
	 */
	void setSystemObject(SystemObject value);

	/**
	 * Returns the value of the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Relativ Zu</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Relativ Zu</em>' reference.
	 * @see #setRelativZu(DoModel)
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel_RelativZu()
	 * @model
	 * @generated
	 */
	DoModel getRelativZu();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getRelativZu <em>Relativ Zu</em>}' reference.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Relativ Zu</em>' reference.
	 * @see #getRelativZu()
	 * @generated
	 */
	void setRelativZu(DoModel value);

	/**
	 * Returns the value of the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the value of the '<em>Absolute Location</em>' attribute.
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel_AbsoluteLocation()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.gef.model.Point" transient="true" changeable="false" volatile="true" derived="true"
	 * @generated
	 */
	Point getAbsoluteLocation();

	/**
	 * Returns the value of the '<em><b>Ausgehende Verbindungen</b></em>' reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie}.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getQuelle <em>Quelle</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ausgehende Verbindungen</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ausgehende Verbindungen</em>' reference list.
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel_AusgehendeVerbindungen()
	 * @see de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getQuelle
	 * @model opposite="quelle" transient="true"
	 * @generated
	 */
	EList<Verbindungslinie> getAusgehendeVerbindungen();

	/**
	 * Returns the value of the '<em><b>Eingehende Verbindungen</b></em>' reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie}.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getZiel <em>Ziel</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Eingehende Verbindungen</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Eingehende Verbindungen</em>' reference list.
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getDoModel_EingehendeVerbindungen()
	 * @see de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getZiel
	 * @model opposite="ziel" transient="true"
	 * @generated
	 */
	EList<Verbindungslinie> getEingehendeVerbindungen();

} // DoModel
