/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.dobj.model.DobjFactory
 * @model kind="package"
 * @generated
 */
public interface DobjPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "dobj";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://de.bsvrz.buv.plugin.dobj/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "dobj";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	DobjPackage eINSTANCE = de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl <em>Do Model</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoModel()
	 * @generated
	 */
	int DO_MODEL = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__LOCATION = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__KOMPONENTEN_ID = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__DO_TYP = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__SYSTEM_OBJECT = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__RELATIV_ZU = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__ABSOLUTE_LOCATION = EclipsePackage.NAMED_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__AUSGEHENDE_VERBINDUNGEN = EclipsePackage.NAMED_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_MODEL__EINGEHENDE_VERBINDUNGEN = EclipsePackage.NAMED_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Do Model</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_MODEL_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTypImpl <em>Do Typ</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoTypImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoTyp()
	 * @generated
	 */
	int DO_TYP = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_TYP__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TYP__ID = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_TYP__DESCRIPTION = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TYP__SYSTEM_OBJECT_TYPE = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_TYP__ICON = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TYP__ZOOM_STUFE = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Suchbar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TYP__SUCHBAR = EclipsePackage.NAMED_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Do Typ</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_TYP_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl <em>Configurated Do Typ</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getConfiguratedDoTyp()
	 * @generated
	 */
	int CONFIGURATED_DO_TYP = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__NAME = DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__ID = DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__DESCRIPTION = DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__SYSTEM_OBJECT_TYPE = DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__ICON = DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__ZOOM_STUFE = DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Suchbar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__SUCHBAR = DO_TYP__SUCHBAR;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT = DO_TYP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Nur Massstaebliche Darstellung</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = DO_TYP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Configurated Do Typ</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATED_DO_TYP_FEATURE_COUNT = DO_TYP_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.BitCtrlDoModelImpl <em>Bit Ctrl Do Model</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.BitCtrlDoModelImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getBitCtrlDoModel()
	 * @generated
	 */
	int BIT_CTRL_DO_MODEL = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__NAME = DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__LOCATION = DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__KOMPONENTEN_ID = DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__DO_TYP = DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__SYSTEM_OBJECT = DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__RELATIV_ZU = DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__ABSOLUTE_LOCATION = DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT = DO_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Bit Ctrl Do Model</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BIT_CTRL_DO_MODEL_FEATURE_COUNT = DO_MODEL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.dobj.model.impl.DoKomponenteImpl
	 * <em>Do Komponente</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoKomponenteImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoKomponente()
	 * @generated
	 */
	int DO_KOMPONENTE = 5;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_KOMPONENTE__KOMPONENTEN_ID = 0;

	/**
	 * The number of structural features of the '<em>Do Komponente</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_KOMPONENTE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoKompositum
	 * <em>Do Kompositum</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKompositum
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoKompositum()
	 * @generated
	 */
	int DO_KOMPOSITUM = 4;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_KOMPOSITUM__KOMPONENTEN_ID = DO_KOMPONENTE__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Komponenten</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_KOMPOSITUM__KOMPONENTEN = DO_KOMPONENTE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Do Kompositum</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_KOMPOSITUM_FEATURE_COUNT = DO_KOMPONENTE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.dobj.model.impl.ZoomStufeImpl
	 * <em>Zoom Stufe</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.ZoomStufeImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getZoomStufe()
	 * @generated
	 */
	int ZOOM_STUFE = 6;

	/**
	 * The feature id for the '<em><b>Von Level</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_STUFE__VON_LEVEL = 0;

	/**
	 * The feature id for the '<em><b>Bis Level</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_STUFE__BIS_LEVEL = 1;

	/**
	 * The number of structural features of the '<em>Zoom Stufe</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOM_STUFE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl <em>Do Bild</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoBild()
	 * @generated
	 */
	int DO_BILD = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__NAME = DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__LOCATION = DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_BILD__KOMPONENTEN_ID = DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__DO_TYP = DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__SYSTEM_OBJECT = DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__RELATIV_ZU = DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_BILD__ABSOLUTE_LOCATION = DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_BILD__AUSGEHENDE_VERBINDUNGEN = DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_BILD__EINGEHENDE_VERBINDUNGEN = DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__SIZE = DO_MODEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Selektierbar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_BILD__SELEKTIERBAR = DO_MODEL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten Fix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_BILD__ZOOM_VERHALTEN_FIX = DO_MODEL_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Bild</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD__BILD = DO_MODEL_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Do Bild</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_BILD_FEATURE_COUNT = DO_MODEL_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl <em>Do Text</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoText()
	 * @generated
	 */
	int DO_TEXT = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__NAME = DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__LOCATION = DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__KOMPONENTEN_ID = DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__DO_TYP = DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__SYSTEM_OBJECT = DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__RELATIV_ZU = DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__ABSOLUTE_LOCATION = DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__AUSGEHENDE_VERBINDUNGEN = DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__EINGEHENDE_VERBINDUNGEN = DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Selektierbar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__SELEKTIERBAR = DO_MODEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__TEXT = DO_MODEL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Font</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__FONT = DO_MODEL_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten Fix</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT__ZOOM_VERHALTEN_FIX = DO_MODEL_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Do Text</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_TEXT_FEATURE_COUNT = DO_MODEL_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.VerbindungslinieImpl <em>Verbindungslinie</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.VerbindungslinieImpl
	 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getVerbindungslinie()
	 * @generated
	 */
	int VERBINDUNGSLINIE = 9;

	/**
	 * The feature id for the '<em><b>Quelle</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERBINDUNGSLINIE__QUELLE = 0;

	/**
	 * The feature id for the '<em><b>Ziel</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERBINDUNGSLINIE__ZIEL = 1;

	/**
	 * The number of structural features of the '<em>Verbindungslinie</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VERBINDUNGSLINIE_FEATURE_COUNT = 2;

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoModel <em>Do Model</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel
	 * @generated
	 */
	EClass getDoModel();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getDoTyp <em>Do Typ</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getDoTyp()
	 * @see #getDoModel()
	 * @generated
	 */
	EReference getDoModel_DoTyp();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getSystemObject <em>System Object</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>System Object</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getSystemObject()
	 * @see #getDoModel()
	 * @generated
	 */
	EAttribute getDoModel_SystemObject();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getRelativZu <em>Relativ Zu</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Relativ Zu</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getRelativZu()
	 * @see #getDoModel()
	 * @generated
	 */
	EReference getDoModel_RelativZu();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoModel#getAbsoluteLocation
	 * <em>Absolute Location</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Absolute Location</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getAbsoluteLocation()
	 * @see #getDoModel()
	 * @generated
	 */
	EAttribute getDoModel_AbsoluteLocation();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getAusgehendeVerbindungen <em>Ausgehende Verbindungen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Ausgehende Verbindungen</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getAusgehendeVerbindungen()
	 * @see #getDoModel()
	 * @generated
	 */
	EReference getDoModel_AusgehendeVerbindungen();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getEingehendeVerbindungen <em>Eingehende Verbindungen</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Eingehende Verbindungen</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getEingehendeVerbindungen()
	 * @see #getDoModel()
	 * @generated
	 */
	EReference getDoModel_EingehendeVerbindungen();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoTyp <em>Do Typ</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp
	 * @generated
	 */
	EClass getDoTyp();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoTyp#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp#getId()
	 * @see #getDoTyp()
	 * @generated
	 */
	EAttribute getDoTyp_Id();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoTyp#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp#getDescription()
	 * @see #getDoTyp()
	 * @generated
	 */
	EAttribute getDoTyp_Description();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoTyp#getSystemObjectType
	 * <em>System Object Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>System Object Type</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp#getSystemObjectType()
	 * @see #getDoTyp()
	 * @generated
	 */
	EAttribute getDoTyp_SystemObjectType();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoTyp#getIcon <em>Icon</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Icon</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp#getIcon()
	 * @see #getDoTyp()
	 * @generated
	 */
	EAttribute getDoTyp_Icon();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.dobj.model.DoTyp#getZoomStufe <em>Zoom Stufe</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Zoom Stufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp#getZoomStufe()
	 * @see #getDoTyp()
	 * @generated
	 */
	EReference getDoTyp_ZoomStufe();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoTyp#isSuchbar <em>Suchbar</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Suchbar</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp#isSuchbar()
	 * @see #getDoTyp()
	 * @generated
	 */
	EAttribute getDoTyp_Suchbar();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp
	 * <em>Configurated Do Typ</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Configurated Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp
	 * @generated
	 */
	EClass getConfiguratedDoTyp();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp#getConfigurationElement <em>Configuration Element</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Configuration Element</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp#getConfigurationElement()
	 * @see #getConfiguratedDoTyp()
	 * @generated
	 */
	EAttribute getConfiguratedDoTyp_ConfigurationElement();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp#isNurMassstaeblicheDarstellung <em>Nur Massstaebliche Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Nur Massstaebliche Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp#isNurMassstaeblicheDarstellung()
	 * @see #getConfiguratedDoTyp()
	 * @generated
	 */
	EAttribute getConfiguratedDoTyp_NurMassstaeblicheDarstellung();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel
	 * <em>Bit Ctrl Do Model</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Bit Ctrl Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel
	 * @generated
	 */
	EClass getBitCtrlDoModel();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel#getSystemObjekt <em>System Objekt</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>System Objekt</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel#getSystemObjekt()
	 * @see #getBitCtrlDoModel()
	 * @generated
	 */
	EAttribute getBitCtrlDoModel_SystemObjekt();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.dobj.model.DoKompositum <em>Do Kompositum</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Do Kompositum</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKompositum
	 * @generated
	 */
	EClass getDoKompositum();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.dobj.model.DoKompositum#getKomponenten <em>Komponenten</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Komponenten</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKompositum#getKomponenten()
	 * @see #getDoKompositum()
	 * @generated
	 */
	EReference getDoKompositum_Komponenten();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.dobj.model.DoKomponente <em>Do Komponente</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Do Komponente</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKomponente
	 * @generated
	 */
	EClass getDoKomponente();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoKomponente#getKomponentenId <em>Komponenten Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Komponenten Id</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKomponente#getKomponentenId()
	 * @see #getDoKomponente()
	 * @generated
	 */
	EAttribute getDoKomponente_KomponentenId();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.dobj.model.ZoomStufe <em>Zoom Stufe</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zoom Stufe</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.ZoomStufe
	 * @generated
	 */
	EClass getZoomStufe();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.ZoomStufe#getVonLevel <em>Von Level</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Von Level</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.ZoomStufe#getVonLevel()
	 * @see #getZoomStufe()
	 * @generated
	 */
	EAttribute getZoomStufe_VonLevel();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.ZoomStufe#getBisLevel <em>Bis Level</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bis Level</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.ZoomStufe#getBisLevel()
	 * @see #getZoomStufe()
	 * @generated
	 */
	EAttribute getZoomStufe_BisLevel();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoBild <em>Do Bild</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Do Bild</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoBild
	 * @generated
	 */
	EClass getDoBild();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoBild#getBild <em>Bild</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bild</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoBild#getBild()
	 * @see #getDoBild()
	 * @generated
	 */
	EAttribute getDoBild_Bild();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.dobj.model.DoText <em>Do Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Do Text</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoText
	 * @generated
	 */
	EClass getDoText();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoText#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoText#getText()
	 * @see #getDoText()
	 * @generated
	 */
	EAttribute getDoText_Text();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.dobj.model.DoText#getFont <em>Font</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Font</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoText#getFont()
	 * @see #getDoText()
	 * @generated
	 */
	EReference getDoText_Font();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.dobj.model.DoText#isZoomVerhaltenFix <em>Zoom Verhalten Fix</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom Verhalten Fix</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoText#isZoomVerhaltenFix()
	 * @see #getDoText()
	 * @generated
	 */
	EAttribute getDoText_ZoomVerhaltenFix();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie <em>Verbindungslinie</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Verbindungslinie</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.Verbindungslinie
	 * @generated
	 */
	EClass getVerbindungslinie();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getQuelle <em>Quelle</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Quelle</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getQuelle()
	 * @see #getVerbindungslinie()
	 * @generated
	 */
	EReference getVerbindungslinie_Quelle();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getZiel <em>Ziel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Ziel</em>'.
	 * @see de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getZiel()
	 * @see #getVerbindungslinie()
	 * @generated
	 */
	EReference getVerbindungslinie_Ziel();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DobjFactory getDobjFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl
		 * <em>Do Model</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoModelImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoModel()
		 * @generated
		 */
		EClass DO_MODEL = eINSTANCE.getDoModel();

		/**
		 * The meta object literal for the '<em><b>Do Typ</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DO_MODEL__DO_TYP = eINSTANCE.getDoModel_DoTyp();

		/**
		 * The meta object literal for the '<em><b>System Object</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_MODEL__SYSTEM_OBJECT = eINSTANCE.getDoModel_SystemObject();

		/**
		 * The meta object literal for the '<em><b>Relativ Zu</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DO_MODEL__RELATIV_ZU = eINSTANCE.getDoModel_RelativZu();

		/**
		 * The meta object literal for the '<em><b>Absolute Location</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_MODEL__ABSOLUTE_LOCATION = eINSTANCE.getDoModel_AbsoluteLocation();

		/**
		 * The meta object literal for the '<em><b>Ausgehende Verbindungen</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DO_MODEL__AUSGEHENDE_VERBINDUNGEN = eINSTANCE.getDoModel_AusgehendeVerbindungen();

		/**
		 * The meta object literal for the '<em><b>Eingehende Verbindungen</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DO_MODEL__EINGEHENDE_VERBINDUNGEN = eINSTANCE.getDoModel_EingehendeVerbindungen();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTypImpl <em>Do Typ</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoTypImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoTyp()
		 * @generated
		 */
		EClass DO_TYP = eINSTANCE.getDoTyp();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TYP__ID = eINSTANCE.getDoTyp_Id();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TYP__DESCRIPTION = eINSTANCE.getDoTyp_Description();

		/**
		 * The meta object literal for the '<em><b>System Object Type</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TYP__SYSTEM_OBJECT_TYPE = eINSTANCE.getDoTyp_SystemObjectType();

		/**
		 * The meta object literal for the '<em><b>Icon</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TYP__ICON = eINSTANCE.getDoTyp_Icon();

		/**
		 * The meta object literal for the '<em><b>Zoom Stufe</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference DO_TYP__ZOOM_STUFE = eINSTANCE.getDoTyp_ZoomStufe();

		/**
		 * The meta object literal for the '<em><b>Suchbar</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TYP__SUCHBAR = eINSTANCE.getDoTyp_Suchbar();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl <em>Configurated Do Typ</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getConfiguratedDoTyp()
		 * @generated
		 */
		EClass CONFIGURATED_DO_TYP = eINSTANCE.getConfiguratedDoTyp();

		/**
		 * The meta object literal for the '
		 * <em><b>Configuration Element</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT = eINSTANCE.getConfiguratedDoTyp_ConfigurationElement();

		/**
		 * The meta object literal for the '<em><b>Nur Massstaebliche Darstellung</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG = eINSTANCE
				.getConfiguratedDoTyp_NurMassstaeblicheDarstellung();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.BitCtrlDoModelImpl <em>Bit Ctrl Do Model</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.BitCtrlDoModelImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getBitCtrlDoModel()
		 * @generated
		 */
		EClass BIT_CTRL_DO_MODEL = eINSTANCE.getBitCtrlDoModel();

		/**
		 * The meta object literal for the '<em><b>System Objekt</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BIT_CTRL_DO_MODEL__SYSTEM_OBJEKT = eINSTANCE.getBitCtrlDoModel_SystemObjekt();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.DoKompositum <em>Do Kompositum</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.DoKompositum
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoKompositum()
		 * @generated
		 */
		EClass DO_KOMPOSITUM = eINSTANCE.getDoKompositum();

		/**
		 * The meta object literal for the '<em><b>Komponenten</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference DO_KOMPOSITUM__KOMPONENTEN = eINSTANCE.getDoKompositum_Komponenten();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoKomponenteImpl <em>Do Komponente</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoKomponenteImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoKomponente()
		 * @generated
		 */
		EClass DO_KOMPONENTE = eINSTANCE.getDoKomponente();

		/**
		 * The meta object literal for the '<em><b>Komponenten Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_KOMPONENTE__KOMPONENTEN_ID = eINSTANCE.getDoKomponente_KomponentenId();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.ZoomStufeImpl <em>Zoom Stufe</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.ZoomStufeImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getZoomStufe()
		 * @generated
		 */
		EClass ZOOM_STUFE = eINSTANCE.getZoomStufe();

		/**
		 * The meta object literal for the '<em><b>Von Level</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ZOOM_STUFE__VON_LEVEL = eINSTANCE.getZoomStufe_VonLevel();

		/**
		 * The meta object literal for the '<em><b>Bis Level</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ZOOM_STUFE__BIS_LEVEL = eINSTANCE.getZoomStufe_BisLevel();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl
		 * <em>Do Bild</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoBild()
		 * @generated
		 */
		EClass DO_BILD = eINSTANCE.getDoBild();

		/**
		 * The meta object literal for the '<em><b>Bild</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_BILD__BILD = eINSTANCE.getDoBild_Bild();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl <em>Do Text</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DoTextImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getDoText()
		 * @generated
		 */
		EClass DO_TEXT = eINSTANCE.getDoText();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TEXT__TEXT = eINSTANCE.getDoText_Text();

		/**
		 * The meta object literal for the '<em><b>Font</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DO_TEXT__FONT = eINSTANCE.getDoText_Font();

		/**
		 * The meta object literal for the '<em><b>Zoom Verhalten Fix</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DO_TEXT__ZOOM_VERHALTEN_FIX = eINSTANCE.getDoText_ZoomVerhaltenFix();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.dobj.model.impl.VerbindungslinieImpl <em>Verbindungslinie</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.VerbindungslinieImpl
		 * @see de.bsvrz.buv.plugin.dobj.model.impl.DobjPackageImpl#getVerbindungslinie()
		 * @generated
		 */
		EClass VERBINDUNGSLINIE = eINSTANCE.getVerbindungslinie();

		/**
		 * The meta object literal for the '<em><b>Quelle</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERBINDUNGSLINIE__QUELLE = eINSTANCE.getVerbindungslinie_Quelle();

		/**
		 * The meta object literal for the '<em><b>Ziel</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VERBINDUNGSLINIE__ZIEL = eINSTANCE.getVerbindungslinie_Ziel();

	}

} // DobjPackage
