/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.model;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Verbindungslinie</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getQuelle <em>Quelle</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getZiel <em>Ziel</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getVerbindungslinie()
 * @model
 * @generated
 */
public interface Verbindungslinie extends EObject {
	/**
	 * Returns the value of the '<em><b>Quelle</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getAusgehendeVerbindungen <em>Ausgehende Verbindungen</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Quelle</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Quelle</em>' reference.
	 * @see #setQuelle(DoModel)
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getVerbindungslinie_Quelle()
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getAusgehendeVerbindungen
	 * @model opposite="ausgehendeVerbindungen" required="true" transient="true"
	 * @generated
	 */
	DoModel getQuelle();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getQuelle <em>Quelle</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Quelle</em>' reference.
	 * @see #getQuelle()
	 * @generated
	 */
	void setQuelle(DoModel value);

	/**
	 * Returns the value of the '<em><b>Ziel</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.dobj.model.DoModel#getEingehendeVerbindungen <em>Eingehende Verbindungen</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Ziel</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Ziel</em>' reference.
	 * @see #setZiel(DoModel)
	 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage#getVerbindungslinie_Ziel()
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel#getEingehendeVerbindungen
	 * @model opposite="eingehendeVerbindungen" required="true" transient="true"
	 * @generated
	 */
	DoModel getZiel();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie#getZiel <em>Ziel</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Ziel</em>' reference.
	 * @see #getZiel()
	 * @generated
	 */
	void setZiel(DoModel value);

} // Verbindungslinie
