/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.gef.GraphicalEditPart;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;

import de.bsvrz.buv.plugin.dobj.internal.DarstellungExtensionPoint;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.util.DobjAdapterFactory;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Configurated Do Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl#getConfigurationElement <em>Configuration Element</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.ConfiguratedDoTypImpl#isNurMassstaeblicheDarstellung <em>Nur Massstaebliche Darstellung</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConfiguratedDoTypImpl extends DoTypImpl implements ConfiguratedDoTyp {
	/**
	 * The default value of the '{@link #getConfigurationElement() <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getConfigurationElement()
	 * @generated
	 * @ordered
	 */
	protected static final IConfigurationElement CONFIGURATION_ELEMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getConfigurationElement() <em>Configuration Element</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getConfigurationElement()
	 * @generated
	 * @ordered
	 */
	protected IConfigurationElement configurationElement = CONFIGURATION_ELEMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #isNurMassstaeblicheDarstellung() <em>Nur Massstaebliche Darstellung</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #isNurMassstaeblicheDarstellung()
	 * @generated
	 * @ordered
	 */
	protected static final boolean NUR_MASSSTAEBLICHE_DARSTELLUNG_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isNurMassstaeblicheDarstellung() <em>Nur Massstaebliche Darstellung</em>}' attribute.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #isNurMassstaeblicheDarstellung()
	 * @generated
	 * @ordered
	 */
	protected boolean nurMassstaeblicheDarstellung = NUR_MASSSTAEBLICHE_DARSTELLUNG_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated not
	 */
	protected ConfiguratedDoTypImpl() {
		super();

		new DobjAdapterFactory().adapt(this, ConfiguratedDoTyp.class);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjPackage.Literals.CONFIGURATED_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public IConfigurationElement getConfigurationElement() {
		return configurationElement;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
		IConfigurationElement oldConfigurationElement = configurationElement;
		configurationElement = newConfigurationElement;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT, oldConfigurationElement,
					configurationElement));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isNurMassstaeblicheDarstellung() {
		return nurMassstaeblicheDarstellung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNurMassstaeblicheDarstellung(boolean newNurMassstaeblicheDarstellung) {
		boolean oldNurMassstaeblicheDarstellung = nurMassstaeblicheDarstellung;
		nurMassstaeblicheDarstellung = newNurMassstaeblicheDarstellung;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG, oldNurMassstaeblicheDarstellung,
					nurMassstaeblicheDarstellung));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public DoModel createModel() {
		// Ensure that you remove @generated or mark it @generated NOT

		final DoModel doModel;
		final String modelClass = configurationElement.getAttribute(DarstellungExtensionPoint.ATT_MODEL_CLASS);
		if (modelClass != null) {
			final int index = modelClass.lastIndexOf('/');
			doModel = (DoModel) EmfUtil.createEObject(modelClass.substring(0, index), modelClass.substring(index + 1));
		} else {
			// Fallback
			doModel = DobjFactory.eINSTANCE.createDoModel();
		}

		doModel.setDoTyp(this);

		return doModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public GraphicalEditPart createController() {
		// Ensure that you remove @generated or mark it @generated NOT

		try {
			return (GraphicalEditPart) configurationElement
					.createExecutableExtension(DarstellungExtensionPoint.ATT_CONTROLLER_CLASS);
		} catch (final CoreException ex) {
			throw new IllegalStateException(ex);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT:
			return getConfigurationElement();
		case DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG:
			return isNurMassstaeblicheDarstellung();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT:
			setConfigurationElement((IConfigurationElement) newValue);
			return;
		case DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG:
			setNurMassstaeblicheDarstellung((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT:
			setConfigurationElement(CONFIGURATION_ELEMENT_EDEFAULT);
			return;
		case DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG:
			setNurMassstaeblicheDarstellung(NUR_MASSSTAEBLICHE_DARSTELLUNG_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjPackage.CONFIGURATED_DO_TYP__CONFIGURATION_ELEMENT:
			return CONFIGURATION_ELEMENT_EDEFAULT == null ? configurationElement != null
					: !CONFIGURATION_ELEMENT_EDEFAULT.equals(configurationElement);
		case DobjPackage.CONFIGURATED_DO_TYP__NUR_MASSSTAEBLICHE_DARSTELLUNG:
			return nurMassstaeblicheDarstellung != NUR_MASSSTAEBLICHE_DARSTELLUNG_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (configurationElement: ");
		result.append(configurationElement);
		result.append(", nurMassstaeblicheDarstellung: ");
		result.append(nurMassstaeblicheDarstellung);
		result.append(')');
		return result.toString();
	}

} // ConfiguratedDoTypImpl
