/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Do Bild</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl#getSize <em>Size</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl#isSelektierbar <em>Selektierbar</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl#isZoomVerhaltenFix <em>Zoom Verhalten Fix</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.DoBildImpl#getBild <em>Bild</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DoBildImpl extends DoModelImpl implements DoBild {
	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final Dimension SIZE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Dimension size = SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #isSelektierbar() <em>Selektierbar</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSelektierbar()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SELEKTIERBAR_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isSelektierbar() <em>Selektierbar</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isSelektierbar()
	 * @generated
	 * @ordered
	 */
	protected boolean selektierbar = SELEKTIERBAR_EDEFAULT;

	/**
	 * The default value of the '{@link #isZoomVerhaltenFix()
	 * <em>Zoom Verhalten Fix</em>}' attribute. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see #isZoomVerhaltenFix()
	 * @generated NOT
	 * @ordered
	 */
	protected static final boolean ZOOM_VERHALTEN_FIX_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isZoomVerhaltenFix() <em>Zoom Verhalten Fix</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isZoomVerhaltenFix()
	 * @generated
	 * @ordered
	 */
	protected boolean zoomVerhaltenFix = ZOOM_VERHALTEN_FIX_EDEFAULT;

	/**
	 * The default value of the '{@link #getBild() <em>Bild</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBild()
	 * @generated
	 * @ordered
	 */
	protected static final Bild BILD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBild() <em>Bild</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBild()
	 * @generated
	 * @ordered
	 */
	protected Bild bild = BILD_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DoBildImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjPackage.Literals.DO_BILD;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Dimension getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSize(Dimension newSize) {
		Dimension oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_BILD__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSelektierbar() {
		return selektierbar;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSelektierbar(boolean newSelektierbar) {
		boolean oldSelektierbar = selektierbar;
		selektierbar = newSelektierbar;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_BILD__SELEKTIERBAR, oldSelektierbar,
					selektierbar));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isZoomVerhaltenFix() {
		return zoomVerhaltenFix;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZoomVerhaltenFix(boolean newZoomVerhaltenFix) {
		boolean oldZoomVerhaltenFix = zoomVerhaltenFix;
		zoomVerhaltenFix = newZoomVerhaltenFix;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX,
					oldZoomVerhaltenFix, zoomVerhaltenFix));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Bild getBild() {
		return bild;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBild(Bild newBild) {
		Bild oldBild = bild;
		bild = newBild;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.DO_BILD__BILD, oldBild, bild));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjPackage.DO_BILD__SIZE:
			return getSize();
		case DobjPackage.DO_BILD__SELEKTIERBAR:
			return isSelektierbar();
		case DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX:
			return isZoomVerhaltenFix();
		case DobjPackage.DO_BILD__BILD:
			return getBild();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjPackage.DO_BILD__SIZE:
			setSize((Dimension) newValue);
			return;
		case DobjPackage.DO_BILD__SELEKTIERBAR:
			setSelektierbar((Boolean) newValue);
			return;
		case DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX:
			setZoomVerhaltenFix((Boolean) newValue);
			return;
		case DobjPackage.DO_BILD__BILD:
			setBild((Bild) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjPackage.DO_BILD__SIZE:
			setSize(SIZE_EDEFAULT);
			return;
		case DobjPackage.DO_BILD__SELEKTIERBAR:
			setSelektierbar(SELEKTIERBAR_EDEFAULT);
			return;
		case DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX:
			setZoomVerhaltenFix(ZOOM_VERHALTEN_FIX_EDEFAULT);
			return;
		case DobjPackage.DO_BILD__BILD:
			setBild(BILD_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjPackage.DO_BILD__SIZE:
			return SIZE_EDEFAULT == null ? size != null : !SIZE_EDEFAULT.equals(size);
		case DobjPackage.DO_BILD__SELEKTIERBAR:
			return selektierbar != SELEKTIERBAR_EDEFAULT;
		case DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX:
			return zoomVerhaltenFix != ZOOM_VERHALTEN_FIX_EDEFAULT;
		case DobjPackage.DO_BILD__BILD:
			return BILD_EDEFAULT == null ? bild != null : !BILD_EDEFAULT.equals(bild);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Sized.class) {
			switch (derivedFeatureID) {
			case DobjPackage.DO_BILD__SIZE:
				return GefPackage.SIZED__SIZE;
			default:
				return -1;
			}
		}
		if (baseClass == SelektierbarDecorator.class) {
			switch (derivedFeatureID) {
			case DobjPackage.DO_BILD__SELEKTIERBAR:
				return DobjDecoratorPackage.SELEKTIERBAR_DECORATOR__SELEKTIERBAR;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomVerhaltenFixDecorator.class) {
			switch (derivedFeatureID) {
			case DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX:
				return DobjDecoratorPackage.ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Sized.class) {
			switch (baseFeatureID) {
			case GefPackage.SIZED__SIZE:
				return DobjPackage.DO_BILD__SIZE;
			default:
				return -1;
			}
		}
		if (baseClass == SelektierbarDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.SELEKTIERBAR_DECORATOR__SELEKTIERBAR:
				return DobjPackage.DO_BILD__SELEKTIERBAR;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomVerhaltenFixDecorator.class) {
			switch (baseFeatureID) {
			case DobjDecoratorPackage.ZOOM_VERHALTEN_FIX_DECORATOR__ZOOM_VERHALTEN_FIX:
				return DobjPackage.DO_BILD__ZOOM_VERHALTEN_FIX;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (size: ");
		result.append(size);
		result.append(", selektierbar: ");
		result.append(selektierbar);
		result.append(", ZoomVerhaltenFix: ");
		result.append(zoomVerhaltenFix);
		result.append(", bild: ");
		result.append(bild);
		result.append(')');
		return result.toString();
	}

} // DoBildImpl
