/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import de.bsvrz.buv.plugin.dobj.model.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DobjFactoryImpl extends EFactoryImpl implements DobjFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public static DobjFactory init() {
		try {
			DobjFactory theDobjFactory = (DobjFactory) EPackage.Registry.INSTANCE.getEFactory(DobjPackage.eNS_URI);
			if (theDobjFactory != null) {
				return theDobjFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DobjFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DobjFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case DobjPackage.DO_MODEL:
			return createDoModel();
		case DobjPackage.CONFIGURATED_DO_TYP:
			return createConfiguratedDoTyp();
		case DobjPackage.BIT_CTRL_DO_MODEL:
			return createBitCtrlDoModel();
		case DobjPackage.DO_KOMPONENTE:
			return createDoKomponente();
		case DobjPackage.ZOOM_STUFE:
			return createZoomStufe();
		case DobjPackage.DO_BILD:
			return createDoBild();
		case DobjPackage.DO_TEXT:
			return createDoText();
		case DobjPackage.VERBINDUNGSLINIE:
			return createVerbindungslinie();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoModel createDoModel() {
		DoModelImpl doModel = new DoModelImpl();
		return doModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ConfiguratedDoTyp createConfiguratedDoTyp() {
		ConfiguratedDoTypImpl configuratedDoTyp = new ConfiguratedDoTypImpl();
		return configuratedDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public <T extends SystemObjekt> BitCtrlDoModel<T> createBitCtrlDoModel() {
		BitCtrlDoModelImpl<T> bitCtrlDoModel = new BitCtrlDoModelImpl<T>();
		return bitCtrlDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoKomponente createDoKomponente() {
		DoKomponenteImpl doKomponente = new DoKomponenteImpl();
		return doKomponente;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomStufe createZoomStufe() {
		ZoomStufeImpl zoomStufe = new ZoomStufeImpl();
		return zoomStufe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoBild createDoBild() {
		DoBildImpl doBild = new DoBildImpl();
		return doBild;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoText createDoText() {
		DoTextImpl doText = new DoTextImpl();
		return doText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Verbindungslinie createVerbindungslinie() {
		VerbindungslinieImpl verbindungslinie = new VerbindungslinieImpl();
		return verbindungslinie;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DobjPackage getDobjPackage() {
		return (DobjPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DobjPackage getPackage() {
		return DobjPackage.eINSTANCE;
	}

} // DobjFactoryImpl
