/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Zoom Stufe</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.ZoomStufeImpl#getVonLevel <em>Von Level</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.dobj.model.impl.ZoomStufeImpl#getBisLevel <em>Bis Level</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ZoomStufeImpl extends EObjectImpl implements ZoomStufe {
	/**
	 * The default value of the '{@link #getVonLevel() <em>Von Level</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getVonLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int VON_LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getVonLevel() <em>Von Level</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getVonLevel()
	 * @generated
	 * @ordered
	 */
	protected int vonLevel = VON_LEVEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getBisLevel() <em>Bis Level</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBisLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int BIS_LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getBisLevel() <em>Bis Level</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBisLevel()
	 * @generated
	 * @ordered
	 */
	protected int bisLevel = BIS_LEVEL_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ZoomStufeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DobjPackage.Literals.ZOOM_STUFE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getVonLevel() {
		return vonLevel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVonLevel(int newVonLevel) {
		int oldVonLevel = vonLevel;
		vonLevel = newVonLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.ZOOM_STUFE__VON_LEVEL, oldVonLevel,
					vonLevel));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getBisLevel() {
		return bisLevel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBisLevel(int newBisLevel) {
		int oldBisLevel = bisLevel;
		bisLevel = newBisLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DobjPackage.ZOOM_STUFE__BIS_LEVEL, oldBisLevel,
					bisLevel));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DobjPackage.ZOOM_STUFE__VON_LEVEL:
			return getVonLevel();
		case DobjPackage.ZOOM_STUFE__BIS_LEVEL:
			return getBisLevel();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DobjPackage.ZOOM_STUFE__VON_LEVEL:
			setVonLevel((Integer) newValue);
			return;
		case DobjPackage.ZOOM_STUFE__BIS_LEVEL:
			setBisLevel((Integer) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DobjPackage.ZOOM_STUFE__VON_LEVEL:
			setVonLevel(VON_LEVEL_EDEFAULT);
			return;
		case DobjPackage.ZOOM_STUFE__BIS_LEVEL:
			setBisLevel(BIS_LEVEL_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DobjPackage.ZOOM_STUFE__VON_LEVEL:
			return vonLevel != VON_LEVEL_EDEFAULT;
		case DobjPackage.ZOOM_STUFE__BIS_LEVEL:
			return bisLevel != BIS_LEVEL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (vonLevel: ");
		result.append(vonLevel);
		result.append(", bisLevel: ");
		result.append(bisLevel);
		result.append(')');
		return result.toString();
	}

} // ZoomStufeImpl
