/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import com.bitctrl.lib.eclipse.emf.eclipse.model.provider.NamedItemProvider;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * This is the item provider adapter for a {@link de.bsvrz.buv.plugin.dobj.model.DoModel} object.
 * <!-- begin-user-doc
 * --> <!-- end-user-doc -->
 * @generated
 */
public class DoModelItemProvider extends NamedItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public DoModelItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addLocationPropertyDescriptor(object);
			addKomponentenIdPropertyDescriptor(object);
			addDoTypPropertyDescriptor(object);
			addSystemObjectPropertyDescriptor(object);
			addRelativZuPropertyDescriptor(object);
			addAbsoluteLocationPropertyDescriptor(object);
			addAusgehendeVerbindungenPropertyDescriptor(object);
			addEingehendeVerbindungenPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Do Typ feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addDoTypPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(), getString("_UI_DoModel_doTyp_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoModel_doTyp_feature", "_UI_DoModel_type"),
				DobjPackage.Literals.DO_MODEL__DO_TYP, true, false, true, null,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Location feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLocationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(), getString("_UI_Located_location_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Located_location_feature", "_UI_Located_type"),
				GefPackage.Literals.LOCATED__LOCATION, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Komponenten Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addKomponentenIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DoKomponente_komponentenId_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoKomponente_komponentenId_feature",
						"_UI_DoKomponente_type"),
				DobjPackage.Literals.DO_KOMPONENTE__KOMPONENTEN_ID, true, false,
				false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null,
				null));
	}

	/**
	 * This adds a property descriptor for the System Object feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addSystemObjectPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DoModel_systemObject_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoModel_systemObject_feature", "_UI_DoModel_type"),
				DobjPackage.Literals.DO_MODEL__SYSTEM_OBJECT, true, false,
				false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Relativ Zu feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addRelativZuPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DoModel_relativZu_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoModel_relativZu_feature", "_UI_DoModel_type"),
				DobjPackage.Literals.DO_MODEL__RELATIV_ZU, true, false, true,
				null, null, null));
	}

	/**
	 * This adds a property descriptor for the Absolute Location feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addAbsoluteLocationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DoModel_absoluteLocation_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoModel_absoluteLocation_feature",
						"_UI_DoModel_type"),
				DobjPackage.Literals.DO_MODEL__ABSOLUTE_LOCATION, false, false,
				false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Ausgehende Verbindungen feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addAusgehendeVerbindungenPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DoModel_ausgehendeVerbindungen_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoModel_ausgehendeVerbindungen_feature",
						"_UI_DoModel_type"),
				DobjPackage.Literals.DO_MODEL__AUSGEHENDE_VERBINDUNGEN, true,
				false, true, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Eingehende Verbindungen feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addEingehendeVerbindungenPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DoModel_eingehendeVerbindungen_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DoModel_eingehendeVerbindungen_feature",
						"_UI_DoModel_type"),
				DobjPackage.Literals.DO_MODEL__EINGEHENDE_VERBINDUNGEN, true,
				false, true, null, null, null));
	}

	/**
	 * This returns DoModel.gif.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object,
				getResourceLocator().getImage("full/obj16/DoModel"));
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public String getText(final Object object) {
		final String label = doGetText(object);
		return label == null || label.length() == 0
				? getString("_UI_DoModel_type") : label;
	}

	/**
	 * @generated NOT
	 */
	protected String doGetText(final Object object) {
		final DoModel doModel = (DoModel) object;
		String label = doModel.getName();
		if ((label == null || label.isEmpty())
				&& doModel.getSystemObject() != null) {
			label = doModel.getSystemObject().toString();
		}
		return label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(DoModel.class)) {
		case DobjPackage.DO_MODEL__LOCATION:
		case DobjPackage.DO_MODEL__KOMPONENTEN_ID:
		case DobjPackage.DO_MODEL__SYSTEM_OBJECT:
		case DobjPackage.DO_MODEL__ABSOLUTE_LOCATION:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DobjEditPlugin.INSTANCE;
	}

}
