package de.bsvrz.buv.plugin.dobj.model.util;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

import de.bsvrz.buv.plugin.dobj.internal.DarstellungExtensionPoint;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Reagiert auf Änderung des Extension Points und aktualisiert die restlichen
 * Eigenschaften.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @generated not
 */
public class ConfiguratedDoTypAdapter extends AdapterImpl {

	@Override
	public boolean isAdapterForType(final Object type) {
		return type == ConfiguratedDoTyp.class;
	}

	@Override
	public void notifyChanged(final Notification msg) {
		if (msg.getFeature() == DobjPackage.eINSTANCE.getConfiguratedDoTyp_ConfigurationElement()) {
			switch (msg.getEventType()) {
			case Notification.SET:
			case Notification.UNSET:
				configureDoTyp(msg);
				break;
			}
		}
	}

	private void configureDoTyp(final Notification msg) {
		final ConfiguratedDoTyp doTyp = (ConfiguratedDoTyp) msg.getNotifier();
		final IConfigurationElement configurationElement = (IConfigurationElement) msg.getNewValue();

		configureDoTypId(doTyp, configurationElement);
		configureDoTypName(doTyp, configurationElement);
		configureDoTypDescription(doTyp, configurationElement);
		configureSystemObjectType(doTyp, configurationElement);
		configureDoTypIcon(doTyp, configurationElement);
		configureDoTypNurMassstaeblicheDarstellung(doTyp, configurationElement);
	}

	private void configureDoTypId(final ConfiguratedDoTyp doTyp, final IConfigurationElement configurationElement) {
		final String id = configurationElement.getAttribute(DarstellungExtensionPoint.ATT_ID);
		doTyp.setId(id);
	}

	private void configureDoTypName(final ConfiguratedDoTyp doTyp, final IConfigurationElement configurationElement) {
		final String name = configurationElement.getAttribute(DarstellungExtensionPoint.ATT_NAME);
		doTyp.setName(name);
	}

	private void configureDoTypDescription(final ConfiguratedDoTyp doTyp,
			final IConfigurationElement configurationElement) {
		final String description = configurationElement.getAttribute(DarstellungExtensionPoint.ATT_DESCRIPTION);
		if (description != null) {
			doTyp.setDescription(description);
		}
	}

	private void configureSystemObjectType(final ConfiguratedDoTyp doTyp,
			final IConfigurationElement configurationElement) {
		final String pid = configurationElement.getAttribute(DarstellungExtensionPoint.ATT_SYSTEM_OBJEKT_TYP);
		final RahmenwerkService rahmenwerkService = RahmenwerkService.getService();
		if (pid != null && rahmenwerkService.getRahmenWerk().isOnline()) {
			final ClientDavInterface dav = rahmenwerkService.getRahmenWerk().getDavVerbindung();
			final SystemObjectType systemObjectType = dav.getDataModel().getType(pid);
			doTyp.setSystemObjectType(systemObjectType);
		}
	}

	private void configureDoTypIcon(final ConfiguratedDoTyp doTyp, final IConfigurationElement configurationElement) {
		final String imagePath = configurationElement.getAttribute(DarstellungExtensionPoint.ATT_ICON);
		if (imagePath != null) {
			final IContributor contributor = configurationElement.getContributor();
			final Bundle sourceBundle = Platform.getBundle(contributor.getName());
			final URL url = FileLocator.find(sourceBundle, new Path(imagePath), null);
			final ImageDescriptor icon = ImageDescriptor.createFromURL(url);
			doTyp.setIcon(icon);
		}
	}

	private void configureDoTypNurMassstaeblicheDarstellung(final ConfiguratedDoTyp doTyp,
			final IConfigurationElement configurationElement) {
		final String nurMassstaeblicheDarstellung = configurationElement
				.getAttribute(DarstellungExtensionPoint.ATT_NUR_MASSSTAEBLICHE_DARSTELLUNG);
		if (nurMassstaeblicheDarstellung != null) {
			doTyp.setNurMassstaeblicheDarstellung(Boolean.valueOf(nurMassstaeblicheDarstellung));
		}
	}

}
