/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2013 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.model.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjFactory;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.Verbindungslinie;

/**
 * Überwacht die Eigenschaft {@link DoModel#getRelativZu() relativ zu} und
 * aktualisiert entsprechend die Listen der
 * {@link DoModel#getEingehendeVerbindungen() ein-} und
 * {@link DoModel#getAusgehendeVerbindungen() ausgehenden Verbindungen}.
 * 
 * @author BitCtrl Systems GmbH, Falko Schumann
 * 
 * @generated not
 */
public class DoModelAdapter extends AdapterImpl {

	@Override
	public boolean isAdapterForType(final Object type) {
		return type == DoModel.class;
	}

	@Override
	public void notifyChanged(final Notification msg) {
		if (msg.getFeature() == DobjPackage.eINSTANCE.getDoModel_RelativZu()) {
			switch (msg.getEventType()) {
			case Notification.SET:
			case Notification.UNSET:
				aktualisiereVerbindungen(msg);
				break;
			}
		}

	}

	private void aktualisiereVerbindungen(final Notification msg) {
		final DoModel quelle = (DoModel) msg.getNotifier();
		final DoModel ziel = quelle.getRelativZu();

		if (ziel != null) {
			loescheVerbindung(quelle);
			erzeugeVerbindung(quelle, ziel);
		} else {
			loescheVerbindung(quelle);
		}
	}

	private void loescheVerbindung(final DoModel quelle) {
		for (final Verbindungslinie v : quelle.getAusgehendeVerbindungen()) {
			v.getZiel().getEingehendeVerbindungen().remove(v);
		}
		quelle.getAusgehendeVerbindungen().clear();
	}

	private void erzeugeVerbindung(final DoModel quelle, final DoModel ziel) {
		final Verbindungslinie v = DobjFactory.eINSTANCE
				.createVerbindungslinie();
		v.setQuelle(quelle);
		v.setZiel(ziel);
		quelle.getAusgehendeVerbindungen().add(v);
		ziel.getEingehendeVerbindungen().add(v);
	}

}
