/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.model.*;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.Verbindungslinie;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage
 * @generated
 */
public class DobjAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static DobjPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DobjAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = DobjPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DobjSwitch<Adapter> modelSwitch = new DobjSwitch<Adapter>() {
		@Override
		public Adapter caseDoModel(DoModel object) {
			return createDoModelAdapter();
		}

		@Override
		public Adapter caseDoTyp(DoTyp object) {
			return createDoTypAdapter();
		}

		@Override
		public Adapter caseConfiguratedDoTyp(ConfiguratedDoTyp object) {
			return createConfiguratedDoTypAdapter();
		}

		@Override
		public <T extends SystemObjekt> Adapter caseBitCtrlDoModel(BitCtrlDoModel<T> object) {
			return createBitCtrlDoModelAdapter();
		}

		@Override
		public <T extends DoKomponente> Adapter caseDoKompositum(DoKompositum<T> object) {
			return createDoKompositumAdapter();
		}

		@Override
		public Adapter caseDoKomponente(DoKomponente object) {
			return createDoKomponenteAdapter();
		}

		@Override
		public Adapter caseZoomStufe(ZoomStufe object) {
			return createZoomStufeAdapter();
		}

		@Override
		public Adapter caseDoBild(DoBild object) {
			return createDoBildAdapter();
		}

		@Override
		public Adapter caseDoText(DoText object) {
			return createDoTextAdapter();
		}

		@Override
		public Adapter caseVerbindungslinie(Verbindungslinie object) {
			return createVerbindungslinieAdapter();
		}

		@Override
		public Adapter caseNamed(Named object) {
			return createNamedAdapter();
		}

		@Override
		public Adapter caseLocated(Located object) {
			return createLocatedAdapter();
		}

		@Override
		public Adapter caseSized(Sized object) {
			return createSizedAdapter();
		}

		@Override
		public Adapter caseSelektierbarDecorator(SelektierbarDecorator object) {
			return createSelektierbarDecoratorAdapter();
		}

		@Override
		public Adapter caseZoomVerhaltenFixDecorator(ZoomVerhaltenFixDecorator object) {
			return createZoomVerhaltenFixDecoratorAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoModel <em>Do Model</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoModel
	 * @generated NOT
	 */
	public Adapter createDoModelAdapter() {
		return new DoModelAdapter();
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoTyp <em>Do Typ</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoTyp
	 * @generated
	 */
	public Adapter createDoTypAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp
	 * <em>Configurated Do Typ</em>}'. <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp
	 * @generated not
	 */
	public Adapter createConfiguratedDoTypAdapter() {
		return new ConfiguratedDoTypAdapter();
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel <em>Bit Ctrl Do Model</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel
	 * @generated
	 */
	public Adapter createBitCtrlDoModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.DoKompositum <em>Do Kompositum</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKompositum
	 * @generated
	 */
	public Adapter createDoKompositumAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.DoKomponente <em>Do Komponente</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoKomponente
	 * @generated
	 */
	public Adapter createDoKomponenteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.ZoomStufe <em>Zoom Stufe</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.ZoomStufe
	 * @generated
	 */
	public Adapter createZoomStufeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoBild <em>Do Bild</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoBild
	 * @generated
	 */
	public Adapter createDoBildAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link de.bsvrz.buv.plugin.dobj.model.DoText <em>Do Text</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.DoText
	 * @generated
	 */
	public Adapter createDoTextAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.model.Verbindungslinie <em>Verbindungslinie</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.model.Verbindungslinie
	 * @generated
	 */
	public Adapter createVerbindungslinieAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.bitctrl.lib.eclipse.emf.eclipse.model.Named <em>Named</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.eclipse.model.Named
	 * @generated
	 */
	public Adapter createNamedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.bitctrl.lib.eclipse.emf.gef.model.Located <em>Located</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that
	 * we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.gef.model.Located
	 * @generated
	 */
	public Adapter createLocatedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link com.bitctrl.lib.eclipse.emf.gef.model.Sized <em>Sized</em>}'. <!--
	 * begin-user-doc --> This default implementation returns null so that we
	 * can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * 
	 * @return the new adapter.
	 * @see com.bitctrl.lib.eclipse.emf.gef.model.Sized
	 * @generated
	 */
	public Adapter createSizedAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator <em>Selektierbar Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator
	 * @generated
	 */
	public Adapter createSelektierbarDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator <em>Zoom Verhalten Fix Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator
	 * @generated
	 */
	public Adapter createZoomVerhaltenFixDecoratorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} // DobjAdapterFactory
