/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.dobj.model.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;
import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.ZoomVerhaltenFixDecorator;
import de.bsvrz.buv.plugin.dobj.model.*;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoBild;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoText;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.dobj.model.DobjPackage
 * @generated
 */
public class DobjSwitch<T1> extends Switch<T1> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static DobjPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DobjSwitch() {
		if (modelPackage == null) {
			modelPackage = DobjPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T1 doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case DobjPackage.DO_MODEL: {
			DoModel doModel = (DoModel) theEObject;
			T1 result = caseDoModel(doModel);
			if (result == null)
				result = caseNamed(doModel);
			if (result == null)
				result = caseLocated(doModel);
			if (result == null)
				result = caseDoKomponente(doModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.DO_TYP: {
			DoTyp doTyp = (DoTyp) theEObject;
			T1 result = caseDoTyp(doTyp);
			if (result == null)
				result = caseNamed(doTyp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.CONFIGURATED_DO_TYP: {
			ConfiguratedDoTyp configuratedDoTyp = (ConfiguratedDoTyp) theEObject;
			T1 result = caseConfiguratedDoTyp(configuratedDoTyp);
			if (result == null)
				result = caseDoTyp(configuratedDoTyp);
			if (result == null)
				result = caseNamed(configuratedDoTyp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.BIT_CTRL_DO_MODEL: {
			BitCtrlDoModel<?> bitCtrlDoModel = (BitCtrlDoModel<?>) theEObject;
			T1 result = caseBitCtrlDoModel(bitCtrlDoModel);
			if (result == null)
				result = caseDoModel(bitCtrlDoModel);
			if (result == null)
				result = caseNamed(bitCtrlDoModel);
			if (result == null)
				result = caseLocated(bitCtrlDoModel);
			if (result == null)
				result = caseDoKomponente(bitCtrlDoModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.DO_KOMPOSITUM: {
			DoKompositum<?> doKompositum = (DoKompositum<?>) theEObject;
			T1 result = caseDoKompositum(doKompositum);
			if (result == null)
				result = caseDoKomponente(doKompositum);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.DO_KOMPONENTE: {
			DoKomponente doKomponente = (DoKomponente) theEObject;
			T1 result = caseDoKomponente(doKomponente);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.ZOOM_STUFE: {
			ZoomStufe zoomStufe = (ZoomStufe) theEObject;
			T1 result = caseZoomStufe(zoomStufe);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.DO_BILD: {
			DoBild doBild = (DoBild) theEObject;
			T1 result = caseDoBild(doBild);
			if (result == null)
				result = caseDoModel(doBild);
			if (result == null)
				result = caseSized(doBild);
			if (result == null)
				result = caseSelektierbarDecorator(doBild);
			if (result == null)
				result = caseZoomVerhaltenFixDecorator(doBild);
			if (result == null)
				result = caseNamed(doBild);
			if (result == null)
				result = caseLocated(doBild);
			if (result == null)
				result = caseDoKomponente(doBild);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.DO_TEXT: {
			DoText doText = (DoText) theEObject;
			T1 result = caseDoText(doText);
			if (result == null)
				result = caseDoModel(doText);
			if (result == null)
				result = caseSelektierbarDecorator(doText);
			if (result == null)
				result = caseNamed(doText);
			if (result == null)
				result = caseLocated(doText);
			if (result == null)
				result = caseDoKomponente(doText);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case DobjPackage.VERBINDUNGSLINIE: {
			Verbindungslinie verbindungslinie = (Verbindungslinie) theEObject;
			T1 result = caseVerbindungslinie(verbindungslinie);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Model</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoModel(DoModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Typ</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoTyp(DoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Configurated Do Typ</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Configurated Do Typ</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseConfiguratedDoTyp(ConfiguratedDoTyp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Bit Ctrl Do Model</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Bit Ctrl Do Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public <T extends SystemObjekt> T1 caseBitCtrlDoModel(BitCtrlDoModel<T> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Kompositum</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Kompositum</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public <T extends DoKomponente> T1 caseDoKompositum(DoKompositum<T> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Komponente</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Komponente</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoKomponente(DoKomponente object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Stufe</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Stufe</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomStufe(ZoomStufe object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Bild</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Bild</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoBild(DoBild object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Do Text</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Do Text</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseDoText(DoText object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Verbindungslinie</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Verbindungslinie</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseVerbindungslinie(Verbindungslinie object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseNamed(Named object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Located</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Located</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseLocated(Located object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Sized</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Sized</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSized(Sized object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Selektierbar Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Selektierbar Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseSelektierbarDecorator(SelektierbarDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Zoom Verhalten Fix Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Zoom Verhalten Fix Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T1 caseZoomVerhaltenFixDecorator(ZoomVerhaltenFixDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T1 defaultCase(EObject object) {
		return null;
	}

} // DobjSwitch
