/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.preferences;

public enum DobjPreference {

	/** Standardformat für einen Tooltip an Systemobjekt-DO. */
	TOOLTIP_FORMAT("tooltip_format", ""),

	/**
	 * Delay bevor der Tooltip an einem Systemobjekt-DO ausgeblendet wird in
	 * Millisekunden.
	 */
	TOOLTIP_HIDEDELAY("tooltip_hide_delay", "5000");

	private final String id;
	private final Object defaultValue;

	DobjPreference(final String id, final Object defaultValue) {
		this.id = id;
		this.defaultValue = defaultValue;
	}

	/**
	 * liefert den Standardwert der Einstellung.
	 *
	 * @return den Wert
	 */
	public Object getDefaultValue() {
		return defaultValue;
	}

	/**
	 * liefert die ID der Einstellung.
	 *
	 * @return die ID
	 */
	public String getId() {
		return id;
	}
}
