/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;

public class DobjPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	private static String[] helpLines = { "Das Standardformat für Tooltips kann durch Angabe von",
			"- {name} - der Name des Systemobjekts,", "- {pid} - die PID des Systemobjekts,",
			"- {info} - den Kurzinfotext,", "- {nlinfo} - den optionalen Infotext mit vorangesetztem Newline,",
			"- {desc} - dem Beschreibungstext,",
			"- {nldesc} - dem optional Beschreibungstext mit vorangestelltem Newline", "- {nl} - Newline oder",
			"jedem beliebigen anderen Zeichen definiert werden" };

	private static final String HELP_TEXT;

	static {
		final String buffer = String.join("\n", helpLines);

		HELP_TEXT = buffer;
	}

	@Override
	public void init(final IWorkbench workbench) {
		setPreferenceStore(DObjPlugin.getDefault().getPreferenceStore());
		setDescription("Allgemeine Einstellungen für Darstellungsobjekte");
	}

	@Override
	protected void createFieldEditors() {
		final Label label = new Label((Composite) getControl(), SWT.BORDER);
		label.setText(HELP_TEXT);
		GridDataFactory.fillDefaults().grab(true, true).applyTo(label);
		addField(new StringFieldEditor(DobjPreference.TOOLTIP_FORMAT.getId(), "Standard-Tooltip-Format",
				getFieldEditorParent()));
		addField(new StringFieldEditor(DobjPreference.TOOLTIP_HIDEDELAY.getId(), "Tooltip-Anzeigezeit im ms",
				getFieldEditorParent()));
	}
}
