/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Rotated;

import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Tabbed Property Section fï¿½r ein Darstellungsobjekt {@link DoModel}.
 *
 * <p>
 * Bearbeitbar sind die folgenden Eingenschaften:
 * <ul>
 * <li>Drehung</li>
 * </ul>
 * TODO: Fixpunkt konfigurierbar machen (anchor)!
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 */
public class RotatedSection extends AbstractSection<Rotated> {

	// drehung
	private Label drehungLabel;
	private Spinner drehungSpinner;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createDrehung(container);
	}

	private void createDrehung(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;

		drehungSpinner = new Spinner(parent, SWT.BORDER);
		drehungSpinner.setMinimum(-360);
		drehungSpinner.setMaximum(360);
		drehungSpinner.setIncrement(1);
		factory.adapt(parent);
		data = new FormData();
		data.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		drehungSpinner.setLayoutData(data);

		drehungLabel = factory.createLabel(parent, "Drehung:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(drehungSpinner, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(drehungSpinner, 0, SWT.CENTER);
		drehungLabel.setLayoutData(data);

		drehungSpinner.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final double value = drehungSpinner.getSelection();
				final SetCommand cmd = new SetCommand(getElement(), GefPackage.Literals.ROTATED__ANGLE, value);
				getCommandStack().execute(cmd);
			}

		});
	}

	@Override
	public void refresh() {
		if (drehungSpinner.getSelection() != getElement().getAngle().intValue()) {
			drehungSpinner.setSelection(getElement().getAngle().intValue());
		}

		final boolean isInKompositum = getElement().eContainer() instanceof DoKomponente;
		drehungLabel.setEnabled(!isInKompositum);
		drehungSpinner.setEnabled(!isInKompositum);

	}

}
