/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Scaled;

import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Tabbed Property Section für ein Darstellungsobjekt {@link DoModel}.
 *
 * <p>
 * Bearbeitbar sind die folgenden Eingenschaften:
 * <ul>
 * <li>Systemobjekt</li>
 * <li>relativ zu anderen Systemobjekt</li>
 * <li>Skalierungsfaktor</li>
 * </ul>
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class ScaledSection extends AbstractSection<Scaled> {

	// skalierung
	private Label skalierungLabel;
	private Spinner skalierungSpinner;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createSkalierung(container);
	}

	private void createSkalierung(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;

		skalierungSpinner = new Spinner(parent, SWT.BORDER);
		skalierungSpinner.setMinimum(1);
		skalierungSpinner.setMaximum(Integer.MAX_VALUE);
		skalierungSpinner.setDigits(3);
		skalierungSpinner.setIncrement(1000);
		skalierungSpinner.setPageIncrement(10000);
		factory.adapt(parent);
		data = new FormData();
		data.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		skalierungSpinner.setLayoutData(data);

		skalierungLabel = factory.createLabel(parent, "Skalierung:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(skalierungSpinner, -ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(skalierungSpinner, 0, SWT.CENTER);
		skalierungLabel.setLayoutData(data);

		skalierungSpinner.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				double value = skalierungSpinner.getSelection();
				value /= Math.pow(10, skalierungSpinner.getDigits());
				final SetCommand cmd = new SetCommand(getElement(), GefPackage.Literals.SCALED__SCALE, value);
				getCommandStack().execute(cmd);
			}

		});
	}

	@Override
	public void refresh() {
		final Double zoomSkalierung = getElement().getScale() * Math.pow(10, skalierungSpinner.getDigits());
		if (skalierungSpinner.getSelection() != zoomSkalierung.intValue()) {
			skalierungSpinner.setSelection(zoomSkalierung.intValue());
		}

		final boolean isInKompositum = getElement().eContainer() instanceof DoKomponente;
		skalierungLabel.setEnabled(!isInKompositum);
		skalierungSpinner.setEnabled(!isInKompositum);
	}

}
