/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.requests;

import org.eclipse.gef.Request;

/**
 * Request zur Aufforderung des Ein- und Auschaltens des Filters fuer
 * <b>alle</b> gueltige Baustellen.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 *
 */
public class BaustelleGueltigRequest extends Request {

	private final boolean baustelleGueltig;

	/**
	 * Initialisiert den Request.
	 *
	 * @param baustelleGueltig
	 *            das Flag ob der Filter fuer <b>alle</b> gueltige Baustellen
	 *            gesetzt ist.
	 */
	public BaustelleGueltigRequest(final boolean baustelleGueltig) {
		super(DobjRequestConstants.REQ_BAUSTELLE_GUELTIG);
		this.baustelleGueltig = baustelleGueltig;
	}

	/**
	 * Erfragt, ob alle gueltigen Baustellen eingeblendet werden sollen.
	 *
	 * @return ob alle gueltigen Baustellen eingeblendet werden sollen.
	 */
	public boolean isAlleGueltigenBaustellenAnzeigen() {
		return baustelleGueltig;
	}

}
