/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.tools;

/**
 * Kann als Basisklasse dienen für Tools die etwas per Drag tun. Der Vorgang
 * beginnt, wenn die linke Maustaste gedrück wird und endet, wenn die Maustaste
 * wieder losgelassen wird. Während die Maustaste gedrückt ist, wird ein
 * Feedback angezeigt, welches bei Bewegung der Maus aktualisiert wird.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public abstract class AbstractDragTool extends BaseTool {

	@Override
	protected boolean handleDragInProgress() {
		if (isInState(STATE_DRAG | STATE_DRAG_IN_PROGRESS)) {
			showFeedback();
		}
		return true;
	}

	@Override
	protected boolean handleButtonDown(final int button) {
		if (!isGraphicalViewer()) {
			return true;
		}
		if (button != 1) {
			setState(STATE_INVALID);
			handleInvalidInput();
		}
		stateTransition(STATE_INITIAL, STATE_DRAG_IN_PROGRESS);
		return true;
	}

	@Override
	protected boolean handleButtonUp(final int button) {
		if (stateTransition(STATE_DRAG_IN_PROGRESS, STATE_TERMINAL)) {
			eraseFeedback();
		}

		if (button == 1) {
			handleFinished();
		}
		return true;
	}

	@Override
	protected boolean handleInvalidInput() {
		eraseFeedback();
		return true;
	}

	@Override
	public void deactivate() {
		if (isInState(STATE_DRAG_IN_PROGRESS)) {
			eraseFeedback();
		}
		super.deactivate();
		setState(STATE_TERMINAL);
	}

	/**
	 * Wird aufgerufen, wenn die Feedback Figure angezeigt werden soll. Sollte
	 * {@link #addFeedback(org.eclipse.draw2d.IFigure)} aufrufen.
	 */
	protected abstract void showFeedback();

	/**
	 * Wird aufgerufen, wenn die Feedback Figure wieder entfernt werden soll.
	 * Sollte {@link #removeFeedback(org.eclipse.draw2d.IFigure)} aufrufen.
	 *
	 * @see #removeFeedback(org.eclipse.draw2d.IFigure)
	 */
	protected abstract void eraseFeedback();

}
