/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.tools;

import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

import de.bsvrz.buv.plugin.dobj.figures.EllipseFeedbackFigure;

public class EllipseSelectionTool extends RectangleSelectionTool {

	@Override
	protected String getCommandName() {
		return "Rechteckselektion";
	}

	@Override
	protected void calculateNewSelection(final Collection<EditPart> newSelections,
			final Collection<EditPart> deselections) {
		final Rectangle marqueeRect = getMarqueeSelectionRectangle();
		for (final Iterator<EditPart> itr = getAllChildren().iterator(); itr.hasNext();) {
			final GraphicalEditPart child = (GraphicalEditPart) itr.next();
			if (!isValidModel(child.getModel())) {
				continue;
			}

			final IFigure figure = child.getFigure();
			if (!child.isSelectable() || child.getTargetEditPart(MARQUEE_REQUEST) != child || !isFigureVisible(figure)
					|| !figure.isShowing()) {
				continue;
			}

			final Rectangle r = figure.getBounds().getCopy();
			figure.translateToAbsolute(r);

			final Ellipse2D marqueeEllipse = new Ellipse2D.Double();
			marqueeEllipse.setFrame(marqueeRect.x, marqueeRect.y, marqueeRect.width, marqueeRect.height);

			if (isTouchedSelection()) {
				if (marqueeEllipse.contains(r.x, r.y, r.width, r.height)
						|| marqueeEllipse.intersects(r.x, r.y, r.width, r.height)) {
					if (child.getSelected() == EditPart.SELECTED_NONE || getSelectionMode() != TOGGLE_MODE) {
						newSelections.add(child);
					} else {
						deselections.add(child);
					}
				}
			} else if (marqueeEllipse.contains(r.x, r.y, r.width, r.height)) {
				if (child.getSelected() == EditPart.SELECTED_NONE || getSelectionMode() != TOGGLE_MODE) {
					newSelections.add(child);
				} else {
					deselections.add(child);
				}
			}
		}
	}

	@Override
	protected IFigure createMarqueeFeedbackFigure() {
		return new EllipseFeedbackFigure();
	}

}
