/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.ZoomManager;

/**
 * Erlaubt das Verschieben des sichtbaren Ausschnitts.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 *
 */
public class PanTool extends BaseTool {

	private Point startPunkt;

	/**
	 * Initialisiert das Tool.
	 */
	public PanTool() {
		setDefaultCursor(Cursors.HAND);
		setUnloadWhenFinished(false);
	}

	@Override
	protected String getCommandName() {
		return "pan";
	}

	@Override
	protected boolean handleButtonDown(final int button) {
		if (button == 1) {
			final ZoomManager zm = getZoomManager();
			startPunkt = new Point(zm.getViewport().getHorizontalRangeModel().getValue(),
					zm.getViewport().getVerticalRangeModel().getValue());
		} else {
			handleInvalidInput();
		}
		return true;
	}

	@Override
	protected boolean handleDragInProgress() {
		if (startPunkt != null) {
			final ZoomManager zm = getZoomManager();
			final int divX = getStartLocation().x - getLocation().x;
			final int divY = getStartLocation().y - getLocation().y;
			zm.getViewport().setHorizontalLocation(startPunkt.x + divX);
			zm.getViewport().setVerticalLocation(startPunkt.y + divY);
		} else {
			handleInvalidInput();
		}

		return true;
	}

	@Override
	protected boolean handleButtonUp(final int button) {
		startPunkt = null;
		return true;
	}

	@Override
	protected boolean handleInvalidInput() {
		startPunkt = null;
		return super.handleInvalidInput();
	}

}
