/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.ZoomManager;

import de.bsvrz.buv.plugin.dobj.figures.RectangleFeedbackFigure;
import de.bsvrz.buv.plugin.dobj.util.DobjCursors;

/**
 * Wählt einen rechteckigen Bereich aus und zoomt dorthin.
 *
 * <p>
 * Der Viewer muss einen {@link ZoomManager} als Property besitzen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class RectangleZoomTool extends AbstractDragTool {

	private RectangleFeedbackFigure feedbackFigure;

	/**
	 * Initialisiert das Tool.
	 */
	public RectangleZoomTool() {
		setDefaultCursor(DobjCursors.ZoomIn.getCursor());
		setUnloadWhenFinished(false);
	}

	@Override
	protected String getCommandName() {
		return "zoom rectangle";
	}

	@Override
	protected void handleFinished() {
		final ZoomManager zoomManager = getZoomManager();

		/**
		 * TODO: Durch ZoomManager#zoomTo(Rectangle); ersetzen.
		 *
		 * Die Methode ist aber aktuell noch leer implementiert
		 */

		final Rectangle ausschnitt = new Rectangle(getStartLocation(), getLocation());
		if (ausschnitt.getSize().height > 10 && ausschnitt.getSize().width > 10) {
			final org.eclipse.draw2d.geometry.Point ursprung = new org.eclipse.draw2d.geometry.PrecisionPoint(
					zoomManager.getViewport().getHorizontalRangeModel().getValue() / zoomManager.getZoom()
							+ ausschnitt.getLocation().x / zoomManager.getZoom(),
					zoomManager.getViewport().getVerticalRangeModel().getValue() / zoomManager.getZoom()
							+ ausschnitt.getLocation().y / zoomManager.getZoom());

			final double currentZoom = zoomManager.getZoom();
			final double xZoom = currentZoom
					/ (ausschnitt.preciseWidth() / zoomManager.getViewport().getHorizontalRangeModel().getExtent());
			final double yZoom = currentZoom
					/ (ausschnitt.preciseHeight() / zoomManager.getViewport().getVerticalRangeModel().getExtent());

			if (Math.abs(currentZoom - xZoom) > Math.abs(currentZoom - yZoom)) {
				zoomManager.setZoom(yZoom);
			} else {
				zoomManager.setZoom(xZoom);
			}

			zoomManager.getViewport()
					.setHorizontalLocation((int) Math.round(ursprung.preciseX() * zoomManager.getZoom()));
			zoomManager.getViewport()
					.setVerticalLocation((int) Math.round(ursprung.preciseY() * zoomManager.getZoom()));
		}

		super.handleFinished();
	}

	private IFigure getFeedbackFigure() {
		if (feedbackFigure == null) {
			feedbackFigure = new RectangleFeedbackFigure();
			addFeedback(feedbackFigure);
		}
		return feedbackFigure;
	}

	@Override
	protected void showFeedback() {
		final Rectangle rect = getSelectionRectangle().getCopy();
		getFeedbackFigure().translateToRelative(rect);
		getFeedbackFigure().setBounds(rect);
	}

	private Rectangle getSelectionRectangle() {
		return new Rectangle(getStartLocation(), getLocation());
	}

	@Override
	protected void eraseFeedback() {
		if (feedbackFigure != null) {
			removeFeedback(feedbackFigure);
			feedbackFigure = null;
		}
	}

}
