/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import java.util.EventListener;

import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;

/**
 * Listener für Änderungen an den vorhandenen {@link Bild}ern in der
 * Konfiguration des Datenverteilers.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public interface BildListener extends EventListener {

	/**
	 * Ein Bild wurde neu angelegt.
	 *
	 * @param e
	 *            das Event mit dem neuen Bild.
	 */
	void bildAngelegt(BildEvent e);

	/**
	 * Ein vorhandenes Bild wurde gelöscht.
	 *
	 * @param e
	 *            das Event mit dem gelöschten Bild.
	 */
	void bildEntfernt(BildEvent e);

	/**
	 * Ein vorhandenes Bild wurde umbenannt.
	 *
	 * @param e
	 *            das Event mit dem umbenannten Bild.
	 */
	void bildUmbenannt(BildEvent e);

	/**
	 * der Zustand der Verbindung zur Verwaltung der Bilde rhat sich geändert.
	 *
	 * @param e
	 *            das Event
	 */
	void bildConnection(BildEvent e);

}
