/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import org.eclipse.jface.resource.ImageDescriptor;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;

/**
 * Stellt gemeinsam nutzbare Icons zur Verfügung.
 *
 * @author BitCtrl Systems GmbH, Schumann
 *
 */
public enum DobjIcons {

	// Actions

	/** Schaltfläche für Ausschnitt verschieben. */
	ActionPan("icons/16x16/actions/pan.png"),

	/** Schaltfläche für Ellipseselektion. */
	ActionSelectionEllipse("icons/16x16/actions/selection-ellipse.png"),

	/** Schaltfläche für Polygonselektion. */
	ActionSelectionPolygon("icons/16x16/actions/selection-polygon.png"),

	/** Schaltfläche für Rechteckselektion. */
	ActionSelectionRectangle("icons/16x16/actions/selection-rectangle.png"),

	/** Schaltfläche für Streckenselektion. */
	ActionSelectionStrecke("icons/16x16/actions/selection-strecke.png"),

	/** Schaltfläche für das Aktivieren der Teilselektion. */
	ActionToggleTouchedSelection("icons/16x16/actions/selection-toggle-touched.png"),

	/** Schaltfläche für das Beibehalten des Auschnitts. */
	ActionToggleFixViewport("icons/16x16/actions/fix-viewport.png"),

	/** Schaltfläche zum Online-/Offlineschalten einer Darstellung */
	ActionToggleOnline("icons/16x16/actions/toggle-online.png"),

	/** Icon für Hineinzoomen. */
	ActionZoomIn("icons/16x16/actions/zoom-in.gif"),

	/** Icon für Hinauszoomen. */
	ActionZoomOut("icons/16x16/actions/zoom-out.gif"),

	/** Schaltfläche für Rechteckzoom. */
	ActionZoomRectangle("icons/16x16/actions/zoom-rectangle.png"),

	/** Schaltfläche für das Wiederherstellen eines Defaultwert. */
	ActionRestoreDefault("icons/16x16/actions/restore-default.gif"),

	/**
	 * Schaltfläche zum Ein- und Ausblenden der Verbindungslinien von
	 * verschobenen Objekten zu ihrer Originalposition.
	 */
	ActionToggleVerbindingslinie("icons/16x16/actions/toogle-verbindungslinie.png"),

	/**
	 * Schaltflueche zum Ein- und Ausblenden des Filters fuer <b>alle</b>
	 * gueltige Baustellen.
	 */
	ActionToggleBaustelleGueltig("icons/16x16/actions/toggle-baustellegueltig.png"),

	/**
	 * Schaltfläche zum Ein- und Ausblenden der sofortigen Selektion.
	 */
	ActionToggleSelectionFeedback("icons/16x16/actions/toogle-selection-feedback.gif"),

	/**
	 * Schaltfläche zum Ein- und Ausschalten des Antikollisionsalgorithmus.
	 */
	ActionToggleAntikollisionsAlgorithmus("icons/16x16/actions/toogle-antikollisionsalgorithmus.png"),

	;

	private final ImageDescriptor imageDescriptor;

	DobjIcons(final String imagePath) {
		imageDescriptor = DObjPlugin.getDefault().getImageDescriptor(imagePath);
		if (imageDescriptor == null) {
			final String message = "Datei nicht gefunden: " + imagePath;
			DObjPlugin.getDefault().getLog().error(message);
		}
	}

	/**
	 * Gibt den {@link ImageDescriptor} zurück.
	 */
	public ImageDescriptor getImageDescriptor() {
		return imageDescriptor;
	}

}
