/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import java.util.EventObject;

import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;

/**
 * Dieses Event wird verteilt, wenn sich die in der Konfiguration des
 * Datenverteilers vorhandenen {@link PortableBitMap}s geändert haben.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class PortableBitMapEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	private final PortableBitMap portableBitMap;

	/**
	 * Initialisiert das Event.
	 *
	 * @param source
	 *            die Quelle des Events.
	 * @param portableBitmap
	 *            die {@link PortableBitMap}, die sich geändert hat.
	 */
	public PortableBitMapEvent(final PortableBitMapManager source, final PortableBitMap portableBitmap) {
		super(source);
		portableBitMap = portableBitmap;
	}

	/**
	 * liefert die {@link PortableBitMap}, die sich geändert hat zurück.
	 *
	 * @return die geänderte {@link PortableBitMap}.
	 */
	public PortableBitMap getPortableBitMap() {
		return portableBitMap;
	}

}
