/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.util;

import java.util.HashSet;
import java.util.Set;

import de.bsvrz.buv.plugin.dobj.model.DoTyp;

public class SelectionProperties {

	private boolean selectTouched;
	private boolean showFeedback;
	private Set<DoTyp> matchDoTypen;

	public boolean isSelectTouched() {
		return selectTouched;
	}

	public void setSelectTouched(final boolean selectTouched) {
		this.selectTouched = selectTouched;
	}

	public boolean isShowFeedback() {
		return showFeedback;
	}

	public void setShowFeedback(final boolean showFeedback) {
		this.showFeedback = showFeedback;
	}

	public Set<DoTyp> getMatchDoTypen() {
		if (matchDoTypen == null) {
			matchDoTypen = new HashSet<>();
		}
		return matchDoTypen;
	}

}
