/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.vektor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.geometry.PointList;

class PKStack {

	private final List<ParallelKomplex> list = new ArrayList<>();

	private PointList punkte;

	final ParallelKomplex popGet() {
		if (list.isEmpty()) {
			return null;
		}
		return list.get(list.size() - 1);
	}

	final void push(final ParallelKomplex pk) {
		list.add(pk);
	}

	public final PointList getPunkte() {
		if (punkte == null) {
			punkte = new PointList();
			int i = 0;
			for (; i < list.size(); i++) {
				punkte.addPoint(list.get(i).getpSchnittMitVorgaenger());
			}
			punkte.addPoint(list.get(i - 1).getpSchnittMitNachfolger());
		}
		return punkte;
	}

}
