/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.viewers;

import java.util.Arrays;
import java.util.Collection;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.bitctrl.lib.eclipse.emf.util.EmfComparator;

import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.util.DoTypenUtil;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.util.SystemObjectComparator;

public class DoTypenTreeContentProvider implements ITreeContentProvider {

	private SortedMap<SystemObjectType, SortedSet<DoTyp>> mappings;

	@Override
	public Object[] getElements(final Object inputElement) {
		mappings = new TreeMap<>(new SystemObjectComparator());

		Collection<DoTyp> doTypen;
		if (inputElement instanceof Collection) {
			doTypen = (Collection<DoTyp>) inputElement;
		} else if (inputElement instanceof Object[]) {
			doTypen = Arrays.asList((DoTyp[]) inputElement);
		} else {
			doTypen = DoTypenUtil.getDoTypen();
		}

		for (final DoTyp doTyp : doTypen) {
			final SystemObjectType type = doTyp.getSystemObjectType();
			if (type != null) {
				if (!mappings.containsKey(type)) {
					mappings.put(type, new TreeSet<>(new EmfComparator()));
				}
				mappings.get(type).add(doTyp);
			}
		}

		return mappings.keySet().toArray();
	}

	@Override
	public boolean hasChildren(final Object element) {
		if (element instanceof SystemObjectType) {
			return mappings.containsKey(element) && !mappings.get(element).isEmpty();
		}

		return false;
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		if (parentElement instanceof SystemObjectType) {
			return mappings.get(parentElement).toArray();
		}

		return new Object[0];
	}

	@Override
	public Object getParent(final Object element) {
		if (element instanceof DoTyp) {
			return ((DoTyp) element).getSystemObjectType();
		}
		return null;
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// tut nix
	}

	@Override
	public void dispose() {
		// tut nix
	}

}