/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.figures;

import org.eclipse.draw2d.ScalableFigure;

import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;

/**
 * Schnittstelle für eine Figur, die zum Zeichnen eines mit dem DOT-Editor
 * erstellten Darstelungsobjekttyps verwednet wird.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public interface VisibleFormFigure extends ScalableFigure {

	/**
	 * liest die Daten des zugeordneten Modellobjekts aus und aktualisiert das
	 * visuelle Erscheinungsbild.
	 *
	 * Das Modellobjekt eines {@link VisibleFormFigure} wird bereits im
	 * Konstruktor übergeben.
	 */
	void aktualisiereVomModel();

	/**
	 * dekoriert die mit der übergebenen Definition festgelegten Eigenschaften
	 * an der Figur.
	 *
	 * Als Eigenschaften sind folgende definiert:
	 * <ul>
	 * <li>BackgroundParameterDefinition</li>
	 * <li>ForegroundParameterDefinition</li>
	 * <li>DrehwinkelParameterDefinition</li>
	 * <li>FontDataParameterDefinition</li>
	 * <li>LineAttributeParameterDefinition</li>
	 * <li>SichtbarkeitParameterDefinition</li>
	 * <li>StringParameterDefinition</li>
	 * <li>ZoomVerhaltenParameterDefinition</li>
	 * </ul>
	 *
	 * @param definition
	 *            die Beschreibung der zu dekorierenden Eigenschaft
	 * @param datenSatz
	 *            der Datensatz mit den darzustellenden Daten
	 */
	void decorate(ParameterDefinition definition, DecoratorDatenSatz datenSatz);
}
