/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory
 * @model kind="package"
 * @generated
 */
public interface DoeditorPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "doeditor";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://de.bsvrz.buv.plugin.doeditor/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "doeditor";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	DoeditorPackage eINSTANCE = de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl.init();

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm
	 * <em>Visible Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getVisibleForm()
	 * @generated
	 */
	int VISIBLE_FORM = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VISIBLE_FORM__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VISIBLE_FORM__LOCATION = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VISIBLE_FORM__EDITOR_DO_TYP = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int VISIBLE_FORM__VISIBLE = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VISIBLE_FORM__DECORATORS = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Visible Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VISIBLE_FORM_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.RotatableForm <em>Rotatable Form</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.RotatableForm
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getRotatableForm()
	 * @generated
	 */
	int ROTATABLE_FORM = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM__NAME = VISIBLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM__LOCATION = VISIBLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM__EDITOR_DO_TYP = VISIBLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM__VISIBLE = VISIBLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM__DECORATORS = VISIBLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM__ANGLE = VISIBLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Rotatable Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROTATABLE_FORM_FEATURE_COUNT = VISIBLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.BorderedForm
	 * <em>Bordered Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderedForm
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderedForm()
	 * @generated
	 */
	int BORDERED_FORM = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__NAME = VISIBLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__LOCATION = VISIBLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__EDITOR_DO_TYP = VISIBLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__VISIBLE = VISIBLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__DECORATORS = VISIBLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Border Width</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__BORDER_WIDTH = VISIBLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Border Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM__BORDER_COLOR = VISIBLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Bordered Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDERED_FORM_FEATURE_COUNT = VISIBLE_FORM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomableForm
	 * <em>Zoomable Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomableForm
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomableForm()
	 * @generated
	 */
	int ZOOMABLE_FORM = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM__NAME = VISIBLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM__LOCATION = VISIBLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM__EDITOR_DO_TYP = VISIBLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM__VISIBLE = VISIBLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM__DECORATORS = VISIBLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM__ZOOM_VERHALTEN = VISIBLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Zoomable Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOMABLE_FORM_FEATURE_COUNT = VISIBLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.PunktFormImpl
	 * <em>Punkt Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.PunktFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPunktForm()
	 * @generated
	 */
	int PUNKT_FORM = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__NAME = ROTATABLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__LOCATION = ROTATABLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__EDITOR_DO_TYP = ROTATABLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__VISIBLE = ROTATABLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__DECORATORS = ROTATABLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__ANGLE = ROTATABLE_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__ZOOM_VERHALTEN = ROTATABLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__POSITIONIERUNG = ROTATABLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__BOUNDS = ROTATABLE_FORM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM__FOREGROUND_COLOR = ROTATABLE_FORM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Punkt Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUNKT_FORM_FEATURE_COUNT = ROTATABLE_FORM_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BildFormImpl <em>Bild Form</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BildFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBildForm()
	 * @generated
	 */
	int BILD_FORM = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__NAME = ROTATABLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__LOCATION = ROTATABLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__EDITOR_DO_TYP = ROTATABLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__VISIBLE = ROTATABLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__DECORATORS = ROTATABLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__ANGLE = ROTATABLE_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__ZOOM_VERHALTEN = ROTATABLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bild</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM__BILD = ROTATABLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Bild Form</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BILD_FORM_FEATURE_COUNT = ROTATABLE_FORM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl <em>Text Form</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getTextForm()
	 * @generated
	 */
	int TEXT_FORM = 6;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.LinienFormImpl
	 * <em>Linien Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LinienFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLinienForm()
	 * @generated
	 */
	int LINIEN_FORM = 12;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl
	 * <em>Polyline Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPolylineForm()
	 * @generated
	 */
	int POLYLINE_FORM = 7;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl
	 * <em>Polygon Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPolygonForm()
	 * @generated
	 */
	int POLYGON_FORM = 8;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl
	 * <em>Flaechen Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFlaechenForm()
	 * @generated
	 */
	int FLAECHEN_FORM = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__NAME = PUNKT_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__LOCATION = PUNKT_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__EDITOR_DO_TYP = PUNKT_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__VISIBLE = PUNKT_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__DECORATORS = PUNKT_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__ANGLE = PUNKT_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__ZOOM_VERHALTEN = PUNKT_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__POSITIONIERUNG = PUNKT_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__BOUNDS = PUNKT_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__FOREGROUND_COLOR = PUNKT_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM__LINE_ATTRIBUTES = PUNKT_FORM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Linien Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINIEN_FORM_FEATURE_COUNT = PUNKT_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__NAME = LINIEN_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__LOCATION = LINIEN_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__EDITOR_DO_TYP = LINIEN_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__VISIBLE = LINIEN_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__DECORATORS = LINIEN_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__ANGLE = LINIEN_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__ZOOM_VERHALTEN = LINIEN_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__POSITIONIERUNG = LINIEN_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__BOUNDS = LINIEN_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__FOREGROUND_COLOR = LINIEN_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__LINE_ATTRIBUTES = LINIEN_FORM__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__SIZE = LINIEN_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Background Pattern</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__BACKGROUND_PATTERN = LINIEN_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Filled</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__FILLED = LINIEN_FORM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Background Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM__BACKGROUND_COLOR = LINIEN_FORM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Flaechen Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FLAECHEN_FORM_FEATURE_COUNT = LINIEN_FORM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__NAME = FLAECHEN_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__LOCATION = FLAECHEN_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__EDITOR_DO_TYP = FLAECHEN_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__VISIBLE = FLAECHEN_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__DECORATORS = FLAECHEN_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__ANGLE = FLAECHEN_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__ZOOM_VERHALTEN = FLAECHEN_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__POSITIONIERUNG = FLAECHEN_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__BOUNDS = FLAECHEN_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__FOREGROUND_COLOR = FLAECHEN_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__LINE_ATTRIBUTES = FLAECHEN_FORM__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__SIZE = FLAECHEN_FORM__SIZE;

	/**
	 * The feature id for the '<em><b>Background Pattern</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__BACKGROUND_PATTERN = FLAECHEN_FORM__BACKGROUND_PATTERN;

	/**
	 * The feature id for the '<em><b>Filled</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__FILLED = FLAECHEN_FORM__FILLED;

	/**
	 * The feature id for the '<em><b>Background Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__BACKGROUND_COLOR = FLAECHEN_FORM__BACKGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Border Width</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__BORDER_WIDTH = FLAECHEN_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Border Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__BORDER_COLOR = FLAECHEN_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__TEXT = FLAECHEN_FORM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Horizontal Alignment</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__HORIZONTAL_ALIGNMENT = FLAECHEN_FORM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Vertical Alignment</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__VERTICAL_ALIGNMENT = FLAECHEN_FORM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Font</b></em>' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM__FONT = FLAECHEN_FORM_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Text Form</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_FORM_FEATURE_COUNT = FLAECHEN_FORM_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__NAME = LINIEN_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__LOCATION = LINIEN_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__EDITOR_DO_TYP = LINIEN_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__VISIBLE = LINIEN_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__DECORATORS = LINIEN_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__ANGLE = LINIEN_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__ZOOM_VERHALTEN = LINIEN_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__POSITIONIERUNG = LINIEN_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__BOUNDS = LINIEN_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__FOREGROUND_COLOR = LINIEN_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__LINE_ATTRIBUTES = LINIEN_FORM__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Points</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM__POINTS = LINIEN_FORM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Polyline Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYLINE_FORM_FEATURE_COUNT = LINIEN_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__NAME = POLYLINE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__LOCATION = POLYLINE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__EDITOR_DO_TYP = POLYLINE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__VISIBLE = POLYLINE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__DECORATORS = POLYLINE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__ANGLE = POLYLINE_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__ZOOM_VERHALTEN = POLYLINE_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__POSITIONIERUNG = POLYLINE_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__BOUNDS = POLYLINE_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__FOREGROUND_COLOR = POLYLINE_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__LINE_ATTRIBUTES = POLYLINE_FORM__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Points</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__POINTS = POLYLINE_FORM__POINTS;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__SIZE = POLYLINE_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Background Pattern</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__BACKGROUND_PATTERN = POLYLINE_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Filled</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__FILLED = POLYLINE_FORM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Background Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM__BACKGROUND_COLOR = POLYLINE_FORM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Polygon Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_FORM_FEATURE_COUNT = POLYLINE_FORM_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.EllipseFormImpl
	 * <em>Ellipse Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EllipseFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEllipseForm()
	 * @generated
	 */
	int ELLIPSE_FORM = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__NAME = FLAECHEN_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__LOCATION = FLAECHEN_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__EDITOR_DO_TYP = FLAECHEN_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__VISIBLE = FLAECHEN_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__DECORATORS = FLAECHEN_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__ANGLE = FLAECHEN_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__ZOOM_VERHALTEN = FLAECHEN_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__POSITIONIERUNG = FLAECHEN_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__BOUNDS = FLAECHEN_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__FOREGROUND_COLOR = FLAECHEN_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__LINE_ATTRIBUTES = FLAECHEN_FORM__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__SIZE = FLAECHEN_FORM__SIZE;

	/**
	 * The feature id for the '<em><b>Background Pattern</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__BACKGROUND_PATTERN = FLAECHEN_FORM__BACKGROUND_PATTERN;

	/**
	 * The feature id for the '<em><b>Filled</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__FILLED = FLAECHEN_FORM__FILLED;

	/**
	 * The feature id for the '<em><b>Background Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM__BACKGROUND_COLOR = FLAECHEN_FORM__BACKGROUND_COLOR;

	/**
	 * The number of structural features of the '<em>Ellipse Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSE_FORM_FEATURE_COUNT = FLAECHEN_FORM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.RechteckFormImpl
	 * <em>Rechteck Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.RechteckFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getRechteckForm()
	 * @generated
	 */
	int RECHTECK_FORM = 11;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__NAME = FLAECHEN_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__LOCATION = FLAECHEN_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__EDITOR_DO_TYP = FLAECHEN_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__VISIBLE = FLAECHEN_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__DECORATORS = FLAECHEN_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__ANGLE = FLAECHEN_FORM__ANGLE;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__ZOOM_VERHALTEN = FLAECHEN_FORM__ZOOM_VERHALTEN;

	/**
	 * The feature id for the '<em><b>Positionierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__POSITIONIERUNG = FLAECHEN_FORM__POSITIONIERUNG;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__BOUNDS = FLAECHEN_FORM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Foreground Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__FOREGROUND_COLOR = FLAECHEN_FORM__FOREGROUND_COLOR;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__LINE_ATTRIBUTES = FLAECHEN_FORM__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__SIZE = FLAECHEN_FORM__SIZE;

	/**
	 * The feature id for the '<em><b>Background Pattern</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__BACKGROUND_PATTERN = FLAECHEN_FORM__BACKGROUND_PATTERN;

	/**
	 * The feature id for the '<em><b>Filled</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__FILLED = FLAECHEN_FORM__FILLED;

	/**
	 * The feature id for the '<em><b>Background Color</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM__BACKGROUND_COLOR = FLAECHEN_FORM__BACKGROUND_COLOR;

	/**
	 * The number of structural features of the '<em>Rechteck Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECHTECK_FORM_FEATURE_COUNT = FLAECHEN_FORM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.DecoratorImpl <em>Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDecorator()
	 * @generated
	 */
	int DECORATOR = 13;

	/**
	 * The number of structural features of the '<em>Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DECORATOR_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.TextDecorator <em>Text Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextDecorator
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getTextDecorator()
	 * @generated
	 */
	int TEXT_DECORATOR = 14;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEXT_DECORATOR__TEXT = DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Text Decorator</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_DECORATOR_FEATURE_COUNT = DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeDecoratorImpl <em>Attribute Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.AttributeDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getAttributeDecorator()
	 * @generated
	 */
	int ATTRIBUTE_DECORATOR = 15;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE = DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_DECORATOR__ASPEKT = DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD = DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Attribute Decorator</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_DECORATOR_FEATURE_COUNT = DECORATOR_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator <em>Interval Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getIntervalDecorator()
	 * @generated
	 */
	int INTERVAL_DECORATOR = 16;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERVAL_DECORATOR__START = DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERVAL_DECORATOR__END = DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interval Decorator</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERVAL_DECORATOR_FEATURE_COUNT = DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomDecoratorImpl <em>Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomDecorator()
	 * @generated
	 */
	int ZOOM_DECORATOR = 17;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_DECORATOR__START = INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_DECORATOR__END = INTERVAL_DECORATOR__END;

	/**
	 * The number of structural features of the '<em>Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOM_DECORATOR_FEATURE_COUNT = INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl <em>Editor Do Model</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEditorDoModel()
	 * @generated
	 */
	int EDITOR_DO_MODEL = 18;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__NAME = DobjPackage.DO_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__LOCATION = DobjPackage.DO_MODEL__LOCATION;

	/**
	 * The feature id for the '<em><b>Komponenten Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__KOMPONENTEN_ID = DobjPackage.DO_MODEL__KOMPONENTEN_ID;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__DO_TYP = DobjPackage.DO_MODEL__DO_TYP;

	/**
	 * The feature id for the '<em><b>System Object</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__SYSTEM_OBJECT = DobjPackage.DO_MODEL__SYSTEM_OBJECT;

	/**
	 * The feature id for the '<em><b>Relativ Zu</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__RELATIV_ZU = DobjPackage.DO_MODEL__RELATIV_ZU;

	/**
	 * The feature id for the '<em><b>Absolute Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__ABSOLUTE_LOCATION = DobjPackage.DO_MODEL__ABSOLUTE_LOCATION;

	/**
	 * The feature id for the '<em><b>Ausgehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__AUSGEHENDE_VERBINDUNGEN = DobjPackage.DO_MODEL__AUSGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Eingehende Verbindungen</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__EINGEHENDE_VERBINDUNGEN = DobjPackage.DO_MODEL__EINGEHENDE_VERBINDUNGEN;

	/**
	 * The feature id for the '<em><b>Komponenten</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__KOMPONENTEN = DobjPackage.DO_MODEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__SKALIERUNGSFAKTOR = DobjPackage.DO_MODEL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Drehwinkel</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL__DREHWINKEL = DobjPackage.DO_MODEL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Editor Do Model</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_MODEL_FEATURE_COUNT = DobjPackage.DO_MODEL_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl <em>Attribute Text Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getAttributeTextDecorator()
	 * @generated
	 */
	int ATTRIBUTE_TEXT_DECORATOR = 19;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_DECORATOR__TEXT = TEXT_DECORATOR__TEXT;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = TEXT_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_DECORATOR__ASPEKT = TEXT_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = TEXT_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Attribute Text Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = TEXT_DECORATOR_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeIntervalDecoratorImpl <em>Attribute Interval Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.AttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getAttributeIntervalDecorator()
	 * @generated
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR = 20;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR__START = INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR__END = INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = INTERVAL_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Attribute Interval Decorator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = INTERVAL_DECORATOR_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeIntervalDecoratorImpl
	 * <em>Background Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundAttributeIntervalDecorator()
	 * @generated
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR = 21;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START = ATTRIBUTE_INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END = ATTRIBUTE_INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '
	 * <em>Background Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition <em>Parameter Definition</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getParameterDefinition()
	 * @generated
	 */
	int PARAMETER_DEFINITION = 22;

	/**
	 * The number of structural features of the '<em>Parameter Definition</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_DEFINITION_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition <em>Color Parameter Definition</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getColorParameterDefinition()
	 * @generated
	 */
	int COLOR_PARAMETER_DEFINITION = 23;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLOR_PARAMETER_DEFINITION__START_COLOR = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLOR_PARAMETER_DEFINITION__END_COLOR = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Color Parameter Definition</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COLOR_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition <em>Background Parameter Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundParameterDefinition()
	 * @generated
	 */
	int BACKGROUND_PARAMETER_DEFINITION = 24;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_PARAMETER_DEFINITION__START_COLOR = COLOR_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_PARAMETER_DEFINITION__END_COLOR = COLOR_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The number of structural features of the '<em>Background Parameter Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT = COLOR_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition <em>Foreground Parameter Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundParameterDefinition()
	 * @generated
	 */
	int FOREGROUND_PARAMETER_DEFINITION = 25;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_PARAMETER_DEFINITION__START_COLOR = COLOR_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_PARAMETER_DEFINITION__END_COLOR = COLOR_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The number of structural features of the '<em>Foreground Parameter Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT = COLOR_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition <em>Border Color Parameter Definition</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorParameterDefinition()
	 * @generated
	 */
	int BORDER_COLOR_PARAMETER_DEFINITION = 26;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_PARAMETER_DEFINITION__START_COLOR = COLOR_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_PARAMETER_DEFINITION__END_COLOR = COLOR_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The number of structural features of the '<em>Border Color Parameter Definition</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_PARAMETER_DEFINITION_FEATURE_COUNT = COLOR_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition <em>Font Data Parameter Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataParameterDefinition()
	 * @generated
	 */
	int FONT_DATA_PARAMETER_DEFINITION = 27;

	/**
	 * The feature id for the '<em><b>Font</b></em>' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_PARAMETER_DEFINITION__FONT = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Font Data Parameter Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition <em>Drehwinkel Parameter Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelParameterDefinition()
	 * @generated
	 */
	int DREHWINKEL_PARAMETER_DEFINITION = 28;

	/**
	 * The feature id for the '<em><b>Start Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_PARAMETER_DEFINITION__START_WINKEL = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_PARAMETER_DEFINITION__END_WINKEL = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Drehwinkel Parameter Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition <em>Line Attribute Parameter Definition</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeParameterDefinition()
	 * @generated
	 */
	int LINE_ATTRIBUTE_PARAMETER_DEFINITION = 29;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_PARAMETER_DEFINITION__LINE_ATTRIBUTES = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Line Attribute Parameter Definition</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition <em>String Parameter Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringParameterDefinition()
	 * @generated
	 */
	int STRING_PARAMETER_DEFINITION = 30;

	/**
	 * The feature id for the '<em><b>String</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_PARAMETER_DEFINITION__STRING = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Parameter Definition</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition <em>Sichtbarkeit Parameter Definition</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitParameterDefinition()
	 * @generated
	 */
	int SICHTBARKEIT_PARAMETER_DEFINITION = 31;

	/**
	 * The feature id for the '<em><b>Sichtbar</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_PARAMETER_DEFINITION__SICHTBAR = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Sichtbarkeit Parameter Definition</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition <em>Zoom Verhalten Parameter Definition</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenParameterDefinition()
	 * @generated
	 */
	int ZOOM_VERHALTEN_PARAMETER_DEFINITION = 32;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_PARAMETER_DEFINITION__ZOOM_VERHALTEN = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Zoom Verhalten Parameter Definition</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeTextDecoratorImpl <em>Background Attribute Text Decorator</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundAttributeTextDecorator()
	 * @generated
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR = 33;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR__START_COLOR = BACKGROUND_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR__END_COLOR = BACKGROUND_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR__TEXT = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Background Attribute Text Decorator</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundZoomDecoratorImpl <em>Background Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundZoomDecorator()
	 * @generated
	 */
	int BACKGROUND_ZOOM_DECORATOR = 34;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ZOOM_DECORATOR__START_COLOR = BACKGROUND_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ZOOM_DECORATOR__END_COLOR = BACKGROUND_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ZOOM_DECORATOR__START = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ZOOM_DECORATOR__END = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Background Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACKGROUND_ZOOM_DECORATOR_FEATURE_COUNT = BACKGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeTextDecoratorImpl <em>Drehwinkel Attribute Text Decorator</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelAttributeTextDecorator()
	 * @generated
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR = 35;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR__TEXT = ATTRIBUTE_TEXT_DECORATOR__TEXT;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = ATTRIBUTE_TEXT_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR__START_WINKEL = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR__END_WINKEL = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Drehwinkel Attribute Text Decorator</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeIntervalDecoratorImpl
	 * <em>Drehwinkel Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelAttributeIntervalDecorator()
	 * @generated
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR = 36;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START = ATTRIBUTE_INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END = ATTRIBUTE_INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__START_WINKEL = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR__END_WINKEL = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '
	 * <em>Drehwinkel Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelZoomDecoratorImpl <em>Drehwinkel Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelZoomDecorator()
	 * @generated
	 */
	int DREHWINKEL_ZOOM_DECORATOR = 37;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ZOOM_DECORATOR__START = ZOOM_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ZOOM_DECORATOR__END = ZOOM_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Start Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ZOOM_DECORATOR__START_WINKEL = ZOOM_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Winkel</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ZOOM_DECORATOR__END_WINKEL = ZOOM_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Drehwinkel Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DREHWINKEL_ZOOM_DECORATOR_FEATURE_COUNT = ZOOM_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeIntervalDecoratorImpl
	 * <em>Font Data Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataAttributeIntervalDecorator()
	 * @generated
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR = 38;

	/**
	 * The feature id for the '<em><b>Font</b></em>' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR__FONT = FONT_DATA_PARAMETER_DEFINITION__FONT;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR__START = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR__END = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '
	 * <em>Font Data Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeTextDecoratorImpl <em>Font Data Attribute Text Decorator</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataAttributeTextDecorator()
	 * @generated
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR = 39;

	/**
	 * The feature id for the '<em><b>Font</b></em>' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR__FONT = FONT_DATA_PARAMETER_DEFINITION__FONT;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR__TEXT = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Font Data Attribute Text Decorator</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl <em>Font Data Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataZoomDecorator()
	 * @generated
	 */
	int FONT_DATA_ZOOM_DECORATOR = 40;

	/**
	 * The feature id for the '<em><b>Font</b></em>' containment reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ZOOM_DECORATOR__FONT = FONT_DATA_PARAMETER_DEFINITION__FONT;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ZOOM_DECORATOR__START = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ZOOM_DECORATOR__END = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Font Data Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FONT_DATA_ZOOM_DECORATOR_FEATURE_COUNT = FONT_DATA_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeTextDecoratorImpl <em>Foreground Attribute Text Decorator</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundAttributeTextDecorator()
	 * @generated
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR = 41;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR__START_COLOR = FOREGROUND_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR__END_COLOR = FOREGROUND_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR__TEXT = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Foreground Attribute Text Decorator</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeIntervalDecoratorImpl
	 * <em>Foreground Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundAttributeIntervalDecorator()
	 * @generated
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR = 42;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR = FOREGROUND_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR = FOREGROUND_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__START = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__END = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '
	 * <em>Foreground Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl <em>Foreground Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundZoomDecorator()
	 * @generated
	 */
	int FOREGROUND_ZOOM_DECORATOR = 43;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ZOOM_DECORATOR__START_COLOR = FOREGROUND_PARAMETER_DEFINITION__START_COLOR;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ZOOM_DECORATOR__END_COLOR = FOREGROUND_PARAMETER_DEFINITION__END_COLOR;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ZOOM_DECORATOR__START = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ZOOM_DECORATOR__END = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Foreground Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FOREGROUND_ZOOM_DECORATOR_FEATURE_COUNT = FOREGROUND_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl
	 * <em>Line Attribute Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeAttributeIntervalDecorator()
	 * @generated
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR = 44;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES = LINE_ATTRIBUTE_PARAMETER_DEFINITION__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT
			+ 4;

	/**
	 * The number of structural features of the '
	 * <em>Line Attribute Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT
			+ 5;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeTextDecoratorImpl
	 * <em>Line Attribute Attribute Text Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeAttributeTextDecorator()
	 * @generated
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR = 45;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR__LINE_ATTRIBUTES = LINE_ATTRIBUTE_PARAMETER_DEFINITION__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR__TEXT = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT
			+ 1;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '
	 * <em>Line Attribute Attribute Text Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeZoomDecoratorImpl <em>Line Attribute Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeZoomDecorator()
	 * @generated
	 */
	int LINE_ATTRIBUTE_ZOOM_DECORATOR = 46;

	/**
	 * The feature id for the '<em><b>Line Attributes</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ZOOM_DECORATOR__LINE_ATTRIBUTES = LINE_ATTRIBUTE_PARAMETER_DEFINITION__LINE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ZOOM_DECORATOR__START = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ZOOM_DECORATOR__END = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Line Attribute Zoom Decorator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_ATTRIBUTE_ZOOM_DECORATOR_FEATURE_COUNT = LINE_ATTRIBUTE_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeTextDecoratorImpl
	 * <em>Sichtbarkeit Attribute Text Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitAttributeTextDecorator()
	 * @generated
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR = 47;

	/**
	 * The feature id for the '<em><b>Sichtbar</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR__SICHTBAR = SICHTBARKEIT_PARAMETER_DEFINITION__SICHTBAR;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR__TEXT = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '
	 * <em>Sichtbarkeit Attribute Text Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeIntervalDecoratorImpl
	 * <em>Sichtbarkeit Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitAttributeIntervalDecorator()
	 * @generated
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR = 48;

	/**
	 * The feature id for the '<em><b>Sichtbar</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR__SICHTBAR = SICHTBARKEIT_PARAMETER_DEFINITION__SICHTBAR;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR__START = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR__END = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT
			+ 2;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '
	 * <em>Sichtbarkeit Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitZoomDecoratorImpl <em>Sichtbarkeit Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitZoomDecorator()
	 * @generated
	 */
	int SICHTBARKEIT_ZOOM_DECORATOR = 49;

	/**
	 * The feature id for the '<em><b>Sichtbar</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ZOOM_DECORATOR__SICHTBAR = SICHTBARKEIT_PARAMETER_DEFINITION__SICHTBAR;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ZOOM_DECORATOR__START = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ZOOM_DECORATOR__END = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Sichtbarkeit Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SICHTBARKEIT_ZOOM_DECORATOR_FEATURE_COUNT = SICHTBARKEIT_PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeIntervalDecoratorImpl <em>String Attribute Interval Decorator</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringAttributeIntervalDecorator()
	 * @generated
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR = 50;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR__START = ATTRIBUTE_INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR__END = ATTRIBUTE_INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>String</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR__STRING = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Attribute Interval Decorator</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeTextDecoratorImpl <em>String Attribute Text Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringAttributeTextDecorator()
	 * @generated
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR = 51;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR__TEXT = ATTRIBUTE_TEXT_DECORATOR__TEXT;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = ATTRIBUTE_TEXT_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>String</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR__STRING = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Attribute Text Decorator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.StringZoomDecoratorImpl <em>String Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.StringZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringZoomDecorator()
	 * @generated
	 */
	int STRING_ZOOM_DECORATOR = 52;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ZOOM_DECORATOR__START = ZOOM_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ZOOM_DECORATOR__END = ZOOM_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>String</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_ZOOM_DECORATOR__STRING = ZOOM_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>String Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_ZOOM_DECORATOR_FEATURE_COUNT = ZOOM_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeIntervalDecoratorImpl
	 * <em>Zoom Verhalten Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenAttributeIntervalDecorator()
	 * @generated
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR = 53;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR__START = ATTRIBUTE_INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR__END = ATTRIBUTE_INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR__ZOOM_VERHALTEN = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '
	 * <em>Zoom Verhalten Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeTextDecoratorImpl
	 * <em>Zoom Verhalten Attribute Text Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenAttributeTextDecorator()
	 * @generated
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR = 54;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__TEXT = ATTRIBUTE_TEXT_DECORATOR__TEXT;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = ATTRIBUTE_TEXT_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR__ZOOM_VERHALTEN = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '
	 * <em>Zoom Verhalten Attribute Text Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenZoomDecoratorImpl <em>Zoom Verhalten Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenZoomDecorator()
	 * @generated
	 */
	int ZOOM_VERHALTEN_ZOOM_DECORATOR = 55;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ZOOM_DECORATOR__START = ZOOM_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ZOOM_DECORATOR__END = ZOOM_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Zoom Verhalten</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ZOOM_DECORATOR__ZOOM_VERHALTEN = ZOOM_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Zoom Verhalten Zoom Decorator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ZOOM_VERHALTEN_ZOOM_DECORATOR_FEATURE_COUNT = ZOOM_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EmbeddedDoFormImpl <em>Embedded Do Form</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EmbeddedDoFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEmbeddedDoForm()
	 * @generated
	 */
	int EMBEDDED_DO_FORM = 56;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__NAME = VISIBLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__LOCATION = VISIBLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__EDITOR_DO_TYP = VISIBLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__VISIBLE = VISIBLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__DECORATORS = VISIBLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__ID = VISIBLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Darstellungs Objekt Typ</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM__DARSTELLUNGS_OBJEKT_TYP = VISIBLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Embedded Do Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EMBEDDED_DO_FORM_FEATURE_COUNT = VISIBLE_FORM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl <em>External Do Form</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getExternalDoForm()
	 * @generated
	 */
	int EXTERNAL_DO_FORM = 57;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__NAME = VISIBLE_FORM__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__LOCATION = VISIBLE_FORM__LOCATION;

	/**
	 * The feature id for the '<em><b>Editor Do Typ</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__EDITOR_DO_TYP = VISIBLE_FORM__EDITOR_DO_TYP;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__VISIBLE = VISIBLE_FORM__VISIBLE;

	/**
	 * The feature id for the '<em><b>Decorators</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__DECORATORS = VISIBLE_FORM__DECORATORS;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__ID = VISIBLE_FORM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Darstellungs Objekt Typ</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP = VISIBLE_FORM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Extension Point ID</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM__EXTENSION_POINT_ID = VISIBLE_FORM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>External Do Form</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXTERNAL_DO_FORM_FEATURE_COUNT = VISIBLE_FORM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.DoEditorDiagrammImpl <em>Do Editor Diagramm</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoEditorDiagrammImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDoEditorDiagramm()
	 * @generated
	 */
	int DO_EDITOR_DIAGRAMM = 58;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_EDITOR_DIAGRAMM__LOCATION = GefPackage.LOCATED__LOCATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_EDITOR_DIAGRAMM__NAME = GefPackage.LOCATED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Do Typ</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DO_EDITOR_DIAGRAMM__DO_TYP = GefPackage.LOCATED_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Do Editor Diagramm</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DO_EDITOR_DIAGRAMM_FEATURE_COUNT = GefPackage.LOCATED_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl
	 * <em>Editor Do Typ</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEditorDoTyp()
	 * @generated
	 */
	int EDITOR_DO_TYP = 59;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__LOCATION = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__SIZE = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__SYSTEM_OBJEKT = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hotspot</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__HOTSPOT = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>An Linie Ausrichten</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN = EclipsePackage.NAMED_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Formen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__FORMEN = EclipsePackage.NAMED_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Do Typ Pid</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__DO_TYP_PID = EclipsePackage.NAMED_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Last Used Level Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP__LAST_USED_LEVEL_ID = EclipsePackage.NAMED_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Editor Do Typ</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl <em>Editor Do Typ Referenz</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEditorDoTypReferenz()
	 * @generated
	 */
	int EDITOR_DO_TYP_REFERENZ = 60;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__NAME = DobjPackage.DO_TYP__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__ID = DobjPackage.DO_TYP__ID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__DESCRIPTION = DobjPackage.DO_TYP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJECT_TYPE = DobjPackage.DO_TYP__SYSTEM_OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Icon</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__ICON = DobjPackage.DO_TYP__ICON;

	/**
	 * The feature id for the '<em><b>Zoom Stufe</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__ZOOM_STUFE = DobjPackage.DO_TYP__ZOOM_STUFE;

	/**
	 * The feature id for the '<em><b>Skalierungsfaktor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__SKALIERUNGSFAKTOR = DobjPackage.DO_TYP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Drehwinkel</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__DREHWINKEL = DobjPackage.DO_TYP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT = DobjPackage.DO_TYP_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Wrapped</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ__WRAPPED = DobjPackage.DO_TYP_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Editor Do Typ Referenz</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDITOR_DO_TYP_REFERENZ_FEATURE_COUNT = DobjPackage.DO_TYP_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition <em>Border Width Parameter Definition</em>}' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthParameterDefinition()
	 * @generated
	 */
	int BORDER_WIDTH_PARAMETER_DEFINITION = 61;

	/**
	 * The feature id for the '<em><b>Start Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_PARAMETER_DEFINITION__START_WERT = PARAMETER_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_PARAMETER_DEFINITION__END_WERT = PARAMETER_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Border Width Parameter Definition</em>' class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_PARAMETER_DEFINITION_FEATURE_COUNT = PARAMETER_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeTextDecoratorImpl
	 * <em>Border Color Attribute Text Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorAttributeTextDecorator()
	 * @generated
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR = 62;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR__TEXT = ATTRIBUTE_TEXT_DECORATOR__TEXT;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = ATTRIBUTE_TEXT_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR__START_COLOR = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR__END_COLOR = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '
	 * <em>Border Color Attribute Text Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeIntervalDecoratorImpl
	 * <em>Border Color Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorAttributeIntervalDecorator()
	 * @generated
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR = 63;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__START = ATTRIBUTE_INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__END = ATTRIBUTE_INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__START_COLOR = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR__END_COLOR = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '
	 * <em>Border Color Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorZoomDecoratorImpl <em>Border Color Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorZoomDecorator()
	 * @generated
	 */
	int BORDER_COLOR_ZOOM_DECORATOR = 64;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ZOOM_DECORATOR__START = ZOOM_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ZOOM_DECORATOR__END = ZOOM_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Start Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ZOOM_DECORATOR__START_COLOR = ZOOM_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Color</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ZOOM_DECORATOR__END_COLOR = ZOOM_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Border Color Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_COLOR_ZOOM_DECORATOR_FEATURE_COUNT = ZOOM_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeTextDecoratorImpl
	 * <em>Border Width Attribute Text Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeTextDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthAttributeTextDecorator()
	 * @generated
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR = 65;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__TEXT = ATTRIBUTE_TEXT_DECORATOR__TEXT;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__ASPEKT = ATTRIBUTE_TEXT_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_TEXT_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '
	 * <em>Border Width Attribute Text Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT = ATTRIBUTE_TEXT_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeIntervalDecoratorImpl
	 * <em>Border Width Attribute Interval Decorator</em>}' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeIntervalDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthAttributeIntervalDecorator()
	 * @generated
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR = 66;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__START = ATTRIBUTE_INTERVAL_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__END = ATTRIBUTE_INTERVAL_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Attribut Gruppe</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;

	/**
	 * The feature id for the '<em><b>Aspekt</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT = ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;

	/**
	 * The feature id for the '<em><b>Attribut Pfad</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD = ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;

	/**
	 * The feature id for the '<em><b>Start Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__START_WERT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR__END_WERT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '
	 * <em>Border Width Attribute Interval Decorator</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT = ATTRIBUTE_INTERVAL_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthZoomDecoratorImpl <em>Border Width Zoom Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthZoomDecoratorImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthZoomDecorator()
	 * @generated
	 */
	int BORDER_WIDTH_ZOOM_DECORATOR = 67;

	/**
	 * The feature id for the '<em><b>Start</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ZOOM_DECORATOR__START = ZOOM_DECORATOR__START;

	/**
	 * The feature id for the '<em><b>End</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ZOOM_DECORATOR__END = ZOOM_DECORATOR__END;

	/**
	 * The feature id for the '<em><b>Start Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ZOOM_DECORATOR__START_WERT = ZOOM_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Wert</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ZOOM_DECORATOR__END_WERT = ZOOM_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Border Width Zoom Decorator</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BORDER_WIDTH_ZOOM_DECORATOR_FEATURE_COUNT = ZOOM_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.IdentidyImpl <em>Identidy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.IdentidyImpl
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getIdentidy()
	 * @generated
	 */
	int IDENTIDY = 68;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIDY__ID = 0;

	/**
	 * The number of structural features of the '<em>Identidy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIDY_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten
	 * <em>Zoom Verhalten</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhalten()
	 * @generated
	 */
	int ZOOM_VERHALTEN = 69;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.Positionierung
	 * <em>Positionierung</em>}' enum. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.doeditor.model.Positionierung
	 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPositionierung()
	 * @generated
	 */
	int POSITIONIERUNG = 70;

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm <em>Visible Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Visible Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm
	 * @generated
	 */
	EClass getVisibleForm();

	/**
	 * Returns the meta object for the container reference '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm#getEditorDoTyp <em>Editor Do Typ</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Editor Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm#getEditorDoTyp()
	 * @see #getVisibleForm()
	 * @generated
	 */
	EReference getVisibleForm_EditorDoTyp();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm#isVisible <em>Visible</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visible</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm#isVisible()
	 * @see #getVisibleForm()
	 * @generated
	 */
	EAttribute getVisibleForm_Visible();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm#getDecorators <em>Decorators</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Decorators</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm#getDecorators()
	 * @see #getVisibleForm()
	 * @generated
	 */
	EReference getVisibleForm_Decorators();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.RotatableForm <em>Rotatable Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rotatable Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.RotatableForm
	 * @generated
	 */
	EClass getRotatableForm();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.RotatableForm#getAngle <em>Angle</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Angle</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.RotatableForm#getAngle()
	 * @see #getRotatableForm()
	 * @generated
	 */
	EAttribute getRotatableForm_Angle();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderedForm <em>Bordered Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bordered Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderedForm
	 * @generated
	 */
	EClass getBorderedForm();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.BorderedForm#getBorderWidth <em>Border Width</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Border Width</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderedForm#getBorderWidth()
	 * @see #getBorderedForm()
	 * @generated
	 */
	EAttribute getBorderedForm_BorderWidth();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.BorderedForm#getBorderColor <em>Border Color</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Border Color</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderedForm#getBorderColor()
	 * @see #getBorderedForm()
	 * @generated
	 */
	EReference getBorderedForm_BorderColor();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomableForm <em>Zoomable Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zoomable Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomableForm
	 * @generated
	 */
	EClass getZoomableForm();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomableForm#getZoomVerhalten <em>Zoom Verhalten</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom Verhalten</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomableForm#getZoomVerhalten()
	 * @see #getZoomableForm()
	 * @generated
	 */
	EAttribute getZoomableForm_ZoomVerhalten();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.PunktForm <em>Punkt Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Punkt Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PunktForm
	 * @generated
	 */
	EClass getPunktForm();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.PunktForm#getForegroundColor
	 * <em>Foreground Color</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Foreground Color</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PunktForm#getForegroundColor()
	 * @see #getPunktForm()
	 * @generated
	 */
	EReference getPunktForm_ForegroundColor();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.PunktForm#getPositionierung <em>Positionierung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Positionierung</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PunktForm#getPositionierung()
	 * @see #getPunktForm()
	 * @generated
	 */
	EAttribute getPunktForm_Positionierung();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.PunktForm#getBounds <em>Bounds</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bounds</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PunktForm#getBounds()
	 * @see #getPunktForm()
	 * @generated
	 */
	EAttribute getPunktForm_Bounds();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BildForm <em>Bild Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bild Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BildForm
	 * @generated
	 */
	EClass getBildForm();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.BildForm#getBild <em>Bild</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bild</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BildForm#getBild()
	 * @see #getBildForm()
	 * @generated
	 */
	EAttribute getBildForm_Bild();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.TextForm <em>Text Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Text Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextForm
	 * @generated
	 */
	EClass getTextForm();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.TextForm#getText <em>Text</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextForm#getText()
	 * @see #getTextForm()
	 * @generated
	 */
	EAttribute getTextForm_Text();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.TextForm#getHorizontalAlignment <em>Horizontal Alignment</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Horizontal Alignment</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextForm#getHorizontalAlignment()
	 * @see #getTextForm()
	 * @generated
	 */
	EAttribute getTextForm_HorizontalAlignment();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.TextForm#getVerticalAlignment
	 * <em>Vertical Alignment</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Vertical Alignment</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextForm#getVerticalAlignment()
	 * @see #getTextForm()
	 * @generated
	 */
	EAttribute getTextForm_VerticalAlignment();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.TextForm#getFont <em>Font</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Font</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextForm#getFont()
	 * @see #getTextForm()
	 * @generated
	 */
	EReference getTextForm_Font();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.PolylineForm <em>Polyline Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Polyline Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PolylineForm
	 * @generated
	 */
	EClass getPolylineForm();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.PolylineForm#getPoints <em>Points</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Points</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PolylineForm#getPoints()
	 * @see #getPolylineForm()
	 * @generated
	 */
	EAttribute getPolylineForm_Points();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.PolygonForm <em>Polygon Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Polygon Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.PolygonForm
	 * @generated
	 */
	EClass getPolygonForm();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.FlaechenForm <em>Flaechen Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Flaechen Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FlaechenForm
	 * @generated
	 */
	EClass getFlaechenForm();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.FlaechenForm#getBackgroundColor
	 * <em>Background Color</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Background Color</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FlaechenForm#getBackgroundColor()
	 * @see #getFlaechenForm()
	 * @generated
	 */
	EReference getFlaechenForm_BackgroundColor();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.FlaechenForm#getBackgroundPattern
	 * <em>Background Pattern</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Background Pattern</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FlaechenForm#getBackgroundPattern()
	 * @see #getFlaechenForm()
	 * @generated
	 */
	EAttribute getFlaechenForm_BackgroundPattern();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.FlaechenForm#isFilled <em>Filled</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Filled</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FlaechenForm#isFilled()
	 * @see #getFlaechenForm()
	 * @generated
	 */
	EAttribute getFlaechenForm_Filled();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.EllipseForm <em>Ellipse Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ellipse Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EllipseForm
	 * @generated
	 */
	EClass getEllipseForm();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.RechteckForm <em>Rechteck Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rechteck Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.RechteckForm
	 * @generated
	 */
	EClass getRechteckForm();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.LinienForm <em>Linien Form</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Linien Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LinienForm
	 * @generated
	 */
	EClass getLinienForm();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.LinienForm#getLineAttributes <em>Line Attributes</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Line Attributes</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LinienForm#getLineAttributes()
	 * @see #getLinienForm()
	 * @generated
	 */
	EReference getLinienForm_LineAttributes();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.Decorator <em>Decorator</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.Decorator
	 * @generated
	 */
	EClass getDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.TextDecorator <em>Text Decorator</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextDecorator
	 * @generated
	 */
	EClass getTextDecorator();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.TextDecorator#getText <em>Text</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.TextDecorator#getText()
	 * @see #getTextDecorator()
	 * @generated
	 */
	EAttribute getTextDecorator_Text();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator
	 * <em>Attribute Decorator</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Attribute Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator
	 * @generated
	 */
	EClass getAttributeDecorator();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator#getAttributGruppe <em>Attribut Gruppe</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attribut Gruppe</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator#getAttributGruppe()
	 * @see #getAttributeDecorator()
	 * @generated
	 */
	EAttribute getAttributeDecorator_AttributGruppe();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator#getAspekt <em>Aspekt</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Aspekt</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator#getAspekt()
	 * @see #getAttributeDecorator()
	 * @generated
	 */
	EAttribute getAttributeDecorator_Aspekt();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator#getAttributPfad <em>Attribut Pfad</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attribut Pfad</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator#getAttributPfad()
	 * @see #getAttributeDecorator()
	 * @generated
	 */
	EAttribute getAttributeDecorator_AttributPfad();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator
	 * <em>Interval Decorator</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator
	 * @generated
	 */
	EClass getIntervalDecorator();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator#getStart <em>Start</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator#getStart()
	 * @see #getIntervalDecorator()
	 * @generated
	 */
	EAttribute getIntervalDecorator_Start();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator#getEnd <em>End</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator#getEnd()
	 * @see #getIntervalDecorator()
	 * @generated
	 */
	EAttribute getIntervalDecorator_End();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator <em>Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator
	 * @generated
	 */
	EClass getZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoModel <em>Editor Do Model</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Editor Do Model</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoModel
	 * @generated
	 */
	EClass getEditorDoModel();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator <em>Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator
	 * @generated
	 */
	EClass getAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator <em>Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator
	 * @generated
	 */
	EClass getAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator <em>Background Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Background Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator
	 * @generated
	 */
	EClass getBackgroundAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition <em>Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition
	 * @generated
	 */
	EClass getParameterDefinition();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition <em>Color Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Color Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition
	 * @generated
	 */
	EClass getColorParameterDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition#getStartColor <em>Start Color</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Start Color</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition#getStartColor()
	 * @see #getColorParameterDefinition()
	 * @generated
	 */
	EReference getColorParameterDefinition_StartColor();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition#getEndColor <em>End Color</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>End Color</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition#getEndColor()
	 * @see #getColorParameterDefinition()
	 * @generated
	 */
	EReference getColorParameterDefinition_EndColor();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition <em>Background Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Background Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition
	 * @generated
	 */
	EClass getBackgroundParameterDefinition();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition <em>Foreground Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Foreground Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition
	 * @generated
	 */
	EClass getForegroundParameterDefinition();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition <em>Border Color Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Border Color Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition
	 * @generated
	 */
	EClass getBorderColorParameterDefinition();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition <em>Font Data Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Font Data Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition
	 * @generated
	 */
	EClass getFontDataParameterDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition#getFont <em>Font</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Font</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition#getFont()
	 * @see #getFontDataParameterDefinition()
	 * @generated
	 */
	EReference getFontDataParameterDefinition_Font();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition <em>Drehwinkel Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Drehwinkel Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition
	 * @generated
	 */
	EClass getDrehwinkelParameterDefinition();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition#getStartWinkel <em>Start Winkel</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Winkel</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition#getStartWinkel()
	 * @see #getDrehwinkelParameterDefinition()
	 * @generated
	 */
	EAttribute getDrehwinkelParameterDefinition_StartWinkel();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition#getEndWinkel <em>End Winkel</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Winkel</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition#getEndWinkel()
	 * @see #getDrehwinkelParameterDefinition()
	 * @generated
	 */
	EAttribute getDrehwinkelParameterDefinition_EndWinkel();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition <em>Line Attribute Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Line Attribute Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition
	 * @generated
	 */
	EClass getLineAttributeParameterDefinition();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition#getLineAttributes <em>Line Attributes</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Line Attributes</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition#getLineAttributes()
	 * @see #getLineAttributeParameterDefinition()
	 * @generated
	 */
	EReference getLineAttributeParameterDefinition_LineAttributes();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition <em>String Parameter Definition</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>String Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition
	 * @generated
	 */
	EClass getStringParameterDefinition();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition#getString <em>String</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>String</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition#getString()
	 * @see #getStringParameterDefinition()
	 * @generated
	 */
	EAttribute getStringParameterDefinition_String();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition <em>Sichtbarkeit Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sichtbarkeit Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition
	 * @generated
	 */
	EClass getSichtbarkeitParameterDefinition();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition#isSichtbar <em>Sichtbar</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sichtbar</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition#isSichtbar()
	 * @see #getSichtbarkeitParameterDefinition()
	 * @generated
	 */
	EAttribute getSichtbarkeitParameterDefinition_Sichtbar();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition <em>Zoom Verhalten Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zoom Verhalten Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition
	 * @generated
	 */
	EClass getZoomVerhaltenParameterDefinition();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition#getZoomVerhalten <em>Zoom Verhalten</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom Verhalten</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition#getZoomVerhalten()
	 * @see #getZoomVerhaltenParameterDefinition()
	 * @generated
	 */
	EAttribute getZoomVerhaltenParameterDefinition_ZoomVerhalten();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator <em>Background Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Background Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator
	 * @generated
	 */
	EClass getBackgroundAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator <em>Background Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Background Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator
	 * @generated
	 */
	EClass getBackgroundZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator <em>Drehwinkel Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Drehwinkel Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator
	 * @generated
	 */
	EClass getDrehwinkelAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator <em>Drehwinkel Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Drehwinkel Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator
	 * @generated
	 */
	EClass getDrehwinkelAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator <em>Drehwinkel Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Drehwinkel Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator
	 * @generated
	 */
	EClass getDrehwinkelZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator <em>Font Data Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Font Data Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator
	 * @generated
	 */
	EClass getFontDataAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator <em>Font Data Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Font Data Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator
	 * @generated
	 */
	EClass getFontDataAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator <em>Font Data Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Font Data Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator
	 * @generated
	 */
	EClass getFontDataZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator <em>Foreground Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Foreground Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator
	 * @generated
	 */
	EClass getForegroundAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator <em>Foreground Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Foreground Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator
	 * @generated
	 */
	EClass getForegroundAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator <em>Foreground Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Foreground Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator
	 * @generated
	 */
	EClass getForegroundZoomDecorator();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator
	 * <em>Line Attribute Attribute Interval Decorator</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '
	 *         <em>Line Attribute Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator
	 * @generated
	 */
	EClass getLineAttributeAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator <em>Line Attribute Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Line Attribute Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator
	 * @generated
	 */
	EClass getLineAttributeAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator <em>Line Attribute Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Line Attribute Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator
	 * @generated
	 */
	EClass getLineAttributeZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator <em>Sichtbarkeit Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sichtbarkeit Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator
	 * @generated
	 */
	EClass getSichtbarkeitAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator <em>Sichtbarkeit Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sichtbarkeit Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator
	 * @generated
	 */
	EClass getSichtbarkeitAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator <em>Sichtbarkeit Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Sichtbarkeit Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator
	 * @generated
	 */
	EClass getSichtbarkeitZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator <em>String Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator
	 * @generated
	 */
	EClass getStringAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator <em>String Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>String Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator
	 * @generated
	 */
	EClass getStringAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator <em>String Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>String Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator
	 * @generated
	 */
	EClass getStringZoomDecorator();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator
	 * <em>Zoom Verhalten Attribute Interval Decorator</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '
	 *         <em>Zoom Verhalten Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator
	 * @generated
	 */
	EClass getZoomVerhaltenAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator <em>Zoom Verhalten Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Zoom Verhalten Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator
	 * @generated
	 */
	EClass getZoomVerhaltenAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator <em>Zoom Verhalten Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Zoom Verhalten Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator
	 * @generated
	 */
	EClass getZoomVerhaltenZoomDecorator();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm
	 * <em>Embedded Do Form</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Embedded Do Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm
	 * @generated
	 */
	EClass getEmbeddedDoForm();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm#getDarstellungsObjektTyp <em>Darstellungs Objekt Typ</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the containment reference '<em>Darstellungs Objekt Typ</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm#getDarstellungsObjektTyp()
	 * @see #getEmbeddedDoForm()
	 * @generated
	 */
	EReference getEmbeddedDoForm_DarstellungsObjektTyp();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm
	 * <em>External Do Form</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>External Do Form</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm
	 * @generated
	 */
	EClass getExternalDoForm();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm#getDarstellungsObjektTyp <em>Darstellungs Objekt Typ</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the containment reference '<em>Darstellungs Objekt Typ</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm#getDarstellungsObjektTyp()
	 * @see #getExternalDoForm()
	 * @generated
	 */
	EReference getExternalDoForm_DarstellungsObjektTyp();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm#getExtensionPointID
	 * <em>Extension Point ID</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>Extension Point ID</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm#getExtensionPointID()
	 * @see #getExternalDoForm()
	 * @generated
	 */
	EAttribute getExternalDoForm_ExtensionPointID();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm
	 * <em>Do Editor Diagramm</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Do Editor Diagramm</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm
	 * @generated
	 */
	EClass getDoEditorDiagramm();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm#getDoTyp <em>Do Typ</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm#getDoTyp()
	 * @see #getDoEditorDiagramm()
	 * @generated
	 */
	EReference getDoEditorDiagramm_DoTyp();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp <em>Editor Do Typ</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Editor Do Typ</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp
	 * @generated
	 */
	EClass getEditorDoTyp();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjekt <em>System Objekt</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>System Objekt</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjekt()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EAttribute getEditorDoTyp_SystemObjekt();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getHotspot <em>Hotspot</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hotspot</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getHotspot()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EAttribute getEditorDoTyp_Hotspot();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#isAnLinieAusrichten
	 * <em>An Linie Ausrichten</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>An Linie Ausrichten</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#isAnLinieAusrichten()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EAttribute getEditorDoTyp_AnLinieAusrichten();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getFormen <em>Formen</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Formen</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getFormen()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EReference getEditorDoTyp_Formen();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getDoTypPid <em>Do Typ Pid</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Do Typ Pid</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getDoTypPid()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EAttribute getEditorDoTyp_DoTypPid();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getLastUsedLevelId <em>Last Used Level Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Last Used Level Id</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getLastUsedLevelId()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EAttribute getEditorDoTyp_LastUsedLevelId();

	/**
	 * Returns the meta object for the attribute '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjectType
	 * <em>System Object Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute '<em>System Object Type</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjectType()
	 * @see #getEditorDoTyp()
	 * @generated
	 */
	EAttribute getEditorDoTyp_SystemObjectType();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz <em>Editor Do Typ Referenz</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Editor Do Typ Referenz</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz
	 * @generated
	 */
	EClass getEditorDoTypReferenz();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz#getSystemObjekt <em>System Objekt</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>System Objekt</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz#getSystemObjekt()
	 * @see #getEditorDoTypReferenz()
	 * @generated
	 */
	EAttribute getEditorDoTypReferenz_SystemObjekt();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz#getWrapped <em>Wrapped</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Wrapped</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz#getWrapped()
	 * @see #getEditorDoTypReferenz()
	 * @generated
	 */
	EReference getEditorDoTypReferenz_Wrapped();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition <em>Border Width Parameter Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Border Width Parameter Definition</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition
	 * @generated
	 */
	EClass getBorderWidthParameterDefinition();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition#getStartWert <em>Start Wert</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Wert</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition#getStartWert()
	 * @see #getBorderWidthParameterDefinition()
	 * @generated
	 */
	EAttribute getBorderWidthParameterDefinition_StartWert();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition#getEndWert <em>End Wert</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>End Wert</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition#getEndWert()
	 * @see #getBorderWidthParameterDefinition()
	 * @generated
	 */
	EAttribute getBorderWidthParameterDefinition_EndWert();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator <em>Border Color Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Border Color Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator
	 * @generated
	 */
	EClass getBorderColorAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator <em>Border Color Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Border Color Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator
	 * @generated
	 */
	EClass getBorderColorAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator <em>Border Color Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Border Color Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator
	 * @generated
	 */
	EClass getBorderColorZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator <em>Border Width Attribute Text Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Border Width Attribute Text Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator
	 * @generated
	 */
	EClass getBorderWidthAttributeTextDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator <em>Border Width Attribute Interval Decorator</em>}'.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Border Width Attribute Interval Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator
	 * @generated
	 */
	EClass getBorderWidthAttributeIntervalDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator <em>Border Width Zoom Decorator</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Border Width Zoom Decorator</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator
	 * @generated
	 */
	EClass getBorderWidthZoomDecorator();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.doeditor.model.Identidy <em>Identidy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Identidy</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.Identidy
	 * @generated
	 */
	EClass getIdentidy();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.doeditor.model.Identidy#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.Identidy#getId()
	 * @see #getIdentidy()
	 * @generated
	 */
	EAttribute getIdentidy_Id();

	/**
	 * Returns the meta object for enum '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten <em>Zoom Verhalten</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Zoom Verhalten</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten
	 * @generated
	 */
	EEnum getZoomVerhalten();

	/**
	 * Returns the meta object for enum '{@link de.bsvrz.buv.plugin.doeditor.model.Positionierung <em>Positionierung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Positionierung</em>'.
	 * @see de.bsvrz.buv.plugin.doeditor.model.Positionierung
	 * @generated
	 */
	EEnum getPositionierung();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DoeditorFactory getDoeditorFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm <em>Visible Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getVisibleForm()
		 * @generated
		 */
		EClass VISIBLE_FORM = eINSTANCE.getVisibleForm();

		/**
		 * The meta object literal for the '<em><b>Editor Do Typ</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference VISIBLE_FORM__EDITOR_DO_TYP = eINSTANCE.getVisibleForm_EditorDoTyp();

		/**
		 * The meta object literal for the '<em><b>Visible</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VISIBLE_FORM__VISIBLE = eINSTANCE.getVisibleForm_Visible();

		/**
		 * The meta object literal for the '<em><b>Decorators</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference VISIBLE_FORM__DECORATORS = eINSTANCE.getVisibleForm_Decorators();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.RotatableForm <em>Rotatable Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.RotatableForm
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getRotatableForm()
		 * @generated
		 */
		EClass ROTATABLE_FORM = eINSTANCE.getRotatableForm();

		/**
		 * The meta object literal for the '<em><b>Angle</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ROTATABLE_FORM__ANGLE = eINSTANCE.getRotatableForm_Angle();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.BorderedForm <em>Bordered Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.BorderedForm
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderedForm()
		 * @generated
		 */
		EClass BORDERED_FORM = eINSTANCE.getBorderedForm();

		/**
		 * The meta object literal for the '<em><b>Border Width</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BORDERED_FORM__BORDER_WIDTH = eINSTANCE.getBorderedForm_BorderWidth();

		/**
		 * The meta object literal for the '<em><b>Border Color</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference BORDERED_FORM__BORDER_COLOR = eINSTANCE.getBorderedForm_BorderColor();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomableForm <em>Zoomable Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomableForm
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomableForm()
		 * @generated
		 */
		EClass ZOOMABLE_FORM = eINSTANCE.getZoomableForm();

		/**
		 * The meta object literal for the '<em><b>Zoom Verhalten</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ZOOMABLE_FORM__ZOOM_VERHALTEN = eINSTANCE.getZoomableForm_ZoomVerhalten();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.PunktForm <em>Punkt Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.PunktForm
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPunktForm()
		 * @generated
		 */
		EClass PUNKT_FORM = eINSTANCE.getPunktForm();

		/**
		 * The meta object literal for the '<em><b>Foreground Color</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference PUNKT_FORM__FOREGROUND_COLOR = eINSTANCE.getPunktForm_ForegroundColor();

		/**
		 * The meta object literal for the '<em><b>Positionierung</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUNKT_FORM__POSITIONIERUNG = eINSTANCE.getPunktForm_Positionierung();

		/**
		 * The meta object literal for the '<em><b>Bounds</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PUNKT_FORM__BOUNDS = eINSTANCE.getPunktForm_Bounds();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BildFormImpl
		 * <em>Bild Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BildFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBildForm()
		 * @generated
		 */
		EClass BILD_FORM = eINSTANCE.getBildForm();

		/**
		 * The meta object literal for the '<em><b>Bild</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BILD_FORM__BILD = eINSTANCE.getBildForm_Bild();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl
		 * <em>Text Form</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getTextForm()
		 * @generated
		 */
		EClass TEXT_FORM = eINSTANCE.getTextForm();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEXT_FORM__TEXT = eINSTANCE.getTextForm_Text();

		/**
		 * The meta object literal for the '<em><b>Horizontal Alignment</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEXT_FORM__HORIZONTAL_ALIGNMENT = eINSTANCE.getTextForm_HorizontalAlignment();

		/**
		 * The meta object literal for the '<em><b>Vertical Alignment</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEXT_FORM__VERTICAL_ALIGNMENT = eINSTANCE.getTextForm_VerticalAlignment();

		/**
		 * The meta object literal for the '<em><b>Font</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEXT_FORM__FONT = eINSTANCE.getTextForm_Font();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl <em>Polyline Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.PolylineFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPolylineForm()
		 * @generated
		 */
		EClass POLYLINE_FORM = eINSTANCE.getPolylineForm();

		/**
		 * The meta object literal for the '<em><b>Points</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POLYLINE_FORM__POINTS = eINSTANCE.getPolylineForm_Points();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl <em>Polygon Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPolygonForm()
		 * @generated
		 */
		EClass POLYGON_FORM = eINSTANCE.getPolygonForm();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl <em>Flaechen Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FlaechenFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFlaechenForm()
		 * @generated
		 */
		EClass FLAECHEN_FORM = eINSTANCE.getFlaechenForm();

		/**
		 * The meta object literal for the '<em><b>Background Color</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference FLAECHEN_FORM__BACKGROUND_COLOR = eINSTANCE.getFlaechenForm_BackgroundColor();

		/**
		 * The meta object literal for the '<em><b>Background Pattern</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FLAECHEN_FORM__BACKGROUND_PATTERN = eINSTANCE.getFlaechenForm_BackgroundPattern();

		/**
		 * The meta object literal for the '<em><b>Filled</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FLAECHEN_FORM__FILLED = eINSTANCE.getFlaechenForm_Filled();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EllipseFormImpl <em>Ellipse Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EllipseFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEllipseForm()
		 * @generated
		 */
		EClass ELLIPSE_FORM = eINSTANCE.getEllipseForm();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.RechteckFormImpl <em>Rechteck Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.RechteckFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getRechteckForm()
		 * @generated
		 */
		EClass RECHTECK_FORM = eINSTANCE.getRechteckForm();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.LinienForm <em>Linien Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.LinienForm
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLinienForm()
		 * @generated
		 */
		EClass LINIEN_FORM = eINSTANCE.getLinienForm();

		/**
		 * The meta object literal for the '<em><b>Line Attributes</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference LINIEN_FORM__LINE_ATTRIBUTES = eINSTANCE.getLinienForm_LineAttributes();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.DecoratorImpl
		 * <em>Decorator</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDecorator()
		 * @generated
		 */
		EClass DECORATOR = eINSTANCE.getDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.TextDecorator <em>Text Decorator</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.TextDecorator
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getTextDecorator()
		 * @generated
		 */
		EClass TEXT_DECORATOR = eINSTANCE.getTextDecorator();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEXT_DECORATOR__TEXT = eINSTANCE.getTextDecorator_Text();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeDecoratorImpl <em>Attribute Decorator</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.AttributeDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getAttributeDecorator()
		 * @generated
		 */
		EClass ATTRIBUTE_DECORATOR = eINSTANCE.getAttributeDecorator();

		/**
		 * The meta object literal for the '<em><b>Attribut Gruppe</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE = eINSTANCE.getAttributeDecorator_AttributGruppe();

		/**
		 * The meta object literal for the '<em><b>Aspekt</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_DECORATOR__ASPEKT = eINSTANCE.getAttributeDecorator_Aspekt();

		/**
		 * The meta object literal for the '<em><b>Attribut Pfad</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD = eINSTANCE.getAttributeDecorator_AttributPfad();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator <em>Interval Decorator</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getIntervalDecorator()
		 * @generated
		 */
		EClass INTERVAL_DECORATOR = eINSTANCE.getIntervalDecorator();

		/**
		 * The meta object literal for the '<em><b>Start</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERVAL_DECORATOR__START = eINSTANCE.getIntervalDecorator_Start();

		/**
		 * The meta object literal for the '<em><b>End</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERVAL_DECORATOR__END = eINSTANCE.getIntervalDecorator_End();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomDecoratorImpl <em>Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomDecorator()
		 * @generated
		 */
		EClass ZOOM_DECORATOR = eINSTANCE.getZoomDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl <em>Editor Do Model</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoModelImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEditorDoModel()
		 * @generated
		 */
		EClass EDITOR_DO_MODEL = eINSTANCE.getEditorDoModel();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl <em>Attribute Text Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.AttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getAttributeTextDecorator()
		 * @generated
		 */
		EClass ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getAttributeTextDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.AttributeIntervalDecoratorImpl <em>Attribute Interval Decorator</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.AttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getAttributeIntervalDecorator()
		 * @generated
		 */
		EClass ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeIntervalDecoratorImpl
		 * <em>Background Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundAttributeIntervalDecorator()
		 * @generated
		 */
		EClass BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getBackgroundAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition <em>Parameter Definition</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getParameterDefinition()
		 * @generated
		 */
		EClass PARAMETER_DEFINITION = eINSTANCE.getParameterDefinition();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition <em>Color Parameter Definition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getColorParameterDefinition()
		 * @generated
		 */
		EClass COLOR_PARAMETER_DEFINITION = eINSTANCE.getColorParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Start Color</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference COLOR_PARAMETER_DEFINITION__START_COLOR = eINSTANCE.getColorParameterDefinition_StartColor();

		/**
		 * The meta object literal for the '<em><b>End Color</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference COLOR_PARAMETER_DEFINITION__END_COLOR = eINSTANCE.getColorParameterDefinition_EndColor();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition <em>Background Parameter Definition</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundParameterDefinition()
		 * @generated
		 */
		EClass BACKGROUND_PARAMETER_DEFINITION = eINSTANCE.getBackgroundParameterDefinition();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition <em>Foreground Parameter Definition</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundParameterDefinition()
		 * @generated
		 */
		EClass FOREGROUND_PARAMETER_DEFINITION = eINSTANCE.getForegroundParameterDefinition();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition
		 * <em>Border Color Parameter Definition</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorParameterDefinition()
		 * @generated
		 */
		EClass BORDER_COLOR_PARAMETER_DEFINITION = eINSTANCE.getBorderColorParameterDefinition();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition <em>Font Data Parameter Definition</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataParameterDefinition()
		 * @generated
		 */
		EClass FONT_DATA_PARAMETER_DEFINITION = eINSTANCE.getFontDataParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Font</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference FONT_DATA_PARAMETER_DEFINITION__FONT = eINSTANCE.getFontDataParameterDefinition_Font();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition <em>Drehwinkel Parameter Definition</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelParameterDefinition()
		 * @generated
		 */
		EClass DREHWINKEL_PARAMETER_DEFINITION = eINSTANCE.getDrehwinkelParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Start Winkel</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DREHWINKEL_PARAMETER_DEFINITION__START_WINKEL = eINSTANCE
				.getDrehwinkelParameterDefinition_StartWinkel();

		/**
		 * The meta object literal for the '<em><b>End Winkel</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DREHWINKEL_PARAMETER_DEFINITION__END_WINKEL = eINSTANCE.getDrehwinkelParameterDefinition_EndWinkel();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition
		 * <em>Line Attribute Parameter Definition</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeParameterDefinition()
		 * @generated
		 */
		EClass LINE_ATTRIBUTE_PARAMETER_DEFINITION = eINSTANCE.getLineAttributeParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Line Attributes</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference LINE_ATTRIBUTE_PARAMETER_DEFINITION__LINE_ATTRIBUTES = eINSTANCE
				.getLineAttributeParameterDefinition_LineAttributes();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition <em>String Parameter Definition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringParameterDefinition()
		 * @generated
		 */
		EClass STRING_PARAMETER_DEFINITION = eINSTANCE.getStringParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>String</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRING_PARAMETER_DEFINITION__STRING = eINSTANCE.getStringParameterDefinition_String();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition
		 * <em>Sichtbarkeit Parameter Definition</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitParameterDefinition()
		 * @generated
		 */
		EClass SICHTBARKEIT_PARAMETER_DEFINITION = eINSTANCE.getSichtbarkeitParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Sichtbar</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SICHTBARKEIT_PARAMETER_DEFINITION__SICHTBAR = eINSTANCE
				.getSichtbarkeitParameterDefinition_Sichtbar();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition
		 * <em>Zoom Verhalten Parameter Definition</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenParameterDefinition()
		 * @generated
		 */
		EClass ZOOM_VERHALTEN_PARAMETER_DEFINITION = eINSTANCE.getZoomVerhaltenParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Zoom Verhalten</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ZOOM_VERHALTEN_PARAMETER_DEFINITION__ZOOM_VERHALTEN = eINSTANCE
				.getZoomVerhaltenParameterDefinition_ZoomVerhalten();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeTextDecoratorImpl
		 * <em>Background Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundAttributeTextDecorator()
		 * @generated
		 */
		EClass BACKGROUND_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getBackgroundAttributeTextDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundZoomDecoratorImpl <em>Background Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BackgroundZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBackgroundZoomDecorator()
		 * @generated
		 */
		EClass BACKGROUND_ZOOM_DECORATOR = eINSTANCE.getBackgroundZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeTextDecoratorImpl
		 * <em>Drehwinkel Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelAttributeTextDecorator()
		 * @generated
		 */
		EClass DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getDrehwinkelAttributeTextDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeIntervalDecoratorImpl
		 * <em>Drehwinkel Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelAttributeIntervalDecorator()
		 * @generated
		 */
		EClass DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getDrehwinkelAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelZoomDecoratorImpl <em>Drehwinkel Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DrehwinkelZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDrehwinkelZoomDecorator()
		 * @generated
		 */
		EClass DREHWINKEL_ZOOM_DECORATOR = eINSTANCE.getDrehwinkelZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeIntervalDecoratorImpl
		 * <em>Font Data Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataAttributeIntervalDecorator()
		 * @generated
		 */
		EClass FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getFontDataAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeTextDecoratorImpl
		 * <em>Font Data Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FontDataAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataAttributeTextDecorator()
		 * @generated
		 */
		EClass FONT_DATA_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getFontDataAttributeTextDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl <em>Font Data Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.FontDataZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getFontDataZoomDecorator()
		 * @generated
		 */
		EClass FONT_DATA_ZOOM_DECORATOR = eINSTANCE.getFontDataZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeTextDecoratorImpl
		 * <em>Foreground Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundAttributeTextDecorator()
		 * @generated
		 */
		EClass FOREGROUND_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getForegroundAttributeTextDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeIntervalDecoratorImpl
		 * <em>Foreground Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundAttributeIntervalDecorator()
		 * @generated
		 */
		EClass FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getForegroundAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl <em>Foreground Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getForegroundZoomDecorator()
		 * @generated
		 */
		EClass FOREGROUND_ZOOM_DECORATOR = eINSTANCE.getForegroundZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl
		 * <em>Line Attribute Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeAttributeIntervalDecorator()
		 * @generated
		 */
		EClass LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getLineAttributeAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeTextDecoratorImpl
		 * <em>Line Attribute Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeAttributeTextDecorator()
		 * @generated
		 */
		EClass LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getLineAttributeAttributeTextDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeZoomDecoratorImpl <em>Line Attribute Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getLineAttributeZoomDecorator()
		 * @generated
		 */
		EClass LINE_ATTRIBUTE_ZOOM_DECORATOR = eINSTANCE.getLineAttributeZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeTextDecoratorImpl
		 * <em>Sichtbarkeit Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitAttributeTextDecorator()
		 * @generated
		 */
		EClass SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getSichtbarkeitAttributeTextDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeIntervalDecoratorImpl
		 * <em>Sichtbarkeit Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitAttributeIntervalDecorator()
		 * @generated
		 */
		EClass SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getSichtbarkeitAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitZoomDecoratorImpl <em>Sichtbarkeit Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.SichtbarkeitZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getSichtbarkeitZoomDecorator()
		 * @generated
		 */
		EClass SICHTBARKEIT_ZOOM_DECORATOR = eINSTANCE.getSichtbarkeitZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeIntervalDecoratorImpl
		 * <em>String Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringAttributeIntervalDecorator()
		 * @generated
		 */
		EClass STRING_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getStringAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeTextDecoratorImpl <em>String Attribute Text Decorator</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.StringAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringAttributeTextDecorator()
		 * @generated
		 */
		EClass STRING_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getStringAttributeTextDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.StringZoomDecoratorImpl <em>String Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.StringZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getStringZoomDecorator()
		 * @generated
		 */
		EClass STRING_ZOOM_DECORATOR = eINSTANCE.getStringZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeIntervalDecoratorImpl
		 * <em>Zoom Verhalten Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenAttributeIntervalDecorator()
		 * @generated
		 */
		EClass ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getZoomVerhaltenAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeTextDecoratorImpl
		 * <em>Zoom Verhalten Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenAttributeTextDecorator()
		 * @generated
		 */
		EClass ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getZoomVerhaltenAttributeTextDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenZoomDecoratorImpl <em>Zoom Verhalten Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc
		 * --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ZoomVerhaltenZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhaltenZoomDecorator()
		 * @generated
		 */
		EClass ZOOM_VERHALTEN_ZOOM_DECORATOR = eINSTANCE.getZoomVerhaltenZoomDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EmbeddedDoFormImpl <em>Embedded Do Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EmbeddedDoFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEmbeddedDoForm()
		 * @generated
		 */
		EClass EMBEDDED_DO_FORM = eINSTANCE.getEmbeddedDoForm();

		/**
		 * The meta object literal for the '<em><b>Darstellungs Objekt Typ</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference EMBEDDED_DO_FORM__DARSTELLUNGS_OBJEKT_TYP = eINSTANCE.getEmbeddedDoForm_DarstellungsObjektTyp();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl <em>External Do Form</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.ExternalDoFormImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getExternalDoForm()
		 * @generated
		 */
		EClass EXTERNAL_DO_FORM = eINSTANCE.getExternalDoForm();

		/**
		 * The meta object literal for the '
		 * <em><b>Darstellungs Objekt Typ</b></em>' reference feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP = eINSTANCE.getExternalDoForm_DarstellungsObjektTyp();

		/**
		 * The meta object literal for the '<em><b>Extension Point ID</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXTERNAL_DO_FORM__EXTENSION_POINT_ID = eINSTANCE.getExternalDoForm_ExtensionPointID();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.DoEditorDiagrammImpl <em>Do Editor Diagramm</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoEditorDiagrammImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getDoEditorDiagramm()
		 * @generated
		 */
		EClass DO_EDITOR_DIAGRAMM = eINSTANCE.getDoEditorDiagramm();

		/**
		 * The meta object literal for the '<em><b>Do Typ</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DO_EDITOR_DIAGRAMM__DO_TYP = eINSTANCE.getDoEditorDiagramm_DoTyp();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl <em>Editor Do Typ</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEditorDoTyp()
		 * @generated
		 */
		EClass EDITOR_DO_TYP = eINSTANCE.getEditorDoTyp();

		/**
		 * The meta object literal for the '<em><b>System Objekt</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP__SYSTEM_OBJEKT = eINSTANCE.getEditorDoTyp_SystemObjekt();

		/**
		 * The meta object literal for the '<em><b>Hotspot</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP__HOTSPOT = eINSTANCE.getEditorDoTyp_Hotspot();

		/**
		 * The meta object literal for the '<em><b>An Linie Ausrichten</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN = eINSTANCE.getEditorDoTyp_AnLinieAusrichten();

		/**
		 * The meta object literal for the '<em><b>Formen</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference EDITOR_DO_TYP__FORMEN = eINSTANCE.getEditorDoTyp_Formen();

		/**
		 * The meta object literal for the '<em><b>Do Typ Pid</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP__DO_TYP_PID = eINSTANCE.getEditorDoTyp_DoTypPid();

		/**
		 * The meta object literal for the '<em><b>Last Used Level Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP__LAST_USED_LEVEL_ID = eINSTANCE.getEditorDoTyp_LastUsedLevelId();

		/**
		 * The meta object literal for the '<em><b>System Object Type</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE = eINSTANCE.getEditorDoTyp_SystemObjectType();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl <em>Editor Do Typ Referenz</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypReferenzImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getEditorDoTypReferenz()
		 * @generated
		 */
		EClass EDITOR_DO_TYP_REFERENZ = eINSTANCE.getEditorDoTypReferenz();

		/**
		 * The meta object literal for the '<em><b>System Objekt</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT = eINSTANCE.getEditorDoTypReferenz_SystemObjekt();

		/**
		 * The meta object literal for the '<em><b>Wrapped</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference EDITOR_DO_TYP_REFERENZ__WRAPPED = eINSTANCE.getEditorDoTypReferenz_Wrapped();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition
		 * <em>Border Width Parameter Definition</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthParameterDefinition()
		 * @generated
		 */
		EClass BORDER_WIDTH_PARAMETER_DEFINITION = eINSTANCE.getBorderWidthParameterDefinition();

		/**
		 * The meta object literal for the '<em><b>Start Wert</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BORDER_WIDTH_PARAMETER_DEFINITION__START_WERT = eINSTANCE
				.getBorderWidthParameterDefinition_StartWert();

		/**
		 * The meta object literal for the '<em><b>End Wert</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BORDER_WIDTH_PARAMETER_DEFINITION__END_WERT = eINSTANCE.getBorderWidthParameterDefinition_EndWert();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeTextDecoratorImpl
		 * <em>Border Color Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorAttributeTextDecorator()
		 * @generated
		 */
		EClass BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getBorderColorAttributeTextDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeIntervalDecoratorImpl
		 * <em>Border Color Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorAttributeIntervalDecorator()
		 * @generated
		 */
		EClass BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getBorderColorAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorZoomDecoratorImpl <em>Border Color Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderColorZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderColorZoomDecorator()
		 * @generated
		 */
		EClass BORDER_COLOR_ZOOM_DECORATOR = eINSTANCE.getBorderColorZoomDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeTextDecoratorImpl
		 * <em>Border Width Attribute Text Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeTextDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthAttributeTextDecorator()
		 * @generated
		 */
		EClass BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR = eINSTANCE.getBorderWidthAttributeTextDecorator();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeIntervalDecoratorImpl
		 * <em>Border Width Attribute Interval Decorator</em>}' class. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeIntervalDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthAttributeIntervalDecorator()
		 * @generated
		 */
		EClass BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR = eINSTANCE.getBorderWidthAttributeIntervalDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthZoomDecoratorImpl <em>Border Width Zoom Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthZoomDecoratorImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getBorderWidthZoomDecorator()
		 * @generated
		 */
		EClass BORDER_WIDTH_ZOOM_DECORATOR = eINSTANCE.getBorderWidthZoomDecorator();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.impl.IdentidyImpl <em>Identidy</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.IdentidyImpl
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getIdentidy()
		 * @generated
		 */
		EClass IDENTIDY = eINSTANCE.getIdentidy();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IDENTIDY__ID = eINSTANCE.getIdentidy_Id();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten <em>Zoom Verhalten</em>}' enum.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getZoomVerhalten()
		 * @generated
		 */
		EEnum ZOOM_VERHALTEN = eINSTANCE.getZoomVerhalten();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.doeditor.model.Positionierung <em>Positionierung</em>}' enum.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.doeditor.model.Positionierung
		 * @see de.bsvrz.buv.plugin.doeditor.model.impl.DoeditorPackageImpl#getPositionierung()
		 * @generated
		 */
		EEnum POSITIONIERUNG = eINSTANCE.getPositionierung();

	}

} // DoeditorPackage
