/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Editor Do Typ</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjekt <em>System Objekt</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjectType <em>System Object Type</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getHotspot <em>Hotspot</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#isAnLinieAusrichten <em>An Linie Ausrichten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getFormen <em>Formen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getDoTypPid <em>Do Typ Pid</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getLastUsedLevelId <em>Last Used Level Id</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp()
 * @model
 * @generated
 */
public interface EditorDoTyp extends Named, Located, Sized {
	/**
	 * Returns the value of the '<em><b>System Objekt</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>System Objekt</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>System Objekt</em>' attribute.
	 * @see #setSystemObjekt(SystemObjekt)
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_SystemObjekt()
	 * @model 
	 *        dataType="com.bitctrl.lib.eclipse.emf.davbitctrl.model.SystemObjekt"
	 *        transient="true" volatile="true"
	 * @generated
	 */
	SystemObjekt getSystemObjekt();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjekt <em>System Objekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>System Objekt</em>' attribute.
	 * @see #getSystemObjekt()
	 * @generated
	 */
	void setSystemObjekt(SystemObjekt value);

	/**
	 * Returns the value of the '<em><b>Hotspot</b></em>' attribute.
	 * The default value is <code>"Point(0,0)"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hotspot</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hotspot</em>' attribute.
	 * @see #setHotspot(Point)
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_Hotspot()
	 * @model default="Point(0,0)" dataType="com.bitctrl.lib.eclipse.emf.gef.model.Point"
	 * @generated
	 */
	Point getHotspot();

	/**
	 * Sets the value of the '
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getHotspot
	 * <em>Hotspot</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @param value
	 *            the new value of the '<em>Hotspot</em>' attribute.
	 * @see #getHotspot()
	 * @generated
	 */
	void setHotspot(Point value);

	/**
	 * Returns the value of the '<em><b>An Linie Ausrichten</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>An Linie Ausrichten</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>An Linie Ausrichten</em>' attribute.
	 * @see #setAnLinieAusrichten(boolean)
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_AnLinieAusrichten()
	 * @model
	 * @generated
	 */
	boolean isAnLinieAusrichten();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#isAnLinieAusrichten <em>An Linie Ausrichten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>An Linie Ausrichten</em>' attribute.
	 * @see #isAnLinieAusrichten()
	 * @generated
	 */
	void setAnLinieAusrichten(boolean value);

	/**
	 * Returns the value of the '<em><b>Formen</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm}.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.doeditor.model.VisibleForm#getEditorDoTyp <em>Editor Do Typ</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Formen</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Formen</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_Formen()
	 * @see de.bsvrz.buv.plugin.doeditor.model.VisibleForm#getEditorDoTyp
	 * @model opposite="editorDoTyp" containment="true"
	 * @generated
	 */
	EList<VisibleForm> getFormen();

	/**
	 * Returns the value of the '<em><b>Do Typ Pid</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Do Typ Pid</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Do Typ Pid</em>' attribute.
	 * @see #setDoTypPid(String)
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_DoTypPid()
	 * @model
	 * @generated
	 */
	String getDoTypPid();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getDoTypPid <em>Do Typ Pid</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Do Typ Pid</em>' attribute.
	 * @see #getDoTypPid()
	 * @generated
	 */
	void setDoTypPid(String value);

	/**
	 * Returns the value of the '<em><b>Last Used Level Id</b></em>' attribute.
	 * The default value is <code>"0"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Last Used Level Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Used Level Id</em>' attribute.
	 * @see #setLastUsedLevelId(long)
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_LastUsedLevelId()
	 * @model default="0"
	 * @generated
	 */
	long getLastUsedLevelId();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getLastUsedLevelId <em>Last Used Level Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Used Level Id</em>' attribute.
	 * @see #getLastUsedLevelId()
	 * @generated
	 */
	void setLastUsedLevelId(long value);

	/**
	 * Returns the value of the '<em><b>System Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>System Object Type</em>' attribute isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>System Object Type</em>' attribute.
	 * @see #setSystemObjectType(SystemObjectType)
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#getEditorDoTyp_SystemObjectType()
	 * @model dataType="com.bitctrl.lib.eclipse.emf.dav.model.SystemObjectType"
	 * @generated
	 */
	SystemObjectType getSystemObjectType();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp#getSystemObjectType <em>System Object Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>System Object Type</em>' attribute.
	 * @see #getSystemObjectType()
	 * @generated
	 */
	void setSystemObjectType(SystemObjectType value);

} // EditorDoTyp
