/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Border Width Attribute Text Decorator</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeTextDecoratorImpl#getStartWert <em>Start Wert</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.BorderWidthAttributeTextDecoratorImpl#getEndWert <em>End Wert</em>}</li>
 * </ul>
 *
 * @generated
 */
public class BorderWidthAttributeTextDecoratorImpl extends AttributeTextDecoratorImpl
		implements BorderWidthAttributeTextDecorator {
	/**
	 * The default value of the '{@link #getStartWert() <em>Start Wert</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStartWert()
	 * @generated
	 * @ordered
	 */
	protected static final float START_WERT_EDEFAULT = 0.0F;

	/**
	 * The cached value of the '{@link #getStartWert() <em>Start Wert</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStartWert()
	 * @generated
	 * @ordered
	 */
	protected float startWert = START_WERT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEndWert() <em>End Wert</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEndWert()
	 * @generated
	 * @ordered
	 */
	protected static final Float END_WERT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEndWert() <em>End Wert</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEndWert()
	 * @generated
	 * @ordered
	 */
	protected Float endWert = END_WERT_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderWidthAttributeTextDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public float getStartWert() {
		return startWert;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartWert(float newStartWert) {
		float oldStartWert = startWert;
		startWert = newStartWert;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT, oldStartWert, startWert));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Float getEndWert() {
		return endWert;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndWert(Float newEndWert) {
		Float oldEndWert = endWert;
		endWert = newEndWert;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT, oldEndWert, endWert));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT:
			return getStartWert();
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT:
			return getEndWert();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT:
			setStartWert((Float) newValue);
			return;
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT:
			setEndWert((Float) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT:
			setStartWert(START_WERT_EDEFAULT);
			return;
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT:
			setEndWert(END_WERT_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT:
			return startWert != START_WERT_EDEFAULT;
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT:
			return END_WERT_EDEFAULT == null ? endWert != null : !END_WERT_EDEFAULT.equals(endWert);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == BorderWidthParameterDefinition.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT:
				return DoeditorPackage.BORDER_WIDTH_PARAMETER_DEFINITION__START_WERT;
			case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT:
				return DoeditorPackage.BORDER_WIDTH_PARAMETER_DEFINITION__END_WERT;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ParameterDefinition.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == BorderWidthParameterDefinition.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.BORDER_WIDTH_PARAMETER_DEFINITION__START_WERT:
				return DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__START_WERT;
			case DoeditorPackage.BORDER_WIDTH_PARAMETER_DEFINITION__END_WERT:
				return DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR__END_WERT;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (startWert: ");
		result.append(startWert);
		result.append(", endWert: ");
		result.append(endWert);
		result.append(')');
		return result.toString();
	}

} // BorderWidthAttributeTextDecoratorImpl
