/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.swt.graphics.RGB;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipseFactory;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.doeditor.model.*;
import de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BildForm;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderedForm;
import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoModel;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.buv.plugin.doeditor.model.EllipseForm;
import de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;
import de.bsvrz.buv.plugin.doeditor.model.FlaechenForm;
import de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LinienForm;
import de.bsvrz.buv.plugin.doeditor.model.PolygonForm;
import de.bsvrz.buv.plugin.doeditor.model.PolylineForm;
import de.bsvrz.buv.plugin.doeditor.model.Positionierung;
import de.bsvrz.buv.plugin.doeditor.model.PunktForm;
import de.bsvrz.buv.plugin.doeditor.model.RechteckForm;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.TextForm;
import de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DoeditorFactoryImpl extends EFactoryImpl implements DoeditorFactory {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DoeditorPackage getPackage() {
		return DoeditorPackage.eINSTANCE;
	}

	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public static DoeditorFactory init() {
		try {
			DoeditorFactory theDoeditorFactory = (DoeditorFactory) EPackage.Registry.INSTANCE
					.getEFactory(DoeditorPackage.eNS_URI);
			if (theDoeditorFactory != null) {
				return theDoeditorFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DoeditorFactoryImpl();
	}

	/** @generated NOT */
	public static void initFlaechenForm(final FlaechenForm form) {
		DoeditorFactoryImpl.initLinienForm(form);
		final EColor color = EclipseFactory.eINSTANCE.createEColor();
		color.setRgb(new RGB(255, 255, 255));
		form.setBackgroundColor(color);
		form.setFilled(true);
	}

	/** @generated NOT */
	public static void initLinienForm(final LinienForm form) {
		DoeditorFactoryImpl.initPunktForm(form);
		form.setLineAttributes(EclipseFactory.eINSTANCE.createELineAttributes());
	}

	/** @generated NOT */
	public static void initPolylineForm(final PolylineForm form) {
		form.setPoints(new PointList(new int[] { 50, 50, 150, 50, 130, 100 }));
		DoeditorFactoryImpl.initLinienForm(form);
	}

	/** @generated NOT */
	public static void initPunktForm(final PunktForm form) {
		form.setBounds(new Rectangle(0, 0, 0, 0));

		final EColor color = EclipseFactory.eINSTANCE.createEColor();
		color.setRgb(new RGB(0, 0, 0));
		form.setForegroundColor(color);
	}

	/** @generated NOT */
	public static void initTextForm(final TextForm form) {
		DoeditorFactoryImpl.initFlaechenForm(form);
		form.setFont(EclipseFactory.eINSTANCE.createEFont());
	}

	/** @generated NOT */
	public static void initBorderedForm(final BorderedForm form) {
		form.setBorderColor(EclipseFactory.eINSTANCE.createEColor());
		form.setBorderWidth(0);
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DoeditorFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String convertPortableBitmapToString(final EDataType eDataType, final Object instanceValue) {
		return ((PortableBitMap) instanceValue).getPid();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPositionierungToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
		case DoeditorPackage.ZOOM_VERHALTEN:
			return convertZoomVerhaltenToString(eDataType, instanceValue);
		case DoeditorPackage.POSITIONIERUNG:
			return convertPositionierungToString(eDataType, instanceValue);
		default:
			throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public String convertZoomVerhaltenToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case DoeditorPackage.BILD_FORM:
			return createBildForm();
		case DoeditorPackage.TEXT_FORM:
			return createTextForm();
		case DoeditorPackage.POLYLINE_FORM:
			return createPolylineForm();
		case DoeditorPackage.POLYGON_FORM:
			return createPolygonForm();
		case DoeditorPackage.ELLIPSE_FORM:
			return createEllipseForm();
		case DoeditorPackage.RECHTECK_FORM:
			return createRechteckForm();
		case DoeditorPackage.DECORATOR:
			return createDecorator();
		case DoeditorPackage.ZOOM_DECORATOR:
			return createZoomDecorator();
		case DoeditorPackage.EDITOR_DO_MODEL:
			return createEditorDoModel();
		case DoeditorPackage.ATTRIBUTE_TEXT_DECORATOR:
			return createAttributeTextDecorator();
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR:
			return createBackgroundAttributeIntervalDecorator();
		case DoeditorPackage.BACKGROUND_ATTRIBUTE_TEXT_DECORATOR:
			return createBackgroundAttributeTextDecorator();
		case DoeditorPackage.BACKGROUND_ZOOM_DECORATOR:
			return createBackgroundZoomDecorator();
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR:
			return createDrehwinkelAttributeTextDecorator();
		case DoeditorPackage.DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR:
			return createDrehwinkelAttributeIntervalDecorator();
		case DoeditorPackage.DREHWINKEL_ZOOM_DECORATOR:
			return createDrehwinkelZoomDecorator();
		case DoeditorPackage.FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR:
			return createFontDataAttributeIntervalDecorator();
		case DoeditorPackage.FONT_DATA_ATTRIBUTE_TEXT_DECORATOR:
			return createFontDataAttributeTextDecorator();
		case DoeditorPackage.FONT_DATA_ZOOM_DECORATOR:
			return createFontDataZoomDecorator();
		case DoeditorPackage.FOREGROUND_ATTRIBUTE_TEXT_DECORATOR:
			return createForegroundAttributeTextDecorator();
		case DoeditorPackage.FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR:
			return createForegroundAttributeIntervalDecorator();
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR:
			return createForegroundZoomDecorator();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR:
			return createLineAttributeAttributeIntervalDecorator();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR:
			return createLineAttributeAttributeTextDecorator();
		case DoeditorPackage.LINE_ATTRIBUTE_ZOOM_DECORATOR:
			return createLineAttributeZoomDecorator();
		case DoeditorPackage.SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR:
			return createSichtbarkeitAttributeTextDecorator();
		case DoeditorPackage.SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR:
			return createSichtbarkeitAttributeIntervalDecorator();
		case DoeditorPackage.SICHTBARKEIT_ZOOM_DECORATOR:
			return createSichtbarkeitZoomDecorator();
		case DoeditorPackage.STRING_ATTRIBUTE_INTERVAL_DECORATOR:
			return createStringAttributeIntervalDecorator();
		case DoeditorPackage.STRING_ATTRIBUTE_TEXT_DECORATOR:
			return createStringAttributeTextDecorator();
		case DoeditorPackage.STRING_ZOOM_DECORATOR:
			return createStringZoomDecorator();
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR:
			return createZoomVerhaltenAttributeIntervalDecorator();
		case DoeditorPackage.ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR:
			return createZoomVerhaltenAttributeTextDecorator();
		case DoeditorPackage.ZOOM_VERHALTEN_ZOOM_DECORATOR:
			return createZoomVerhaltenZoomDecorator();
		case DoeditorPackage.EMBEDDED_DO_FORM:
			return createEmbeddedDoForm();
		case DoeditorPackage.EXTERNAL_DO_FORM:
			return createExternalDoForm();
		case DoeditorPackage.DO_EDITOR_DIAGRAMM:
			return createDoEditorDiagramm();
		case DoeditorPackage.EDITOR_DO_TYP:
			return createEditorDoTyp();
		case DoeditorPackage.EDITOR_DO_TYP_REFERENZ:
			return createEditorDoTypReferenz();
		case DoeditorPackage.BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR:
			return createBorderColorAttributeTextDecorator();
		case DoeditorPackage.BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR:
			return createBorderColorAttributeIntervalDecorator();
		case DoeditorPackage.BORDER_COLOR_ZOOM_DECORATOR:
			return createBorderColorZoomDecorator();
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR:
			return createBorderWidthAttributeTextDecorator();
		case DoeditorPackage.BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR:
			return createBorderWidthAttributeIntervalDecorator();
		case DoeditorPackage.BORDER_WIDTH_ZOOM_DECORATOR:
			return createBorderWidthZoomDecorator();
		case DoeditorPackage.IDENTIDY:
			return createIdentidy();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AttributeTextDecorator createAttributeTextDecorator() {
		AttributeTextDecoratorImpl attributeTextDecorator = new AttributeTextDecoratorImpl();
		return attributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BackgroundAttributeIntervalDecorator createBackgroundAttributeIntervalDecorator() {
		BackgroundAttributeIntervalDecoratorImpl backgroundAttributeIntervalDecorator = new BackgroundAttributeIntervalDecoratorImpl();
		return backgroundAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BackgroundAttributeTextDecorator createBackgroundAttributeTextDecorator() {
		BackgroundAttributeTextDecoratorImpl backgroundAttributeTextDecorator = new BackgroundAttributeTextDecoratorImpl();
		return backgroundAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BackgroundZoomDecorator createBackgroundZoomDecorator() {
		BackgroundZoomDecoratorImpl backgroundZoomDecorator = new BackgroundZoomDecoratorImpl();
		return backgroundZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BildForm createBildForm() {
		BildFormImpl bildForm = new BildFormImpl();
		return bildForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Decorator createDecorator() {
		DecoratorImpl decorator = new DecoratorImpl();
		return decorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoEditorDiagramm createDoEditorDiagramm() {
		DoEditorDiagrammImpl doEditorDiagramm = new DoEditorDiagrammImpl();
		return doEditorDiagramm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DrehwinkelAttributeIntervalDecorator createDrehwinkelAttributeIntervalDecorator() {
		DrehwinkelAttributeIntervalDecoratorImpl drehwinkelAttributeIntervalDecorator = new DrehwinkelAttributeIntervalDecoratorImpl();
		return drehwinkelAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DrehwinkelAttributeTextDecorator createDrehwinkelAttributeTextDecorator() {
		DrehwinkelAttributeTextDecoratorImpl drehwinkelAttributeTextDecorator = new DrehwinkelAttributeTextDecoratorImpl();
		return drehwinkelAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DrehwinkelZoomDecorator createDrehwinkelZoomDecorator() {
		DrehwinkelZoomDecoratorImpl drehwinkelZoomDecorator = new DrehwinkelZoomDecoratorImpl();
		return drehwinkelZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EditorDoModel createEditorDoModel() {
		EditorDoModelImpl editorDoModel = new EditorDoModelImpl();
		return editorDoModel;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public EditorDoTyp createEditorDoTyp() {
		final EditorDoTypImpl editorDoTyp = new EditorDoTypImpl();
		editorDoTyp.setSize(new Dimension(100, 100));
		return editorDoTyp;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EditorDoTypReferenz createEditorDoTypReferenz() {
		EditorDoTypReferenzImpl editorDoTypReferenz = new EditorDoTypReferenzImpl();
		return editorDoTypReferenz;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BorderColorAttributeTextDecorator createBorderColorAttributeTextDecorator() {
		BorderColorAttributeTextDecoratorImpl borderColorAttributeTextDecorator = new BorderColorAttributeTextDecoratorImpl();
		return borderColorAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BorderColorAttributeIntervalDecorator createBorderColorAttributeIntervalDecorator() {
		BorderColorAttributeIntervalDecoratorImpl borderColorAttributeIntervalDecorator = new BorderColorAttributeIntervalDecoratorImpl();
		return borderColorAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BorderColorZoomDecorator createBorderColorZoomDecorator() {
		BorderColorZoomDecoratorImpl borderColorZoomDecorator = new BorderColorZoomDecoratorImpl();
		return borderColorZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BorderWidthAttributeTextDecorator createBorderWidthAttributeTextDecorator() {
		BorderWidthAttributeTextDecoratorImpl borderWidthAttributeTextDecorator = new BorderWidthAttributeTextDecoratorImpl();
		return borderWidthAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BorderWidthAttributeIntervalDecorator createBorderWidthAttributeIntervalDecorator() {
		BorderWidthAttributeIntervalDecoratorImpl borderWidthAttributeIntervalDecorator = new BorderWidthAttributeIntervalDecoratorImpl();
		return borderWidthAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BorderWidthZoomDecorator createBorderWidthZoomDecorator() {
		BorderWidthZoomDecoratorImpl borderWidthZoomDecorator = new BorderWidthZoomDecoratorImpl();
		return borderWidthZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Identidy createIdentidy() {
		IdentidyImpl identidy = new IdentidyImpl();
		return identidy;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public EllipseForm createEllipseForm() {
		final EllipseFormImpl ellipseForm = new EllipseFormImpl();
		DoeditorFactoryImpl.initFlaechenForm(ellipseForm);
		return ellipseForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EmbeddedDoForm createEmbeddedDoForm() {
		EmbeddedDoFormImpl embeddedDoForm = new EmbeddedDoFormImpl();
		return embeddedDoForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ExternalDoForm createExternalDoForm() {
		ExternalDoFormImpl externalDoForm = new ExternalDoFormImpl();
		return externalDoForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FontDataAttributeIntervalDecorator createFontDataAttributeIntervalDecorator() {
		FontDataAttributeIntervalDecoratorImpl fontDataAttributeIntervalDecorator = new FontDataAttributeIntervalDecoratorImpl();
		return fontDataAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FontDataAttributeTextDecorator createFontDataAttributeTextDecorator() {
		FontDataAttributeTextDecoratorImpl fontDataAttributeTextDecorator = new FontDataAttributeTextDecoratorImpl();
		return fontDataAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FontDataZoomDecorator createFontDataZoomDecorator() {
		FontDataZoomDecoratorImpl fontDataZoomDecorator = new FontDataZoomDecoratorImpl();
		return fontDataZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ForegroundAttributeIntervalDecorator createForegroundAttributeIntervalDecorator() {
		ForegroundAttributeIntervalDecoratorImpl foregroundAttributeIntervalDecorator = new ForegroundAttributeIntervalDecoratorImpl();
		return foregroundAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ForegroundAttributeTextDecorator createForegroundAttributeTextDecorator() {
		ForegroundAttributeTextDecoratorImpl foregroundAttributeTextDecorator = new ForegroundAttributeTextDecoratorImpl();
		return foregroundAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ForegroundZoomDecorator createForegroundZoomDecorator() {
		ForegroundZoomDecoratorImpl foregroundZoomDecorator = new ForegroundZoomDecoratorImpl();
		return foregroundZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
		case DoeditorPackage.ZOOM_VERHALTEN:
			return createZoomVerhaltenFromString(eDataType, initialValue);
		case DoeditorPackage.POSITIONIERUNG:
			return createPositionierungFromString(eDataType, initialValue);
		default:
			throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LineAttributeAttributeIntervalDecorator createLineAttributeAttributeIntervalDecorator() {
		LineAttributeAttributeIntervalDecoratorImpl lineAttributeAttributeIntervalDecorator = new LineAttributeAttributeIntervalDecoratorImpl();
		return lineAttributeAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LineAttributeAttributeTextDecorator createLineAttributeAttributeTextDecorator() {
		LineAttributeAttributeTextDecoratorImpl lineAttributeAttributeTextDecorator = new LineAttributeAttributeTextDecoratorImpl();
		return lineAttributeAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LineAttributeZoomDecorator createLineAttributeZoomDecorator() {
		LineAttributeZoomDecoratorImpl lineAttributeZoomDecorator = new LineAttributeZoomDecoratorImpl();
		return lineAttributeZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public PolygonForm createPolygonForm() {
		final PolygonFormImpl polygonForm = new PolygonFormImpl();
		DoeditorFactoryImpl.initPolylineForm(polygonForm);
		DoeditorFactoryImpl.initFlaechenForm(polygonForm);
		return polygonForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public PolylineForm createPolylineForm() {
		final PolylineFormImpl polylineForm = new PolylineFormImpl();
		DoeditorFactoryImpl.initPolylineForm(polylineForm);
		return polylineForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public PortableBitMap createPortableBitmapFromString(final EDataType eDataType, final String initialValue) {
		return (PortableBitMap) RahmenwerkService.getService().getObjektFactory().getModellobjekt(initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Positionierung createPositionierungFromString(EDataType eDataType, String initialValue) {
		Positionierung result = Positionierung.get(initialValue);
		if (result == null)
			throw new IllegalArgumentException(
					"The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public RechteckForm createRechteckForm() {
		final RechteckFormImpl rechteckForm = new RechteckFormImpl();
		DoeditorFactoryImpl.initFlaechenForm(rechteckForm);
		return rechteckForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SichtbarkeitAttributeIntervalDecorator createSichtbarkeitAttributeIntervalDecorator() {
		SichtbarkeitAttributeIntervalDecoratorImpl sichtbarkeitAttributeIntervalDecorator = new SichtbarkeitAttributeIntervalDecoratorImpl();
		return sichtbarkeitAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SichtbarkeitAttributeTextDecorator createSichtbarkeitAttributeTextDecorator() {
		SichtbarkeitAttributeTextDecoratorImpl sichtbarkeitAttributeTextDecorator = new SichtbarkeitAttributeTextDecoratorImpl();
		return sichtbarkeitAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SichtbarkeitZoomDecorator createSichtbarkeitZoomDecorator() {
		SichtbarkeitZoomDecoratorImpl sichtbarkeitZoomDecorator = new SichtbarkeitZoomDecoratorImpl();
		return sichtbarkeitZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StringAttributeIntervalDecorator createStringAttributeIntervalDecorator() {
		StringAttributeIntervalDecoratorImpl stringAttributeIntervalDecorator = new StringAttributeIntervalDecoratorImpl();
		return stringAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StringAttributeTextDecorator createStringAttributeTextDecorator() {
		StringAttributeTextDecoratorImpl stringAttributeTextDecorator = new StringAttributeTextDecoratorImpl();
		return stringAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public StringZoomDecorator createStringZoomDecorator() {
		StringZoomDecoratorImpl stringZoomDecorator = new StringZoomDecoratorImpl();
		return stringZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public TextForm createTextForm() {
		final TextFormImpl textForm = new TextFormImpl();
		DoeditorFactoryImpl.initTextForm(textForm);
		DoeditorFactoryImpl.initBorderedForm(textForm);
		return textForm;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomDecorator createZoomDecorator() {
		ZoomDecoratorImpl zoomDecorator = new ZoomDecoratorImpl();
		return zoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomVerhaltenAttributeIntervalDecorator createZoomVerhaltenAttributeIntervalDecorator() {
		ZoomVerhaltenAttributeIntervalDecoratorImpl zoomVerhaltenAttributeIntervalDecorator = new ZoomVerhaltenAttributeIntervalDecoratorImpl();
		return zoomVerhaltenAttributeIntervalDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomVerhaltenAttributeTextDecorator createZoomVerhaltenAttributeTextDecorator() {
		ZoomVerhaltenAttributeTextDecoratorImpl zoomVerhaltenAttributeTextDecorator = new ZoomVerhaltenAttributeTextDecoratorImpl();
		return zoomVerhaltenAttributeTextDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ZoomVerhalten createZoomVerhaltenFromString(EDataType eDataType, String initialValue) {
		ZoomVerhalten result = ZoomVerhalten.get(initialValue);
		if (result == null)
			throw new IllegalArgumentException(
					"The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ZoomVerhaltenZoomDecorator createZoomVerhaltenZoomDecorator() {
		ZoomVerhaltenZoomDecoratorImpl zoomVerhaltenZoomDecorator = new ZoomVerhaltenZoomDecoratorImpl();
		return zoomVerhaltenZoomDecorator;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DoeditorPackage getDoeditorPackage() {
		return (DoeditorPackage) getEPackage();
	}

} // DoeditorFactoryImpl
