/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator;
import de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BildForm;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.BorderedForm;
import de.bsvrz.buv.plugin.doeditor.model.ColorParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoModel;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.buv.plugin.doeditor.model.EllipseForm;
import de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;
import de.bsvrz.buv.plugin.doeditor.model.FlaechenForm;
import de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;
import de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LinienForm;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.PolygonForm;
import de.bsvrz.buv.plugin.doeditor.model.PolylineForm;
import de.bsvrz.buv.plugin.doeditor.model.Positionierung;
import de.bsvrz.buv.plugin.doeditor.model.PunktForm;
import de.bsvrz.buv.plugin.doeditor.model.RechteckForm;
import de.bsvrz.buv.plugin.doeditor.model.RotatableForm;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.TextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.TextForm;
import de.bsvrz.buv.plugin.doeditor.model.VisibleForm;
import de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomableForm;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DoeditorPackageImpl extends EPackageImpl implements DoeditorPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass visibleFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rotatableFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderedFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomableFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass punktFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass bildFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass textFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass polylineFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass polygonFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass flaechenFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ellipseFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rechteckFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass linienFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass decoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass textDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributeDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass intervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass editorDoModelEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass backgroundAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass parameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass colorParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass backgroundParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass foregroundParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderColorParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fontDataParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass drehwinkelParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lineAttributeParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sichtbarkeitParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomVerhaltenParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass backgroundAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass backgroundZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass drehwinkelAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass drehwinkelAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass drehwinkelZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fontDataAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fontDataAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fontDataZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass foregroundAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass foregroundAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass foregroundZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lineAttributeAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lineAttributeAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lineAttributeZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sichtbarkeitAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sichtbarkeitAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sichtbarkeitZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomVerhaltenAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomVerhaltenAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass zoomVerhaltenZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass embeddedDoFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass externalDoFormEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass doEditorDiagrammEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass editorDoTypEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass editorDoTypReferenzEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderWidthParameterDefinitionEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderColorAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderColorAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderColorZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderWidthAttributeTextDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderWidthAttributeIntervalDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass borderWidthZoomDecoratorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass identidyEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum zoomVerhaltenEEnum = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum positionierungEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DoeditorPackageImpl() {
		super(eNS_URI, DoeditorFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link DoeditorPackage#eINSTANCE} when
	 * that field is accessed. Clients should not invoke it directly. Instead,
	 * they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DoeditorPackage init() {
		if (isInited)
			return (DoeditorPackage) EPackage.Registry.INSTANCE.getEPackage(DoeditorPackage.eNS_URI);

		// Obtain or create and register package
		DoeditorPackageImpl theDoeditorPackage = (DoeditorPackageImpl) (EPackage.Registry.INSTANCE
				.get(eNS_URI) instanceof DoeditorPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI)
						: new DoeditorPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		DobjPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theDoeditorPackage.createPackageContents();

		// Initialize created meta-data
		theDoeditorPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theDoeditorPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(DoeditorPackage.eNS_URI, theDoeditorPackage);
		return theDoeditorPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVisibleForm() {
		return visibleFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVisibleForm_EditorDoTyp() {
		return (EReference) visibleFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getVisibleForm_Visible() {
		return (EAttribute) visibleFormEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVisibleForm_Decorators() {
		return (EReference) visibleFormEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRotatableForm() {
		return rotatableFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRotatableForm_Angle() {
		return (EAttribute) rotatableFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderedForm() {
		return borderedFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBorderedForm_BorderWidth() {
		return (EAttribute) borderedFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBorderedForm_BorderColor() {
		return (EReference) borderedFormEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomableForm() {
		return zoomableFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getZoomableForm_ZoomVerhalten() {
		return (EAttribute) zoomableFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPunktForm() {
		return punktFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPunktForm_ForegroundColor() {
		return (EReference) punktFormEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPunktForm_Positionierung() {
		return (EAttribute) punktFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPunktForm_Bounds() {
		return (EAttribute) punktFormEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBildForm() {
		return bildFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBildForm_Bild() {
		return (EAttribute) bildFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTextForm() {
		return textFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTextForm_Text() {
		return (EAttribute) textFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTextForm_HorizontalAlignment() {
		return (EAttribute) textFormEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTextForm_VerticalAlignment() {
		return (EAttribute) textFormEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTextForm_Font() {
		return (EReference) textFormEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPolylineForm() {
		return polylineFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPolylineForm_Points() {
		return (EAttribute) polylineFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPolygonForm() {
		return polygonFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFlaechenForm() {
		return flaechenFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFlaechenForm_BackgroundColor() {
		return (EReference) flaechenFormEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFlaechenForm_BackgroundPattern() {
		return (EAttribute) flaechenFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFlaechenForm_Filled() {
		return (EAttribute) flaechenFormEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEllipseForm() {
		return ellipseFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRechteckForm() {
		return rechteckFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLinienForm() {
		return linienFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLinienForm_LineAttributes() {
		return (EReference) linienFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDecorator() {
		return decoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTextDecorator() {
		return textDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTextDecorator_Text() {
		return (EAttribute) textDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAttributeDecorator() {
		return attributeDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeDecorator_AttributGruppe() {
		return (EAttribute) attributeDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeDecorator_Aspekt() {
		return (EAttribute) attributeDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAttributeDecorator_AttributPfad() {
		return (EAttribute) attributeDecoratorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIntervalDecorator() {
		return intervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIntervalDecorator_Start() {
		return (EAttribute) intervalDecoratorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIntervalDecorator_End() {
		return (EAttribute) intervalDecoratorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomDecorator() {
		return zoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEditorDoModel() {
		return editorDoModelEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAttributeTextDecorator() {
		return attributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAttributeIntervalDecorator() {
		return attributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBackgroundAttributeIntervalDecorator() {
		return backgroundAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getParameterDefinition() {
		return parameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getColorParameterDefinition() {
		return colorParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getColorParameterDefinition_StartColor() {
		return (EReference) colorParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getColorParameterDefinition_EndColor() {
		return (EReference) colorParameterDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBackgroundParameterDefinition() {
		return backgroundParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getForegroundParameterDefinition() {
		return foregroundParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderColorParameterDefinition() {
		return borderColorParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFontDataParameterDefinition() {
		return fontDataParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFontDataParameterDefinition_Font() {
		return (EReference) fontDataParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDrehwinkelParameterDefinition() {
		return drehwinkelParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDrehwinkelParameterDefinition_StartWinkel() {
		return (EAttribute) drehwinkelParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDrehwinkelParameterDefinition_EndWinkel() {
		return (EAttribute) drehwinkelParameterDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLineAttributeParameterDefinition() {
		return lineAttributeParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getLineAttributeParameterDefinition_LineAttributes() {
		return (EReference) lineAttributeParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringParameterDefinition() {
		return stringParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStringParameterDefinition_String() {
		return (EAttribute) stringParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSichtbarkeitParameterDefinition() {
		return sichtbarkeitParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSichtbarkeitParameterDefinition_Sichtbar() {
		return (EAttribute) sichtbarkeitParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomVerhaltenParameterDefinition() {
		return zoomVerhaltenParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getZoomVerhaltenParameterDefinition_ZoomVerhalten() {
		return (EAttribute) zoomVerhaltenParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBackgroundAttributeTextDecorator() {
		return backgroundAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBackgroundZoomDecorator() {
		return backgroundZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDrehwinkelAttributeTextDecorator() {
		return drehwinkelAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDrehwinkelAttributeIntervalDecorator() {
		return drehwinkelAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDrehwinkelZoomDecorator() {
		return drehwinkelZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFontDataAttributeIntervalDecorator() {
		return fontDataAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFontDataAttributeTextDecorator() {
		return fontDataAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFontDataZoomDecorator() {
		return fontDataZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getForegroundAttributeTextDecorator() {
		return foregroundAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getForegroundAttributeIntervalDecorator() {
		return foregroundAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getForegroundZoomDecorator() {
		return foregroundZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLineAttributeAttributeIntervalDecorator() {
		return lineAttributeAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLineAttributeAttributeTextDecorator() {
		return lineAttributeAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getLineAttributeZoomDecorator() {
		return lineAttributeZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSichtbarkeitAttributeTextDecorator() {
		return sichtbarkeitAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSichtbarkeitAttributeIntervalDecorator() {
		return sichtbarkeitAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSichtbarkeitZoomDecorator() {
		return sichtbarkeitZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringAttributeIntervalDecorator() {
		return stringAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringAttributeTextDecorator() {
		return stringAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringZoomDecorator() {
		return stringZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomVerhaltenAttributeIntervalDecorator() {
		return zoomVerhaltenAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomVerhaltenAttributeTextDecorator() {
		return zoomVerhaltenAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getZoomVerhaltenZoomDecorator() {
		return zoomVerhaltenZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEmbeddedDoForm() {
		return embeddedDoFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEmbeddedDoForm_DarstellungsObjektTyp() {
		return (EReference) embeddedDoFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExternalDoForm() {
		return externalDoFormEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExternalDoForm_DarstellungsObjektTyp() {
		return (EReference) externalDoFormEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExternalDoForm_ExtensionPointID() {
		return (EAttribute) externalDoFormEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDoEditorDiagramm() {
		return doEditorDiagrammEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDoEditorDiagramm_DoTyp() {
		return (EReference) doEditorDiagrammEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEditorDoTyp() {
		return editorDoTypEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTyp_SystemObjekt() {
		return (EAttribute) editorDoTypEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTyp_Hotspot() {
		return (EAttribute) editorDoTypEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTyp_AnLinieAusrichten() {
		return (EAttribute) editorDoTypEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEditorDoTyp_Formen() {
		return (EReference) editorDoTypEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTyp_DoTypPid() {
		return (EAttribute) editorDoTypEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTyp_LastUsedLevelId() {
		return (EAttribute) editorDoTypEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTyp_SystemObjectType() {
		return (EAttribute) editorDoTypEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEditorDoTypReferenz() {
		return editorDoTypReferenzEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEditorDoTypReferenz_SystemObjekt() {
		return (EAttribute) editorDoTypReferenzEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEditorDoTypReferenz_Wrapped() {
		return (EReference) editorDoTypReferenzEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderWidthParameterDefinition() {
		return borderWidthParameterDefinitionEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBorderWidthParameterDefinition_StartWert() {
		return (EAttribute) borderWidthParameterDefinitionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getBorderWidthParameterDefinition_EndWert() {
		return (EAttribute) borderWidthParameterDefinitionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderColorAttributeTextDecorator() {
		return borderColorAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderColorAttributeIntervalDecorator() {
		return borderColorAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderColorZoomDecorator() {
		return borderColorZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderWidthAttributeTextDecorator() {
		return borderWidthAttributeTextDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderWidthAttributeIntervalDecorator() {
		return borderWidthAttributeIntervalDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBorderWidthZoomDecorator() {
		return borderWidthZoomDecoratorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIdentidy() {
		return identidyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIdentidy_Id() {
		return (EAttribute) identidyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getZoomVerhalten() {
		return zoomVerhaltenEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getPositionierung() {
		return positionierungEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DoeditorFactory getDoeditorFactory() {
		return (DoeditorFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated = true;

		// Create classes and their features
		visibleFormEClass = createEClass(VISIBLE_FORM);
		createEReference(visibleFormEClass, VISIBLE_FORM__EDITOR_DO_TYP);
		createEAttribute(visibleFormEClass, VISIBLE_FORM__VISIBLE);
		createEReference(visibleFormEClass, VISIBLE_FORM__DECORATORS);

		rotatableFormEClass = createEClass(ROTATABLE_FORM);
		createEAttribute(rotatableFormEClass, ROTATABLE_FORM__ANGLE);

		borderedFormEClass = createEClass(BORDERED_FORM);
		createEAttribute(borderedFormEClass, BORDERED_FORM__BORDER_WIDTH);
		createEReference(borderedFormEClass, BORDERED_FORM__BORDER_COLOR);

		zoomableFormEClass = createEClass(ZOOMABLE_FORM);
		createEAttribute(zoomableFormEClass, ZOOMABLE_FORM__ZOOM_VERHALTEN);

		punktFormEClass = createEClass(PUNKT_FORM);
		createEAttribute(punktFormEClass, PUNKT_FORM__POSITIONIERUNG);
		createEAttribute(punktFormEClass, PUNKT_FORM__BOUNDS);
		createEReference(punktFormEClass, PUNKT_FORM__FOREGROUND_COLOR);

		bildFormEClass = createEClass(BILD_FORM);
		createEAttribute(bildFormEClass, BILD_FORM__BILD);

		textFormEClass = createEClass(TEXT_FORM);
		createEAttribute(textFormEClass, TEXT_FORM__TEXT);
		createEAttribute(textFormEClass, TEXT_FORM__HORIZONTAL_ALIGNMENT);
		createEAttribute(textFormEClass, TEXT_FORM__VERTICAL_ALIGNMENT);
		createEReference(textFormEClass, TEXT_FORM__FONT);

		polylineFormEClass = createEClass(POLYLINE_FORM);
		createEAttribute(polylineFormEClass, POLYLINE_FORM__POINTS);

		polygonFormEClass = createEClass(POLYGON_FORM);

		flaechenFormEClass = createEClass(FLAECHEN_FORM);
		createEAttribute(flaechenFormEClass, FLAECHEN_FORM__BACKGROUND_PATTERN);
		createEAttribute(flaechenFormEClass, FLAECHEN_FORM__FILLED);
		createEReference(flaechenFormEClass, FLAECHEN_FORM__BACKGROUND_COLOR);

		ellipseFormEClass = createEClass(ELLIPSE_FORM);

		rechteckFormEClass = createEClass(RECHTECK_FORM);

		linienFormEClass = createEClass(LINIEN_FORM);
		createEReference(linienFormEClass, LINIEN_FORM__LINE_ATTRIBUTES);

		decoratorEClass = createEClass(DECORATOR);

		textDecoratorEClass = createEClass(TEXT_DECORATOR);
		createEAttribute(textDecoratorEClass, TEXT_DECORATOR__TEXT);

		attributeDecoratorEClass = createEClass(ATTRIBUTE_DECORATOR);
		createEAttribute(attributeDecoratorEClass, ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE);
		createEAttribute(attributeDecoratorEClass, ATTRIBUTE_DECORATOR__ASPEKT);
		createEAttribute(attributeDecoratorEClass, ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD);

		intervalDecoratorEClass = createEClass(INTERVAL_DECORATOR);
		createEAttribute(intervalDecoratorEClass, INTERVAL_DECORATOR__START);
		createEAttribute(intervalDecoratorEClass, INTERVAL_DECORATOR__END);

		zoomDecoratorEClass = createEClass(ZOOM_DECORATOR);

		editorDoModelEClass = createEClass(EDITOR_DO_MODEL);

		attributeTextDecoratorEClass = createEClass(ATTRIBUTE_TEXT_DECORATOR);

		attributeIntervalDecoratorEClass = createEClass(ATTRIBUTE_INTERVAL_DECORATOR);

		backgroundAttributeIntervalDecoratorEClass = createEClass(BACKGROUND_ATTRIBUTE_INTERVAL_DECORATOR);

		parameterDefinitionEClass = createEClass(PARAMETER_DEFINITION);

		colorParameterDefinitionEClass = createEClass(COLOR_PARAMETER_DEFINITION);
		createEReference(colorParameterDefinitionEClass, COLOR_PARAMETER_DEFINITION__START_COLOR);
		createEReference(colorParameterDefinitionEClass, COLOR_PARAMETER_DEFINITION__END_COLOR);

		backgroundParameterDefinitionEClass = createEClass(BACKGROUND_PARAMETER_DEFINITION);

		foregroundParameterDefinitionEClass = createEClass(FOREGROUND_PARAMETER_DEFINITION);

		borderColorParameterDefinitionEClass = createEClass(BORDER_COLOR_PARAMETER_DEFINITION);

		fontDataParameterDefinitionEClass = createEClass(FONT_DATA_PARAMETER_DEFINITION);
		createEReference(fontDataParameterDefinitionEClass, FONT_DATA_PARAMETER_DEFINITION__FONT);

		drehwinkelParameterDefinitionEClass = createEClass(DREHWINKEL_PARAMETER_DEFINITION);
		createEAttribute(drehwinkelParameterDefinitionEClass, DREHWINKEL_PARAMETER_DEFINITION__START_WINKEL);
		createEAttribute(drehwinkelParameterDefinitionEClass, DREHWINKEL_PARAMETER_DEFINITION__END_WINKEL);

		lineAttributeParameterDefinitionEClass = createEClass(LINE_ATTRIBUTE_PARAMETER_DEFINITION);
		createEReference(lineAttributeParameterDefinitionEClass, LINE_ATTRIBUTE_PARAMETER_DEFINITION__LINE_ATTRIBUTES);

		stringParameterDefinitionEClass = createEClass(STRING_PARAMETER_DEFINITION);
		createEAttribute(stringParameterDefinitionEClass, STRING_PARAMETER_DEFINITION__STRING);

		sichtbarkeitParameterDefinitionEClass = createEClass(SICHTBARKEIT_PARAMETER_DEFINITION);
		createEAttribute(sichtbarkeitParameterDefinitionEClass, SICHTBARKEIT_PARAMETER_DEFINITION__SICHTBAR);

		zoomVerhaltenParameterDefinitionEClass = createEClass(ZOOM_VERHALTEN_PARAMETER_DEFINITION);
		createEAttribute(zoomVerhaltenParameterDefinitionEClass, ZOOM_VERHALTEN_PARAMETER_DEFINITION__ZOOM_VERHALTEN);

		backgroundAttributeTextDecoratorEClass = createEClass(BACKGROUND_ATTRIBUTE_TEXT_DECORATOR);

		backgroundZoomDecoratorEClass = createEClass(BACKGROUND_ZOOM_DECORATOR);

		drehwinkelAttributeTextDecoratorEClass = createEClass(DREHWINKEL_ATTRIBUTE_TEXT_DECORATOR);

		drehwinkelAttributeIntervalDecoratorEClass = createEClass(DREHWINKEL_ATTRIBUTE_INTERVAL_DECORATOR);

		drehwinkelZoomDecoratorEClass = createEClass(DREHWINKEL_ZOOM_DECORATOR);

		fontDataAttributeIntervalDecoratorEClass = createEClass(FONT_DATA_ATTRIBUTE_INTERVAL_DECORATOR);

		fontDataAttributeTextDecoratorEClass = createEClass(FONT_DATA_ATTRIBUTE_TEXT_DECORATOR);

		fontDataZoomDecoratorEClass = createEClass(FONT_DATA_ZOOM_DECORATOR);

		foregroundAttributeTextDecoratorEClass = createEClass(FOREGROUND_ATTRIBUTE_TEXT_DECORATOR);

		foregroundAttributeIntervalDecoratorEClass = createEClass(FOREGROUND_ATTRIBUTE_INTERVAL_DECORATOR);

		foregroundZoomDecoratorEClass = createEClass(FOREGROUND_ZOOM_DECORATOR);

		lineAttributeAttributeIntervalDecoratorEClass = createEClass(LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR);

		lineAttributeAttributeTextDecoratorEClass = createEClass(LINE_ATTRIBUTE_ATTRIBUTE_TEXT_DECORATOR);

		lineAttributeZoomDecoratorEClass = createEClass(LINE_ATTRIBUTE_ZOOM_DECORATOR);

		sichtbarkeitAttributeTextDecoratorEClass = createEClass(SICHTBARKEIT_ATTRIBUTE_TEXT_DECORATOR);

		sichtbarkeitAttributeIntervalDecoratorEClass = createEClass(SICHTBARKEIT_ATTRIBUTE_INTERVAL_DECORATOR);

		sichtbarkeitZoomDecoratorEClass = createEClass(SICHTBARKEIT_ZOOM_DECORATOR);

		stringAttributeIntervalDecoratorEClass = createEClass(STRING_ATTRIBUTE_INTERVAL_DECORATOR);

		stringAttributeTextDecoratorEClass = createEClass(STRING_ATTRIBUTE_TEXT_DECORATOR);

		stringZoomDecoratorEClass = createEClass(STRING_ZOOM_DECORATOR);

		zoomVerhaltenAttributeIntervalDecoratorEClass = createEClass(ZOOM_VERHALTEN_ATTRIBUTE_INTERVAL_DECORATOR);

		zoomVerhaltenAttributeTextDecoratorEClass = createEClass(ZOOM_VERHALTEN_ATTRIBUTE_TEXT_DECORATOR);

		zoomVerhaltenZoomDecoratorEClass = createEClass(ZOOM_VERHALTEN_ZOOM_DECORATOR);

		embeddedDoFormEClass = createEClass(EMBEDDED_DO_FORM);
		createEReference(embeddedDoFormEClass, EMBEDDED_DO_FORM__DARSTELLUNGS_OBJEKT_TYP);

		externalDoFormEClass = createEClass(EXTERNAL_DO_FORM);
		createEReference(externalDoFormEClass, EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP);
		createEAttribute(externalDoFormEClass, EXTERNAL_DO_FORM__EXTENSION_POINT_ID);

		doEditorDiagrammEClass = createEClass(DO_EDITOR_DIAGRAMM);
		createEReference(doEditorDiagrammEClass, DO_EDITOR_DIAGRAMM__DO_TYP);

		editorDoTypEClass = createEClass(EDITOR_DO_TYP);
		createEAttribute(editorDoTypEClass, EDITOR_DO_TYP__SYSTEM_OBJEKT);
		createEAttribute(editorDoTypEClass, EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE);
		createEAttribute(editorDoTypEClass, EDITOR_DO_TYP__HOTSPOT);
		createEAttribute(editorDoTypEClass, EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN);
		createEReference(editorDoTypEClass, EDITOR_DO_TYP__FORMEN);
		createEAttribute(editorDoTypEClass, EDITOR_DO_TYP__DO_TYP_PID);
		createEAttribute(editorDoTypEClass, EDITOR_DO_TYP__LAST_USED_LEVEL_ID);

		editorDoTypReferenzEClass = createEClass(EDITOR_DO_TYP_REFERENZ);
		createEAttribute(editorDoTypReferenzEClass, EDITOR_DO_TYP_REFERENZ__SYSTEM_OBJEKT);
		createEReference(editorDoTypReferenzEClass, EDITOR_DO_TYP_REFERENZ__WRAPPED);

		borderWidthParameterDefinitionEClass = createEClass(BORDER_WIDTH_PARAMETER_DEFINITION);
		createEAttribute(borderWidthParameterDefinitionEClass, BORDER_WIDTH_PARAMETER_DEFINITION__START_WERT);
		createEAttribute(borderWidthParameterDefinitionEClass, BORDER_WIDTH_PARAMETER_DEFINITION__END_WERT);

		borderColorAttributeTextDecoratorEClass = createEClass(BORDER_COLOR_ATTRIBUTE_TEXT_DECORATOR);

		borderColorAttributeIntervalDecoratorEClass = createEClass(BORDER_COLOR_ATTRIBUTE_INTERVAL_DECORATOR);

		borderColorZoomDecoratorEClass = createEClass(BORDER_COLOR_ZOOM_DECORATOR);

		borderWidthAttributeTextDecoratorEClass = createEClass(BORDER_WIDTH_ATTRIBUTE_TEXT_DECORATOR);

		borderWidthAttributeIntervalDecoratorEClass = createEClass(BORDER_WIDTH_ATTRIBUTE_INTERVAL_DECORATOR);

		borderWidthZoomDecoratorEClass = createEClass(BORDER_WIDTH_ZOOM_DECORATOR);

		identidyEClass = createEClass(IDENTIDY);
		createEAttribute(identidyEClass, IDENTIDY__ID);

		// Create enums
		zoomVerhaltenEEnum = createEEnum(ZOOM_VERHALTEN);
		positionierungEEnum = createEEnum(POSITIONIERUNG);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EclipsePackage theEclipsePackage = (EclipsePackage) EPackage.Registry.INSTANCE
				.getEPackage(EclipsePackage.eNS_URI);
		GefPackage theGefPackage = (GefPackage) EPackage.Registry.INSTANCE.getEPackage(GefPackage.eNS_URI);
		DavbitctrlPackage theDavbitctrlPackage = (DavbitctrlPackage) EPackage.Registry.INSTANCE
				.getEPackage(DavbitctrlPackage.eNS_URI);
		DavPackage theDavPackage = (DavPackage) EPackage.Registry.INSTANCE.getEPackage(DavPackage.eNS_URI);
		DobjPackage theDobjPackage = (DobjPackage) EPackage.Registry.INSTANCE.getEPackage(DobjPackage.eNS_URI);
		DobjDecoratorPackage theDobjDecoratorPackage = (DobjDecoratorPackage) EPackage.Registry.INSTANCE
				.getEPackage(DobjDecoratorPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		visibleFormEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		visibleFormEClass.getESuperTypes().add(theGefPackage.getLocated());
		rotatableFormEClass.getESuperTypes().add(this.getVisibleForm());
		borderedFormEClass.getESuperTypes().add(this.getVisibleForm());
		zoomableFormEClass.getESuperTypes().add(this.getVisibleForm());
		punktFormEClass.getESuperTypes().add(this.getRotatableForm());
		punktFormEClass.getESuperTypes().add(this.getZoomableForm());
		bildFormEClass.getESuperTypes().add(this.getRotatableForm());
		bildFormEClass.getESuperTypes().add(this.getZoomableForm());
		textFormEClass.getESuperTypes().add(this.getFlaechenForm());
		textFormEClass.getESuperTypes().add(theGefPackage.getSized());
		textFormEClass.getESuperTypes().add(this.getBorderedForm());
		polylineFormEClass.getESuperTypes().add(this.getLinienForm());
		polygonFormEClass.getESuperTypes().add(this.getPolylineForm());
		polygonFormEClass.getESuperTypes().add(this.getFlaechenForm());
		flaechenFormEClass.getESuperTypes().add(this.getLinienForm());
		flaechenFormEClass.getESuperTypes().add(theGefPackage.getSized());
		ellipseFormEClass.getESuperTypes().add(this.getFlaechenForm());
		rechteckFormEClass.getESuperTypes().add(this.getFlaechenForm());
		linienFormEClass.getESuperTypes().add(this.getPunktForm());
		textDecoratorEClass.getESuperTypes().add(this.getDecorator());
		attributeDecoratorEClass.getESuperTypes().add(this.getDecorator());
		intervalDecoratorEClass.getESuperTypes().add(this.getDecorator());
		zoomDecoratorEClass.getESuperTypes().add(this.getIntervalDecorator());
		EGenericType g1 = createEGenericType(theDobjPackage.getDoModel());
		editorDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjPackage.getDoKompositum());
		EGenericType g2 = createEGenericType(theDobjPackage.getDoModel());
		g1.getETypeArguments().add(g2);
		editorDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getSkalierungDecorator());
		editorDoModelEClass.getEGenericSuperTypes().add(g1);
		g1 = createEGenericType(theDobjDecoratorPackage.getDrehungDecorator());
		editorDoModelEClass.getEGenericSuperTypes().add(g1);
		attributeTextDecoratorEClass.getESuperTypes().add(this.getTextDecorator());
		attributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeDecorator());
		attributeIntervalDecoratorEClass.getESuperTypes().add(this.getIntervalDecorator());
		attributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeDecorator());
		backgroundAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		backgroundAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getBackgroundParameterDefinition());
		colorParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		backgroundParameterDefinitionEClass.getESuperTypes().add(this.getColorParameterDefinition());
		foregroundParameterDefinitionEClass.getESuperTypes().add(this.getColorParameterDefinition());
		borderColorParameterDefinitionEClass.getESuperTypes().add(this.getColorParameterDefinition());
		fontDataParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		drehwinkelParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		lineAttributeParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		stringParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		sichtbarkeitParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		zoomVerhaltenParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		backgroundAttributeTextDecoratorEClass.getESuperTypes().add(this.getBackgroundParameterDefinition());
		backgroundAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		backgroundZoomDecoratorEClass.getESuperTypes().add(this.getBackgroundParameterDefinition());
		backgroundZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		drehwinkelAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		drehwinkelAttributeTextDecoratorEClass.getESuperTypes().add(this.getDrehwinkelParameterDefinition());
		drehwinkelAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		drehwinkelAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getDrehwinkelParameterDefinition());
		drehwinkelZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		drehwinkelZoomDecoratorEClass.getESuperTypes().add(this.getDrehwinkelParameterDefinition());
		fontDataAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getFontDataParameterDefinition());
		fontDataAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		fontDataAttributeTextDecoratorEClass.getESuperTypes().add(this.getFontDataParameterDefinition());
		fontDataAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		fontDataZoomDecoratorEClass.getESuperTypes().add(this.getFontDataParameterDefinition());
		fontDataZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		foregroundAttributeTextDecoratorEClass.getESuperTypes().add(this.getForegroundParameterDefinition());
		foregroundAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		foregroundAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getForegroundParameterDefinition());
		foregroundAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		foregroundZoomDecoratorEClass.getESuperTypes().add(this.getForegroundParameterDefinition());
		foregroundZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		lineAttributeAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getLineAttributeParameterDefinition());
		lineAttributeAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		lineAttributeAttributeTextDecoratorEClass.getESuperTypes().add(this.getLineAttributeParameterDefinition());
		lineAttributeAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		lineAttributeZoomDecoratorEClass.getESuperTypes().add(this.getLineAttributeParameterDefinition());
		lineAttributeZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		sichtbarkeitAttributeTextDecoratorEClass.getESuperTypes().add(this.getSichtbarkeitParameterDefinition());
		sichtbarkeitAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		sichtbarkeitAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getSichtbarkeitParameterDefinition());
		sichtbarkeitAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		sichtbarkeitZoomDecoratorEClass.getESuperTypes().add(this.getSichtbarkeitParameterDefinition());
		sichtbarkeitZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		stringAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		stringAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getStringParameterDefinition());
		stringAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		stringAttributeTextDecoratorEClass.getESuperTypes().add(this.getStringParameterDefinition());
		stringZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		stringZoomDecoratorEClass.getESuperTypes().add(this.getStringParameterDefinition());
		zoomVerhaltenAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		zoomVerhaltenAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getZoomVerhaltenParameterDefinition());
		zoomVerhaltenAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		zoomVerhaltenAttributeTextDecoratorEClass.getESuperTypes().add(this.getZoomVerhaltenParameterDefinition());
		zoomVerhaltenZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		zoomVerhaltenZoomDecoratorEClass.getESuperTypes().add(this.getZoomVerhaltenParameterDefinition());
		embeddedDoFormEClass.getESuperTypes().add(this.getVisibleForm());
		embeddedDoFormEClass.getESuperTypes().add(this.getIdentidy());
		externalDoFormEClass.getESuperTypes().add(this.getVisibleForm());
		externalDoFormEClass.getESuperTypes().add(this.getIdentidy());
		doEditorDiagrammEClass.getESuperTypes().add(theGefPackage.getLocated());
		doEditorDiagrammEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		editorDoTypEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		editorDoTypEClass.getESuperTypes().add(theGefPackage.getLocated());
		editorDoTypEClass.getESuperTypes().add(theGefPackage.getSized());
		editorDoTypReferenzEClass.getESuperTypes().add(theDobjPackage.getDoTyp());
		editorDoTypReferenzEClass.getESuperTypes().add(theDobjDecoratorPackage.getSkalierungDecorator());
		editorDoTypReferenzEClass.getESuperTypes().add(theDobjDecoratorPackage.getDrehungDecorator());
		borderWidthParameterDefinitionEClass.getESuperTypes().add(this.getParameterDefinition());
		borderColorAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		borderColorAttributeTextDecoratorEClass.getESuperTypes().add(this.getBorderColorParameterDefinition());
		borderColorAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		borderColorAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getBorderColorParameterDefinition());
		borderColorZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		borderColorZoomDecoratorEClass.getESuperTypes().add(this.getBorderColorParameterDefinition());
		borderWidthAttributeTextDecoratorEClass.getESuperTypes().add(this.getAttributeTextDecorator());
		borderWidthAttributeTextDecoratorEClass.getESuperTypes().add(this.getBorderWidthParameterDefinition());
		borderWidthAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getAttributeIntervalDecorator());
		borderWidthAttributeIntervalDecoratorEClass.getESuperTypes().add(this.getBorderWidthParameterDefinition());
		borderWidthZoomDecoratorEClass.getESuperTypes().add(this.getZoomDecorator());
		borderWidthZoomDecoratorEClass.getESuperTypes().add(this.getBorderWidthParameterDefinition());

		// Initialize classes and features; add operations and parameters
		initEClass(visibleFormEClass, VisibleForm.class, "VisibleForm", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVisibleForm_EditorDoTyp(), this.getEditorDoTyp(), this.getEditorDoTyp_Formen(), "editorDoTyp",
				null, 1, 1, VisibleForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getVisibleForm_Visible(), ecorePackage.getEBoolean(), "visible", "true", 0, 1, VisibleForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getVisibleForm_Decorators(), this.getDecorator(), null, "decorators", null, 0, -1,
				VisibleForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rotatableFormEClass, RotatableForm.class, "RotatableForm", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRotatableForm_Angle(), ecorePackage.getEDouble(), "angle", null, 0, 1, RotatableForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(borderedFormEClass, BorderedForm.class, "BorderedForm", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBorderedForm_BorderWidth(), ecorePackage.getEInt(), "borderWidth", "0", 0, 1,
				BorderedForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getBorderedForm_BorderColor(), theEclipsePackage.getEColor(), null, "borderColor", null, 0, 1,
				BorderedForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(zoomableFormEClass, ZoomableForm.class, "ZoomableForm", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getZoomableForm_ZoomVerhalten(), this.getZoomVerhalten(), "zoomVerhalten", null, 0, 1,
				ZoomableForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(punktFormEClass, PunktForm.class, "PunktForm", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPunktForm_Positionierung(), this.getPositionierung(), "positionierung", null, 0, 1,
				PunktForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getPunktForm_Bounds(), theGefPackage.getRectangle(), "bounds", null, 0, 1, PunktForm.class,
				IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPunktForm_ForegroundColor(), theEclipsePackage.getEColor(), null, "foregroundColor", null, 0,
				1, PunktForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(bildFormEClass, BildForm.class, "BildForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBildForm_Bild(), theDavbitctrlPackage.getBild(), "bild", null, 0, 1, BildForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(textFormEClass, TextForm.class, "TextForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTextForm_Text(), ecorePackage.getEString(), "text", "Text", 0, 1, TextForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTextForm_HorizontalAlignment(), theEclipsePackage.getHorizontalAlignment(),
				"horizontalAlignment", null, 0, 1, TextForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTextForm_VerticalAlignment(), theEclipsePackage.getVerticalAlignment(), "verticalAlignment",
				null, 0, 1, TextForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTextForm_Font(), theEclipsePackage.getEFont(), null, "font", null, 0, 1, TextForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(polylineFormEClass, PolylineForm.class, "PolylineForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPolylineForm_Points(), theGefPackage.getPointList(), "points", null, 0, 1, PolylineForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(polygonFormEClass, PolygonForm.class, "PolygonForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(flaechenFormEClass, FlaechenForm.class, "FlaechenForm", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFlaechenForm_BackgroundPattern(), theDavbitctrlPackage.getPortableBitmap(),
				"backgroundPattern", null, 0, 1, FlaechenForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFlaechenForm_Filled(), ecorePackage.getEBoolean(), "filled", "true", 0, 1, FlaechenForm.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFlaechenForm_BackgroundColor(), theEclipsePackage.getEColor(), null, "backgroundColor", null,
				0, 1, FlaechenForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ellipseFormEClass, EllipseForm.class, "EllipseForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(rechteckFormEClass, RechteckForm.class, "RechteckForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(linienFormEClass, LinienForm.class, "LinienForm", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLinienForm_LineAttributes(), theEclipsePackage.getELineAttributes(), null, "lineAttributes",
				null, 0, 1, LinienForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(decoratorEClass, Decorator.class, "Decorator", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(textDecoratorEClass, TextDecorator.class, "TextDecorator", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTextDecorator_Text(), ecorePackage.getEString(), "text", "", 0, 1, TextDecorator.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(attributeDecoratorEClass, AttributeDecorator.class, "AttributeDecorator", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAttributeDecorator_AttributGruppe(), theDavPackage.getAttributeGroup(), "attributGruppe",
				null, 0, 1, AttributeDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeDecorator_Aspekt(), theDavPackage.getAspect(), "aspekt", null, 0, 1,
				AttributeDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributeDecorator_AttributPfad(), ecorePackage.getEString(), "attributPfad", "", 0, 1,
				AttributeDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(intervalDecoratorEClass, IntervalDecorator.class, "IntervalDecorator", IS_ABSTRACT, IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getIntervalDecorator_Start(), ecorePackage.getEDouble(), "start", null, 0, 1,
				IntervalDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getIntervalDecorator_End(), ecorePackage.getEDouble(), "end", null, 0, 1,
				IntervalDecorator.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(zoomDecoratorEClass, ZoomDecorator.class, "ZoomDecorator", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(editorDoModelEClass, EditorDoModel.class, "EditorDoModel", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);

		initEClass(attributeTextDecoratorEClass, AttributeTextDecorator.class, "AttributeTextDecorator", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(attributeIntervalDecoratorEClass, AttributeIntervalDecorator.class, "AttributeIntervalDecorator",
				IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(backgroundAttributeIntervalDecoratorEClass, BackgroundAttributeIntervalDecorator.class,
				"BackgroundAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(parameterDefinitionEClass, ParameterDefinition.class, "ParameterDefinition", IS_ABSTRACT,
				IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(colorParameterDefinitionEClass, ColorParameterDefinition.class, "ColorParameterDefinition",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getColorParameterDefinition_StartColor(), theEclipsePackage.getEColor(), null, "startColor",
				null, 0, 1, ColorParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getColorParameterDefinition_EndColor(), theEclipsePackage.getEColor(), null, "endColor", null, 0,
				1, ColorParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(backgroundParameterDefinitionEClass, BackgroundParameterDefinition.class,
				"BackgroundParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(foregroundParameterDefinitionEClass, ForegroundParameterDefinition.class,
				"ForegroundParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(borderColorParameterDefinitionEClass, BorderColorParameterDefinition.class,
				"BorderColorParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(fontDataParameterDefinitionEClass, FontDataParameterDefinition.class, "FontDataParameterDefinition",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFontDataParameterDefinition_Font(), theEclipsePackage.getEFont(), null, "font", null, 0, 1,
				FontDataParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(drehwinkelParameterDefinitionEClass, DrehwinkelParameterDefinition.class,
				"DrehwinkelParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDrehwinkelParameterDefinition_StartWinkel(), ecorePackage.getEFloat(), "startWinkel", null, 0,
				1, DrehwinkelParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDrehwinkelParameterDefinition_EndWinkel(), ecorePackage.getEFloatObject(), "endWinkel", null,
				0, 1, DrehwinkelParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(lineAttributeParameterDefinitionEClass, LineAttributeParameterDefinition.class,
				"LineAttributeParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getLineAttributeParameterDefinition_LineAttributes(), theEclipsePackage.getELineAttributes(),
				null, "lineAttributes", null, 0, 1, LineAttributeParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stringParameterDefinitionEClass, StringParameterDefinition.class, "StringParameterDefinition",
				IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStringParameterDefinition_String(), ecorePackage.getEString(), "string", null, 0, 1,
				StringParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sichtbarkeitParameterDefinitionEClass, SichtbarkeitParameterDefinition.class,
				"SichtbarkeitParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSichtbarkeitParameterDefinition_Sichtbar(), ecorePackage.getEBoolean(), "sichtbar", null, 0,
				1, SichtbarkeitParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(zoomVerhaltenParameterDefinitionEClass, ZoomVerhaltenParameterDefinition.class,
				"ZoomVerhaltenParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getZoomVerhaltenParameterDefinition_ZoomVerhalten(), this.getZoomVerhalten(), "zoomVerhalten",
				null, 0, 1, ZoomVerhaltenParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				!IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(backgroundAttributeTextDecoratorEClass, BackgroundAttributeTextDecorator.class,
				"BackgroundAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(backgroundZoomDecoratorEClass, BackgroundZoomDecorator.class, "BackgroundZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(drehwinkelAttributeTextDecoratorEClass, DrehwinkelAttributeTextDecorator.class,
				"DrehwinkelAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(drehwinkelAttributeIntervalDecoratorEClass, DrehwinkelAttributeIntervalDecorator.class,
				"DrehwinkelAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(drehwinkelZoomDecoratorEClass, DrehwinkelZoomDecorator.class, "DrehwinkelZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(fontDataAttributeIntervalDecoratorEClass, FontDataAttributeIntervalDecorator.class,
				"FontDataAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(fontDataAttributeTextDecoratorEClass, FontDataAttributeTextDecorator.class,
				"FontDataAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(fontDataZoomDecoratorEClass, FontDataZoomDecorator.class, "FontDataZoomDecorator", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(foregroundAttributeTextDecoratorEClass, ForegroundAttributeTextDecorator.class,
				"ForegroundAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(foregroundAttributeIntervalDecoratorEClass, ForegroundAttributeIntervalDecorator.class,
				"ForegroundAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(foregroundZoomDecoratorEClass, ForegroundZoomDecorator.class, "ForegroundZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lineAttributeAttributeIntervalDecoratorEClass, LineAttributeAttributeIntervalDecorator.class,
				"LineAttributeAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lineAttributeAttributeTextDecoratorEClass, LineAttributeAttributeTextDecorator.class,
				"LineAttributeAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(lineAttributeZoomDecoratorEClass, LineAttributeZoomDecorator.class, "LineAttributeZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sichtbarkeitAttributeTextDecoratorEClass, SichtbarkeitAttributeTextDecorator.class,
				"SichtbarkeitAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sichtbarkeitAttributeIntervalDecoratorEClass, SichtbarkeitAttributeIntervalDecorator.class,
				"SichtbarkeitAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sichtbarkeitZoomDecoratorEClass, SichtbarkeitZoomDecorator.class, "SichtbarkeitZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(stringAttributeIntervalDecoratorEClass, StringAttributeIntervalDecorator.class,
				"StringAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(stringAttributeTextDecoratorEClass, StringAttributeTextDecorator.class,
				"StringAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(stringZoomDecoratorEClass, StringZoomDecorator.class, "StringZoomDecorator", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(zoomVerhaltenAttributeIntervalDecoratorEClass, ZoomVerhaltenAttributeIntervalDecorator.class,
				"ZoomVerhaltenAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(zoomVerhaltenAttributeTextDecoratorEClass, ZoomVerhaltenAttributeTextDecorator.class,
				"ZoomVerhaltenAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(zoomVerhaltenZoomDecoratorEClass, ZoomVerhaltenZoomDecorator.class, "ZoomVerhaltenZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(embeddedDoFormEClass, EmbeddedDoForm.class, "EmbeddedDoForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEmbeddedDoForm_DarstellungsObjektTyp(), this.getEditorDoTypReferenz(), null,
				"darstellungsObjektTyp", null, 0, 1, EmbeddedDoForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(externalDoFormEClass, ExternalDoForm.class, "ExternalDoForm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getExternalDoForm_DarstellungsObjektTyp(), theDobjPackage.getDoTyp(), null,
				"darstellungsObjektTyp", null, 0, 1, ExternalDoForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE,
				IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getExternalDoForm_ExtensionPointID(), ecorePackage.getEString(), "extensionPointID", null, 0, 1,
				ExternalDoForm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(doEditorDiagrammEClass, DoEditorDiagramm.class, "DoEditorDiagramm", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDoEditorDiagramm_DoTyp(), this.getEditorDoTyp(), null, "doTyp", null, 0, 1,
				DoEditorDiagramm.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(editorDoTypEClass, EditorDoTyp.class, "EditorDoTyp", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEditorDoTyp_SystemObjekt(), theDavbitctrlPackage.getSystemObjekt(), "systemObjekt", null, 0,
				1, EditorDoTyp.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getEditorDoTyp_SystemObjectType(), theDavPackage.getSystemObjectType(), "systemObjectType", null,
				0, 1, EditorDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getEditorDoTyp_Hotspot(), theGefPackage.getPoint(), "hotspot", "Point(0,0)", 0, 1,
				EditorDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getEditorDoTyp_AnLinieAusrichten(), ecorePackage.getEBoolean(), "anLinieAusrichten", null, 0, 1,
				EditorDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getEditorDoTyp_Formen(), this.getVisibleForm(), this.getVisibleForm_EditorDoTyp(), "formen",
				null, 0, -1, EditorDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE,
				!IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEditorDoTyp_DoTypPid(), ecorePackage.getEString(), "doTypPid", null, 0, 1, EditorDoTyp.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEditorDoTyp_LastUsedLevelId(), ecorePackage.getELong(), "lastUsedLevelId", "0", 0, 1,
				EditorDoTyp.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		initEClass(editorDoTypReferenzEClass, EditorDoTypReferenz.class, "EditorDoTypReferenz", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEditorDoTypReferenz_SystemObjekt(), theDavbitctrlPackage.getSystemObjekt(), "systemObjekt",
				null, 1, 1, EditorDoTypReferenz.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEditorDoTypReferenz_Wrapped(), this.getEditorDoTyp(), null, "wrapped", null, 0, 1,
				EditorDoTypReferenz.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(borderWidthParameterDefinitionEClass, BorderWidthParameterDefinition.class,
				"BorderWidthParameterDefinition", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBorderWidthParameterDefinition_StartWert(), ecorePackage.getEFloat(), "startWert", null, 0, 1,
				BorderWidthParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getBorderWidthParameterDefinition_EndWert(), ecorePackage.getEFloatObject(), "endWert", null, 0,
				1, BorderWidthParameterDefinition.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(borderColorAttributeTextDecoratorEClass, BorderColorAttributeTextDecorator.class,
				"BorderColorAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(borderColorAttributeIntervalDecoratorEClass, BorderColorAttributeIntervalDecorator.class,
				"BorderColorAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(borderColorZoomDecoratorEClass, BorderColorZoomDecorator.class, "BorderColorZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(borderWidthAttributeTextDecoratorEClass, BorderWidthAttributeTextDecorator.class,
				"BorderWidthAttributeTextDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(borderWidthAttributeIntervalDecoratorEClass, BorderWidthAttributeIntervalDecorator.class,
				"BorderWidthAttributeIntervalDecorator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(borderWidthZoomDecoratorEClass, BorderWidthZoomDecorator.class, "BorderWidthZoomDecorator",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(identidyEClass, Identidy.class, "Identidy", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getIdentidy_Id(), ecorePackage.getELong(), "id", "0", 0, 1, Identidy.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(zoomVerhaltenEEnum, ZoomVerhalten.class, "ZoomVerhalten");
		addEEnumLiteral(zoomVerhaltenEEnum, ZoomVerhalten.DYNAMISCH);
		addEEnumLiteral(zoomVerhaltenEEnum, ZoomVerhalten.FIX);
		addEEnumLiteral(zoomVerhaltenEEnum, ZoomVerhalten.HORIZONTAL);
		addEEnumLiteral(zoomVerhaltenEEnum, ZoomVerhalten.VERTIKAL);

		initEEnum(positionierungEEnum, Positionierung.class, "Positionierung");
		addEEnumLiteral(positionierungEEnum, Positionierung.LINKS_OBEN);
		addEEnumLiteral(positionierungEEnum, Positionierung.ZENTRIERT);

		// Create resource
		createResource(eNS_URI);
	}

} // DoeditorPackageImpl
