/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model.impl;

import java.util.Collection;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import com.bitctrl.lib.eclipse.emf.eclipse.model.impl.NamedImpl;
import com.bitctrl.lib.eclipse.emf.gef.model.GefFactory;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.buv.plugin.doeditor.model.Identidy;
import de.bsvrz.buv.plugin.doeditor.model.VisibleForm;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Editor Do Typ</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getSize <em>Size</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getSystemObjekt <em>System Objekt</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getSystemObjectType <em>System Object Type</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getHotspot <em>Hotspot</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#isAnLinieAusrichten <em>An Linie Ausrichten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getFormen <em>Formen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getDoTypPid <em>Do Typ Pid</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.EditorDoTypImpl#getLastUsedLevelId <em>Last Used Level Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EditorDoTypImpl extends NamedImpl implements EditorDoTyp {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final Point LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Point location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final Dimension SIZE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Dimension size = SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSystemObjekt() <em>System Objekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjekt()
	 * @generated
	 * @ordered
	 */
	protected static final SystemObjekt SYSTEM_OBJEKT_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getSystemObjectType() <em>System Object Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjectType()
	 * @generated
	 * @ordered
	 */
	protected static final SystemObjectType SYSTEM_OBJECT_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSystemObjectType() <em>System Object Type</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjectType()
	 * @generated
	 * @ordered
	 */
	protected SystemObjectType systemObjectType = SYSTEM_OBJECT_TYPE_EDEFAULT;

	/**
	 * @generated NOT
	 */
	private SystemObjekt systemObjekt = null;

	/**
	 * The default value of the '{@link #getHotspot() <em>Hotspot</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getHotspot()
	 * @generated
	 * @ordered
	 */
	protected static final Point HOTSPOT_EDEFAULT = (Point) GefFactory.eINSTANCE
			.createFromString(GefPackage.eINSTANCE.getPoint(), "Point(0,0)");

	/**
	 * The cached value of the '{@link #getHotspot() <em>Hotspot</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getHotspot()
	 * @generated
	 * @ordered
	 */
	protected Point hotspot = HOTSPOT_EDEFAULT;

	/**
	 * The default value of the '{@link #isAnLinieAusrichten() <em>An Linie Ausrichten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isAnLinieAusrichten()
	 * @generated
	 * @ordered
	 */
	protected static final boolean AN_LINIE_AUSRICHTEN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAnLinieAusrichten() <em>An Linie Ausrichten</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isAnLinieAusrichten()
	 * @generated
	 * @ordered
	 */
	protected boolean anLinieAusrichten = AN_LINIE_AUSRICHTEN_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFormen() <em>Formen</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFormen()
	 * @generated
	 * @ordered
	 */
	protected EList<VisibleForm> formen;

	/**
	 * The default value of the '{@link #getDoTypPid() <em>Do Typ Pid</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoTypPid()
	 * @generated
	 * @ordered
	 */
	protected static final String DO_TYP_PID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDoTypPid() <em>Do Typ Pid</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoTypPid()
	 * @generated
	 * @ordered
	 */
	protected String doTypPid = DO_TYP_PID_EDEFAULT;

	/**
	 * The default value of the '{@link #getLastUsedLevelId() <em>Last Used Level Id</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getLastUsedLevelId()
	 * @generated
	 * @ordered
	 */
	protected static final long LAST_USED_LEVEL_ID_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getLastUsedLevelId() <em>Last Used Level Id</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getLastUsedLevelId()
	 * @generated
	 * @ordered
	 */
	protected long lastUsedLevelId = LAST_USED_LEVEL_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EditorDoTypImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_TYP__LOCATION:
				return GefPackage.LOCATED__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == Sized.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.EDITOR_DO_TYP__SIZE:
				return GefPackage.SIZED__SIZE;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Located.class) {
			switch (baseFeatureID) {
			case GefPackage.LOCATED__LOCATION:
				return DoeditorPackage.EDITOR_DO_TYP__LOCATION;
			default:
				return -1;
			}
		}
		if (baseClass == Sized.class) {
			switch (baseFeatureID) {
			case GefPackage.SIZED__SIZE:
				return DoeditorPackage.EDITOR_DO_TYP__SIZE;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP__LOCATION:
			return getLocation();
		case DoeditorPackage.EDITOR_DO_TYP__SIZE:
			return getSize();
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJEKT:
			return getSystemObjekt();
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE:
			return getSystemObjectType();
		case DoeditorPackage.EDITOR_DO_TYP__HOTSPOT:
			return getHotspot();
		case DoeditorPackage.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN:
			return isAnLinieAusrichten();
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			return getFormen();
		case DoeditorPackage.EDITOR_DO_TYP__DO_TYP_PID:
			return getDoTypPid();
		case DoeditorPackage.EDITOR_DO_TYP__LAST_USED_LEVEL_ID:
			return getLastUsedLevelId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getFormen()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			return ((InternalEList<?>) getFormen()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP__LOCATION:
			return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
		case DoeditorPackage.EDITOR_DO_TYP__SIZE:
			return SIZE_EDEFAULT == null ? size != null : !SIZE_EDEFAULT.equals(size);
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJEKT:
			return SYSTEM_OBJEKT_EDEFAULT == null ? getSystemObjekt() != null
					: !SYSTEM_OBJEKT_EDEFAULT.equals(getSystemObjekt());
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE:
			return SYSTEM_OBJECT_TYPE_EDEFAULT == null ? systemObjectType != null
					: !SYSTEM_OBJECT_TYPE_EDEFAULT.equals(systemObjectType);
		case DoeditorPackage.EDITOR_DO_TYP__HOTSPOT:
			return HOTSPOT_EDEFAULT == null ? hotspot != null : !HOTSPOT_EDEFAULT.equals(hotspot);
		case DoeditorPackage.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN:
			return anLinieAusrichten != AN_LINIE_AUSRICHTEN_EDEFAULT;
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			return formen != null && !formen.isEmpty();
		case DoeditorPackage.EDITOR_DO_TYP__DO_TYP_PID:
			return DO_TYP_PID_EDEFAULT == null ? doTypPid != null : !DO_TYP_PID_EDEFAULT.equals(doTypPid);
		case DoeditorPackage.EDITOR_DO_TYP__LAST_USED_LEVEL_ID:
			return lastUsedLevelId != LAST_USED_LEVEL_ID_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP__LOCATION:
			setLocation((Point) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__SIZE:
			setSize((Dimension) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJEKT:
			setSystemObjekt((SystemObjekt) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE:
			setSystemObjectType((SystemObjectType) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__HOTSPOT:
			setHotspot((Point) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN:
			setAnLinieAusrichten((Boolean) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			getFormen().clear();
			getFormen().addAll((Collection<? extends VisibleForm>) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__DO_TYP_PID:
			setDoTypPid((String) newValue);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__LAST_USED_LEVEL_ID:
			setLastUsedLevelId((Long) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.EDITOR_DO_TYP;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.EDITOR_DO_TYP__LOCATION:
			setLocation(LOCATION_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__SIZE:
			setSize(SIZE_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJEKT:
			setSystemObjekt(SYSTEM_OBJEKT_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE:
			setSystemObjectType(SYSTEM_OBJECT_TYPE_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__HOTSPOT:
			setHotspot(HOTSPOT_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN:
			setAnLinieAusrichten(AN_LINIE_AUSRICHTEN_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			getFormen().clear();
			return;
		case DoeditorPackage.EDITOR_DO_TYP__DO_TYP_PID:
			setDoTypPid(DO_TYP_PID_EDEFAULT);
			return;
		case DoeditorPackage.EDITOR_DO_TYP__LAST_USED_LEVEL_ID:
			setLastUsedLevelId(LAST_USED_LEVEL_ID_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDoTypPid() {
		return doTypPid;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public EList<VisibleForm> getFormen() {
		if (formen == null) {
			formen = new EObjectContainmentWithInverseEList<VisibleForm>(VisibleForm.class, this,
					DoeditorPackage.EDITOR_DO_TYP__FORMEN, DoeditorPackage.VISIBLE_FORM__EDITOR_DO_TYP);
		}
		for (final VisibleForm form : formen) {
			if (form instanceof Identidy) {
				if (((Identidy) form).getId() == 0) {
					((Identidy) form).setId(++lastUsedLevelId);
				}
			}
		}
		return formen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point getHotspot() {
		return hotspot;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Dimension getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SystemObjectType getSystemObjectType() {
		return systemObjectType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public SystemObjekt getSystemObjekt() {
		if (systemObjekt == null) {
			final String pid = getDoTypPid();
			if (pid != null) {
				systemObjekt = RahmenwerkService.getService().getObjektFactory().getModellobjekt(pid);
			}
		}
		return systemObjekt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAnLinieAusrichten() {
		return anLinieAusrichten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAnLinieAusrichten(boolean newAnLinieAusrichten) {
		boolean oldAnLinieAusrichten = anLinieAusrichten;
		anLinieAusrichten = newAnLinieAusrichten;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN,
					oldAnLinieAusrichten, anLinieAusrichten));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setDoTypPid(final String newDoTypPid) {
		final String oldDoTypPid = doTypPid;
		doTypPid = newDoTypPid;
		if (systemObjekt == null || !systemObjekt.getPid().equals(doTypPid)) {
			getSystemObjekt();
		}
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__DO_TYP_PID,
					oldDoTypPid, doTypPid));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public long getLastUsedLevelId() {
		return lastUsedLevelId;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLastUsedLevelId(long newLastUsedLevelId) {
		long oldLastUsedLevelId = lastUsedLevelId;
		lastUsedLevelId = newLastUsedLevelId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__LAST_USED_LEVEL_ID,
					oldLastUsedLevelId, lastUsedLevelId));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHotspot(Point newHotspot) {
		Point oldHotspot = hotspot;
		hotspot = newHotspot;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__HOTSPOT, oldHotspot,
					hotspot));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLocation(Point newLocation) {
		Point oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__LOCATION, oldLocation,
					location));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSize(Dimension newSize) {
		Dimension oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSystemObjectType(SystemObjectType newSystemObjectType) {
		SystemObjectType oldSystemObjectType = systemObjectType;
		systemObjectType = newSystemObjectType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE,
					oldSystemObjectType, systemObjectType));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setSystemObjekt(final SystemObjekt newSystemObjekt) {
		systemObjekt = newSystemObjekt;
		if (systemObjekt != null) {
			setDoTypPid(newSystemObjekt.getPid());
		} else {
			setDoTypPid(null);
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", size: ");
		result.append(size);
		result.append(", systemObjectType: ");
		result.append(systemObjectType);
		result.append(", hotspot: ");
		result.append(hotspot);
		result.append(", anLinieAusrichten: ");
		result.append(anLinieAusrichten);
		result.append(", doTypPid: ");
		result.append(doTypPid);
		result.append(", lastUsedLevelId: ");
		result.append(lastUsedLevelId);
		result.append(')');
		return result.toString();
	}

} // EditorDoTypImpl
