/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;

import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator;
import de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Foreground Zoom Decorator</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl#getStartColor <em>Start Color</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl#getEndColor <em>End Color</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl#getStart <em>Start</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.ForegroundZoomDecoratorImpl#getEnd <em>End</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ForegroundZoomDecoratorImpl extends EObjectImpl implements ForegroundZoomDecorator {
	/**
	 * The cached value of the '{@link #getStartColor() <em>Start Color</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStartColor()
	 * @generated
	 * @ordered
	 */
	protected EColor startColor;

	/**
	 * The cached value of the '{@link #getEndColor() <em>End Color</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getEndColor()
	 * @generated
	 * @ordered
	 */
	protected EColor endColor;

	/**
	 * The default value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected static final double START_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected double start = START_EDEFAULT;

	/**
	 * The default value of the '{@link #getEnd() <em>End</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected static final double END_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEnd() <em>End</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected double end = END_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ForegroundZoomDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.FOREGROUND_ZOOM_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EColor getStartColor() {
		return startColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStartColor(EColor newStartColor, NotificationChain msgs) {
		EColor oldStartColor = startColor;
		startColor = newStartColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR, oldStartColor, newStartColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartColor(EColor newStartColor) {
		if (newStartColor != startColor) {
			NotificationChain msgs = null;
			if (startColor != null)
				msgs = ((InternalEObject) startColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR, null, msgs);
			if (newStartColor != null)
				msgs = ((InternalEObject) newStartColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR, null, msgs);
			msgs = basicSetStartColor(newStartColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR, newStartColor, newStartColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EColor getEndColor() {
		return endColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetEndColor(EColor newEndColor, NotificationChain msgs) {
		EColor oldEndColor = endColor;
		endColor = newEndColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR, oldEndColor, newEndColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndColor(EColor newEndColor) {
		if (newEndColor != endColor) {
			NotificationChain msgs = null;
			if (endColor != null)
				msgs = ((InternalEObject) endColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR, null, msgs);
			if (newEndColor != null)
				msgs = ((InternalEObject) newEndColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR, null, msgs);
			msgs = basicSetEndColor(newEndColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR,
					newEndColor, newEndColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getStart() {
		return start;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStart(double newStart) {
		double oldStart = start;
		start = newStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START,
					oldStart, start));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getEnd() {
		return end;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEnd(double newEnd) {
		double oldEnd = end;
		end = newEnd;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END,
					oldEnd, end));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR:
			return basicSetStartColor(null, msgs);
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR:
			return basicSetEndColor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR:
			return getStartColor();
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR:
			return getEndColor();
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START:
			return getStart();
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END:
			return getEnd();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR:
			setStartColor((EColor) newValue);
			return;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR:
			setEndColor((EColor) newValue);
			return;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START:
			setStart((Double) newValue);
			return;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END:
			setEnd((Double) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR:
			setStartColor((EColor) null);
			return;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR:
			setEndColor((EColor) null);
			return;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START:
			setStart(START_EDEFAULT);
			return;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END:
			setEnd(END_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START_COLOR:
			return startColor != null;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END_COLOR:
			return endColor != null;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START:
			return start != START_EDEFAULT;
		case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END:
			return end != END_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Decorator.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == IntervalDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START:
				return DoeditorPackage.INTERVAL_DECORATOR__START;
			case DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END:
				return DoeditorPackage.INTERVAL_DECORATOR__END;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomDecorator.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Decorator.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == IntervalDecorator.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.INTERVAL_DECORATOR__START:
				return DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__START;
			case DoeditorPackage.INTERVAL_DECORATOR__END:
				return DoeditorPackage.FOREGROUND_ZOOM_DECORATOR__END;
			default:
				return -1;
			}
		}
		if (baseClass == ZoomDecorator.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (start: ");
		result.append(start);
		result.append(", end: ");
		result.append(end);
		result.append(')');
		return result.toString();
	}

} // ForegroundZoomDecoratorImpl
