/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.ELineAttributes;

import de.bsvrz.buv.plugin.doeditor.model.AttributeDecorator;
import de.bsvrz.buv.plugin.doeditor.model.AttributeIntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.Decorator;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.IntervalDecorator;
import de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Line Attribute Attribute Interval Decorator</b></em>'. <!--
 * end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl#getLineAttributes <em>Line Attributes</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl#getStart <em>Start</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl#getEnd <em>End</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl#getAttributGruppe <em>Attribut Gruppe</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl#getAspekt <em>Aspekt</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.LineAttributeAttributeIntervalDecoratorImpl#getAttributPfad <em>Attribut Pfad</em>}</li>
 * </ul>
 *
 * @generated
 */
public class LineAttributeAttributeIntervalDecoratorImpl extends EObjectImpl
		implements LineAttributeAttributeIntervalDecorator {
	/**
	 * The cached value of the '{@link #getLineAttributes() <em>Line Attributes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineAttributes()
	 * @generated
	 * @ordered
	 */
	protected ELineAttributes lineAttributes;

	/**
	 * The default value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected static final double START_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getStart() <em>Start</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getStart()
	 * @generated
	 * @ordered
	 */
	protected double start = START_EDEFAULT;

	/**
	 * The default value of the '{@link #getEnd() <em>End</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected static final double END_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEnd() <em>End</em>}' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getEnd()
	 * @generated
	 * @ordered
	 */
	protected double end = END_EDEFAULT;

	/**
	 * The default value of the '{@link #getAttributGruppe() <em>Attribut Gruppe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributGruppe()
	 * @generated
	 * @ordered
	 */
	protected static final AttributeGroup ATTRIBUT_GRUPPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAttributGruppe() <em>Attribut Gruppe</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributGruppe()
	 * @generated
	 * @ordered
	 */
	protected AttributeGroup attributGruppe = ATTRIBUT_GRUPPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAspekt() <em>Aspekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAspekt()
	 * @generated
	 * @ordered
	 */
	protected static final Aspect ASPEKT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAspekt() <em>Aspekt</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAspekt()
	 * @generated
	 * @ordered
	 */
	protected Aspect aspekt = ASPEKT_EDEFAULT;

	/**
	 * The default value of the '{@link #getAttributPfad() <em>Attribut Pfad</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributPfad()
	 * @generated
	 * @ordered
	 */
	protected static final String ATTRIBUT_PFAD_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getAttributPfad() <em>Attribut Pfad</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getAttributPfad()
	 * @generated
	 * @ordered
	 */
	protected String attributPfad = ATTRIBUT_PFAD_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected LineAttributeAttributeIntervalDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ELineAttributes getLineAttributes() {
		return lineAttributes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLineAttributes(ELineAttributes newLineAttributes, NotificationChain msgs) {
		ELineAttributes oldLineAttributes = lineAttributes;
		lineAttributes = newLineAttributes;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES, oldLineAttributes,
					newLineAttributes);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineAttributes(ELineAttributes newLineAttributes) {
		if (newLineAttributes != lineAttributes) {
			NotificationChain msgs = null;
			if (lineAttributes != null)
				msgs = ((InternalEObject) lineAttributes).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE
								- DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES,
						null, msgs);
			if (newLineAttributes != null)
				msgs = ((InternalEObject) newLineAttributes).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE
								- DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES,
						null, msgs);
			msgs = basicSetLineAttributes(newLineAttributes, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES, newLineAttributes,
					newLineAttributes));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getStart() {
		return start;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStart(double newStart) {
		double oldStart = start;
		start = newStart;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START, oldStart, start));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getEnd() {
		return end;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEnd(double newEnd) {
		double oldEnd = end;
		end = newEnd;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END, oldEnd, end));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AttributeGroup getAttributGruppe() {
		return attributGruppe;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAttributGruppe(AttributeGroup newAttributGruppe) {
		AttributeGroup oldAttributGruppe = attributGruppe;
		attributGruppe = newAttributGruppe;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE, oldAttributGruppe,
					attributGruppe));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Aspect getAspekt() {
		return aspekt;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAspekt(Aspect newAspekt) {
		Aspect oldAspekt = aspekt;
		aspekt = newAspekt;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT, oldAspekt, aspekt));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAttributPfad() {
		return attributPfad;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAttributPfad(String newAttributPfad) {
		String oldAttributPfad = attributPfad;
		attributPfad = newAttributPfad;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD, oldAttributPfad,
					attributPfad));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES:
			return basicSetLineAttributes(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES:
			return getLineAttributes();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START:
			return getStart();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END:
			return getEnd();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE:
			return getAttributGruppe();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT:
			return getAspekt();
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD:
			return getAttributPfad();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES:
			setLineAttributes((ELineAttributes) newValue);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START:
			setStart((Double) newValue);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END:
			setEnd((Double) newValue);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE:
			setAttributGruppe((AttributeGroup) newValue);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT:
			setAspekt((Aspect) newValue);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD:
			setAttributPfad((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES:
			setLineAttributes((ELineAttributes) null);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START:
			setStart(START_EDEFAULT);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END:
			setEnd(END_EDEFAULT);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE:
			setAttributGruppe(ATTRIBUT_GRUPPE_EDEFAULT);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT:
			setAspekt(ASPEKT_EDEFAULT);
			return;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD:
			setAttributPfad(ATTRIBUT_PFAD_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__LINE_ATTRIBUTES:
			return lineAttributes != null;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START:
			return start != START_EDEFAULT;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END:
			return end != END_EDEFAULT;
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE:
			return ATTRIBUT_GRUPPE_EDEFAULT == null ? attributGruppe != null
					: !ATTRIBUT_GRUPPE_EDEFAULT.equals(attributGruppe);
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT:
			return ASPEKT_EDEFAULT == null ? aspekt != null : !ASPEKT_EDEFAULT.equals(aspekt);
		case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD:
			return ATTRIBUT_PFAD_EDEFAULT == null ? attributPfad != null : !ATTRIBUT_PFAD_EDEFAULT.equals(attributPfad);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Decorator.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == IntervalDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START:
				return DoeditorPackage.INTERVAL_DECORATOR__START;
			case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END:
				return DoeditorPackage.INTERVAL_DECORATOR__END;
			default:
				return -1;
			}
		}
		if (baseClass == AttributeDecorator.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE:
				return DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE;
			case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT:
				return DoeditorPackage.ATTRIBUTE_DECORATOR__ASPEKT;
			case DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD:
				return DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD;
			default:
				return -1;
			}
		}
		if (baseClass == AttributeIntervalDecorator.class) {
			switch (derivedFeatureID) {
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Decorator.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		if (baseClass == IntervalDecorator.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.INTERVAL_DECORATOR__START:
				return DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__START;
			case DoeditorPackage.INTERVAL_DECORATOR__END:
				return DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__END;
			default:
				return -1;
			}
		}
		if (baseClass == AttributeDecorator.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_GRUPPE:
				return DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_GRUPPE;
			case DoeditorPackage.ATTRIBUTE_DECORATOR__ASPEKT:
				return DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ASPEKT;
			case DoeditorPackage.ATTRIBUTE_DECORATOR__ATTRIBUT_PFAD:
				return DoeditorPackage.LINE_ATTRIBUTE_ATTRIBUTE_INTERVAL_DECORATOR__ATTRIBUT_PFAD;
			default:
				return -1;
			}
		}
		if (baseClass == AttributeIntervalDecorator.class) {
			switch (baseFeatureID) {
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (start: ");
		result.append(start);
		result.append(", end: ");
		result.append(end);
		result.append(", attributGruppe: ");
		result.append(attributGruppe);
		result.append(", aspekt: ");
		result.append(aspekt);
		result.append(", attributPfad: ");
		result.append(attributPfad);
		result.append(')');
		return result.toString();
	}

} // LineAttributeAttributeIntervalDecoratorImpl
