/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.FlaechenForm;
import de.bsvrz.buv.plugin.doeditor.model.PolygonForm;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Polygon Form</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl#getSize <em>Size</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl#getBackgroundPattern <em>Background Pattern</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl#isFilled <em>Filled</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.PolygonFormImpl#getBackgroundColor <em>Background Color</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PolygonFormImpl extends PolylineFormImpl implements PolygonForm {
	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final Dimension SIZE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Dimension size = SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getBackgroundPattern() <em>Background Pattern</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getBackgroundPattern()
	 * @generated
	 * @ordered
	 */
	protected static final PortableBitMap BACKGROUND_PATTERN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBackgroundPattern() <em>Background Pattern</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getBackgroundPattern()
	 * @generated
	 * @ordered
	 */
	protected PortableBitMap backgroundPattern = BACKGROUND_PATTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #isFilled() <em>Filled</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isFilled()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FILLED_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isFilled() <em>Filled</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #isFilled()
	 * @generated
	 * @ordered
	 */
	protected boolean filled = FILLED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getBackgroundColor() <em>Background Color</em>}' containment reference.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected EColor backgroundColor;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected PolygonFormImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBackgroundColor(EColor newBackgroundColor, NotificationChain msgs) {
		EColor oldBackgroundColor = backgroundColor;
		backgroundColor = newBackgroundColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR, oldBackgroundColor, newBackgroundColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Sized.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.POLYGON_FORM__SIZE:
				return GefPackage.SIZED__SIZE;
			default:
				return -1;
			}
		}
		if (baseClass == FlaechenForm.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN:
				return DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN;
			case DoeditorPackage.POLYGON_FORM__FILLED:
				return DoeditorPackage.FLAECHEN_FORM__FILLED;
			case DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR:
				return DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Sized.class) {
			switch (baseFeatureID) {
			case GefPackage.SIZED__SIZE:
				return DoeditorPackage.POLYGON_FORM__SIZE;
			default:
				return -1;
			}
		}
		if (baseClass == FlaechenForm.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN:
				return DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN;
			case DoeditorPackage.FLAECHEN_FORM__FILLED:
				return DoeditorPackage.POLYGON_FORM__FILLED;
			case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
				return DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.POLYGON_FORM__SIZE:
			return getSize();
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN:
			return getBackgroundPattern();
		case DoeditorPackage.POLYGON_FORM__FILLED:
			return isFilled();
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR:
			return getBackgroundColor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR:
			return basicSetBackgroundColor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.POLYGON_FORM__SIZE:
			return SIZE_EDEFAULT == null ? size != null : !SIZE_EDEFAULT.equals(size);
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN:
			return BACKGROUND_PATTERN_EDEFAULT == null ? backgroundPattern != null
					: !BACKGROUND_PATTERN_EDEFAULT.equals(backgroundPattern);
		case DoeditorPackage.POLYGON_FORM__FILLED:
			return filled != FILLED_EDEFAULT;
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR:
			return backgroundColor != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.POLYGON_FORM__SIZE:
			setSize((Dimension) newValue);
			return;
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN:
			setBackgroundPattern((PortableBitMap) newValue);
			return;
		case DoeditorPackage.POLYGON_FORM__FILLED:
			setFilled((Boolean) newValue);
			return;
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR:
			setBackgroundColor((EColor) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.POLYGON_FORM;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.POLYGON_FORM__SIZE:
			setSize(SIZE_EDEFAULT);
			return;
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN:
			setBackgroundPattern(BACKGROUND_PATTERN_EDEFAULT);
			return;
		case DoeditorPackage.POLYGON_FORM__FILLED:
			setFilled(FILLED_EDEFAULT);
			return;
		case DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR:
			setBackgroundColor((EColor) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EColor getBackgroundColor() {
		return backgroundColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PortableBitMap getBackgroundPattern() {
		return backgroundPattern;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public Dimension getSize() {
		return points.getBounds().getSize();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFilled() {
		return filled;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBackgroundColor(EColor newBackgroundColor) {
		if (newBackgroundColor != backgroundColor) {
			NotificationChain msgs = null;
			if (backgroundColor != null)
				msgs = ((InternalEObject) backgroundColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR, null, msgs);
			if (newBackgroundColor != null)
				msgs = ((InternalEObject) newBackgroundColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR, null, msgs);
			msgs = basicSetBackgroundColor(newBackgroundColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYGON_FORM__BACKGROUND_COLOR,
					newBackgroundColor, newBackgroundColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBackgroundPattern(PortableBitMap newBackgroundPattern) {
		PortableBitMap oldBackgroundPattern = backgroundPattern;
		backgroundPattern = newBackgroundPattern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYGON_FORM__BACKGROUND_PATTERN,
					oldBackgroundPattern, backgroundPattern));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFilled(boolean newFilled) {
		boolean oldFilled = filled;
		filled = newFilled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYGON_FORM__FILLED, oldFilled,
					filled));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setSize(final Dimension newSize) {
		// size ist readonly bzw. wird direkt über die Punkte ermittelt
		final Dimension oldSize = points.getBounds().getSize();
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.POLYGON_FORM__SIZE, oldSize, size));
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (size: ");
		result.append(size);
		result.append(", backgroundPattern: ");
		result.append(backgroundPattern);
		result.append(", filled: ");
		result.append(filled);
		result.append(')');
		return result.toString();
	}

} // PolygonFormImpl
