/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.impl;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EFont;
import com.bitctrl.lib.eclipse.emf.eclipse.model.HorizontalAlignment;
import com.bitctrl.lib.eclipse.emf.eclipse.model.VerticalAlignment;

import de.bsvrz.buv.plugin.doeditor.model.BorderedForm;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.TextForm;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Text Form</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl#getBorderWidth <em>Border Width</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl#getBorderColor <em>Border Color</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl#getText <em>Text</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl#getHorizontalAlignment <em>Horizontal Alignment</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl#getVerticalAlignment <em>Vertical Alignment</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.doeditor.model.impl.TextFormImpl#getFont <em>Font</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TextFormImpl extends FlaechenFormImpl implements TextForm {
	/**
	 * The default value of the '{@link #getBorderWidth() <em>Border Width</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBorderWidth()
	 * @generated
	 * @ordered
	 */
	protected static final int BORDER_WIDTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getBorderWidth() <em>Border Width</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBorderWidth()
	 * @generated
	 * @ordered
	 */
	protected int borderWidth = BORDER_WIDTH_EDEFAULT;

	/**
	 * The cached value of the '{@link #getBorderColor() <em>Border Color</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getBorderColor()
	 * @generated
	 * @ordered
	 */
	protected EColor borderColor;

	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = "Text";

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getHorizontalAlignment() <em>Horizontal Alignment</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getHorizontalAlignment()
	 * @generated
	 * @ordered
	 */
	protected static final HorizontalAlignment HORIZONTAL_ALIGNMENT_EDEFAULT = HorizontalAlignment.LEFT;

	/**
	 * The cached value of the '{@link #getHorizontalAlignment() <em>Horizontal Alignment</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getHorizontalAlignment()
	 * @generated
	 * @ordered
	 */
	protected HorizontalAlignment horizontalAlignment = HORIZONTAL_ALIGNMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #getVerticalAlignment() <em>Vertical Alignment</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getVerticalAlignment()
	 * @generated
	 * @ordered
	 */
	protected static final VerticalAlignment VERTICAL_ALIGNMENT_EDEFAULT = VerticalAlignment.TOP;

	/**
	 * The cached value of the '{@link #getVerticalAlignment() <em>Vertical Alignment</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getVerticalAlignment()
	 * @generated
	 * @ordered
	 */
	protected VerticalAlignment verticalAlignment = VERTICAL_ALIGNMENT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getFont() <em>Font</em>}' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getFont()
	 * @generated
	 * @ordered
	 */
	protected EFont font;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected TextFormImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFont(EFont newFont, NotificationChain msgs) {
		EFont oldFont = font;
		font = newFont;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.TEXT_FORM__FONT, oldFont, newFont);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DoeditorPackage.TEXT_FORM__BORDER_WIDTH:
			return getBorderWidth();
		case DoeditorPackage.TEXT_FORM__BORDER_COLOR:
			return getBorderColor();
		case DoeditorPackage.TEXT_FORM__TEXT:
			return getText();
		case DoeditorPackage.TEXT_FORM__HORIZONTAL_ALIGNMENT:
			return getHorizontalAlignment();
		case DoeditorPackage.TEXT_FORM__VERTICAL_ALIGNMENT:
			return getVerticalAlignment();
		case DoeditorPackage.TEXT_FORM__FONT:
			return getFont();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DoeditorPackage.TEXT_FORM__BORDER_COLOR:
			return basicSetBorderColor(null, msgs);
		case DoeditorPackage.TEXT_FORM__FONT:
			return basicSetFont(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DoeditorPackage.TEXT_FORM__BORDER_WIDTH:
			return borderWidth != BORDER_WIDTH_EDEFAULT;
		case DoeditorPackage.TEXT_FORM__BORDER_COLOR:
			return borderColor != null;
		case DoeditorPackage.TEXT_FORM__TEXT:
			return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
		case DoeditorPackage.TEXT_FORM__HORIZONTAL_ALIGNMENT:
			return horizontalAlignment != HORIZONTAL_ALIGNMENT_EDEFAULT;
		case DoeditorPackage.TEXT_FORM__VERTICAL_ALIGNMENT:
			return verticalAlignment != VERTICAL_ALIGNMENT_EDEFAULT;
		case DoeditorPackage.TEXT_FORM__FONT:
			return font != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == BorderedForm.class) {
			switch (derivedFeatureID) {
			case DoeditorPackage.TEXT_FORM__BORDER_WIDTH:
				return DoeditorPackage.BORDERED_FORM__BORDER_WIDTH;
			case DoeditorPackage.TEXT_FORM__BORDER_COLOR:
				return DoeditorPackage.BORDERED_FORM__BORDER_COLOR;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == BorderedForm.class) {
			switch (baseFeatureID) {
			case DoeditorPackage.BORDERED_FORM__BORDER_WIDTH:
				return DoeditorPackage.TEXT_FORM__BORDER_WIDTH;
			case DoeditorPackage.BORDERED_FORM__BORDER_COLOR:
				return DoeditorPackage.TEXT_FORM__BORDER_COLOR;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DoeditorPackage.TEXT_FORM__BORDER_WIDTH:
			setBorderWidth((Integer) newValue);
			return;
		case DoeditorPackage.TEXT_FORM__BORDER_COLOR:
			setBorderColor((EColor) newValue);
			return;
		case DoeditorPackage.TEXT_FORM__TEXT:
			setText((String) newValue);
			return;
		case DoeditorPackage.TEXT_FORM__HORIZONTAL_ALIGNMENT:
			setHorizontalAlignment((HorizontalAlignment) newValue);
			return;
		case DoeditorPackage.TEXT_FORM__VERTICAL_ALIGNMENT:
			setVerticalAlignment((VerticalAlignment) newValue);
			return;
		case DoeditorPackage.TEXT_FORM__FONT:
			setFont((EFont) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DoeditorPackage.Literals.TEXT_FORM;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public int getBorderWidth() {
		return borderWidth;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setBorderWidth(int newBorderWidth) {
		int oldBorderWidth = borderWidth;
		borderWidth = newBorderWidth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.TEXT_FORM__BORDER_WIDTH,
					oldBorderWidth, borderWidth));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EColor getBorderColor() {
		return borderColor;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBorderColor(EColor newBorderColor, NotificationChain msgs) {
		EColor oldBorderColor = borderColor;
		borderColor = newBorderColor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET,
					DoeditorPackage.TEXT_FORM__BORDER_COLOR, oldBorderColor, newBorderColor);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void setBorderColor(EColor newBorderColor) {
		if (newBorderColor != borderColor) {
			NotificationChain msgs = null;
			if (borderColor != null)
				msgs = ((InternalEObject) borderColor).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.TEXT_FORM__BORDER_COLOR, null, msgs);
			if (newBorderColor != null)
				msgs = ((InternalEObject) newBorderColor).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.TEXT_FORM__BORDER_COLOR, null, msgs);
			msgs = basicSetBorderColor(newBorderColor, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.TEXT_FORM__BORDER_COLOR,
					newBorderColor, newBorderColor));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DoeditorPackage.TEXT_FORM__BORDER_WIDTH:
			setBorderWidth(BORDER_WIDTH_EDEFAULT);
			return;
		case DoeditorPackage.TEXT_FORM__BORDER_COLOR:
			setBorderColor((EColor) null);
			return;
		case DoeditorPackage.TEXT_FORM__TEXT:
			setText(TEXT_EDEFAULT);
			return;
		case DoeditorPackage.TEXT_FORM__HORIZONTAL_ALIGNMENT:
			setHorizontalAlignment(HORIZONTAL_ALIGNMENT_EDEFAULT);
			return;
		case DoeditorPackage.TEXT_FORM__VERTICAL_ALIGNMENT:
			setVerticalAlignment(VERTICAL_ALIGNMENT_EDEFAULT);
			return;
		case DoeditorPackage.TEXT_FORM__FONT:
			setFont((EFont) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public Rectangle getBounds() {
		return new Rectangle(getLocation(), getSize());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EFont getFont() {
		return font;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public HorizontalAlignment getHorizontalAlignment() {
		return horizontalAlignment;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText() {
		return text;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public VerticalAlignment getVerticalAlignment() {
		return verticalAlignment;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public void setBounds(final Rectangle newBounds) {
		setLocation(newBounds.getLocation());
		setSize(newBounds.getSize());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFont(EFont newFont) {
		if (newFont != font) {
			NotificationChain msgs = null;
			if (font != null)
				msgs = ((InternalEObject) font).eInverseRemove(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.TEXT_FORM__FONT, null, msgs);
			if (newFont != null)
				msgs = ((InternalEObject) newFont).eInverseAdd(this,
						EOPPOSITE_FEATURE_BASE - DoeditorPackage.TEXT_FORM__FONT, null, msgs);
			msgs = basicSetFont(newFont, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.TEXT_FORM__FONT, newFont, newFont));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHorizontalAlignment(HorizontalAlignment newHorizontalAlignment) {
		HorizontalAlignment oldHorizontalAlignment = horizontalAlignment;
		horizontalAlignment = newHorizontalAlignment == null ? HORIZONTAL_ALIGNMENT_EDEFAULT : newHorizontalAlignment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.TEXT_FORM__HORIZONTAL_ALIGNMENT,
					oldHorizontalAlignment, horizontalAlignment));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.TEXT_FORM__TEXT, oldText, text));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVerticalAlignment(VerticalAlignment newVerticalAlignment) {
		VerticalAlignment oldVerticalAlignment = verticalAlignment;
		verticalAlignment = newVerticalAlignment == null ? VERTICAL_ALIGNMENT_EDEFAULT : newVerticalAlignment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DoeditorPackage.TEXT_FORM__VERTICAL_ALIGNMENT,
					oldVerticalAlignment, verticalAlignment));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (borderWidth: ");
		result.append(borderWidth);
		result.append(", text: ");
		result.append(text);
		result.append(", horizontalAlignment: ");
		result.append(horizontalAlignment);
		result.append(", verticalAlignment: ");
		result.append(verticalAlignment);
		result.append(')');
		return result.toString();
	}

} // TextFormImpl
