/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.bsvrz.buv.plugin.doeditor.model.util.DoeditorAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class DoeditorItemProviderAdapterFactory extends DoeditorAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public DoeditorItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.BildForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BildFormItemProvider bildFormItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BildForm}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBildFormAdapter() {
		if (bildFormItemProvider == null) {
			bildFormItemProvider = new BildFormItemProvider(this);
		}

		return bildFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.TextForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TextFormItemProvider textFormItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.TextForm}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextFormAdapter() {
		if (textFormItemProvider == null) {
			textFormItemProvider = new TextFormItemProvider(this);
		}

		return textFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.PolylineForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PolylineFormItemProvider polylineFormItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.PolylineForm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPolylineFormAdapter() {
		if (polylineFormItemProvider == null) {
			polylineFormItemProvider = new PolylineFormItemProvider(this);
		}

		return polylineFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.PolygonForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected PolygonFormItemProvider polygonFormItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.PolygonForm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createPolygonFormAdapter() {
		if (polygonFormItemProvider == null) {
			polygonFormItemProvider = new PolygonFormItemProvider(this);
		}

		return polygonFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EllipseForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EllipseFormItemProvider ellipseFormItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EllipseForm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEllipseFormAdapter() {
		if (ellipseFormItemProvider == null) {
			ellipseFormItemProvider = new EllipseFormItemProvider(this);
		}

		return ellipseFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.RechteckForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected RechteckFormItemProvider rechteckFormItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.RechteckForm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRechteckFormAdapter() {
		if (rechteckFormItemProvider == null) {
			rechteckFormItemProvider = new RechteckFormItemProvider(this);
		}

		return rechteckFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.Decorator} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected DecoratorItemProvider decoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.Decorator}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDecoratorAdapter() {
		if (decoratorItemProvider == null) {
			decoratorItemProvider = new DecoratorItemProvider(this);
		}

		return decoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ZoomDecoratorItemProvider zoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createZoomDecoratorAdapter() {
		if (zoomDecoratorItemProvider == null) {
			zoomDecoratorItemProvider = new ZoomDecoratorItemProvider(this);
		}

		return zoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoModel} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EditorDoModelItemProvider editorDoModelItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEditorDoModelAdapter() {
		if (editorDoModelItemProvider == null) {
			editorDoModelItemProvider = new EditorDoModelItemProvider(this);
		}

		return editorDoModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeTextDecoratorItemProvider attributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.AttributeTextDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAttributeTextDecoratorAdapter() {
		if (attributeTextDecoratorItemProvider == null) {
			attributeTextDecoratorItemProvider = new AttributeTextDecoratorItemProvider(
					this);
		}

		return attributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BackgroundAttributeIntervalDecoratorItemProvider backgroundAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBackgroundAttributeIntervalDecoratorAdapter() {
		if (backgroundAttributeIntervalDecoratorItemProvider == null) {
			backgroundAttributeIntervalDecoratorItemProvider = new BackgroundAttributeIntervalDecoratorItemProvider(
					this);
		}

		return backgroundAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BackgroundAttributeTextDecoratorItemProvider backgroundAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BackgroundAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBackgroundAttributeTextDecoratorAdapter() {
		if (backgroundAttributeTextDecoratorItemProvider == null) {
			backgroundAttributeTextDecoratorItemProvider = new BackgroundAttributeTextDecoratorItemProvider(
					this);
		}

		return backgroundAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BackgroundZoomDecoratorItemProvider backgroundZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.BackgroundZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createBackgroundZoomDecoratorAdapter() {
		if (backgroundZoomDecoratorItemProvider == null) {
			backgroundZoomDecoratorItemProvider = new BackgroundZoomDecoratorItemProvider(
					this);
		}

		return backgroundZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DrehwinkelAttributeTextDecoratorItemProvider drehwinkelAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDrehwinkelAttributeTextDecoratorAdapter() {
		if (drehwinkelAttributeTextDecoratorItemProvider == null) {
			drehwinkelAttributeTextDecoratorItemProvider = new DrehwinkelAttributeTextDecoratorItemProvider(
					this);
		}

		return drehwinkelAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DrehwinkelAttributeIntervalDecoratorItemProvider drehwinkelAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDrehwinkelAttributeIntervalDecoratorAdapter() {
		if (drehwinkelAttributeIntervalDecoratorItemProvider == null) {
			drehwinkelAttributeIntervalDecoratorItemProvider = new DrehwinkelAttributeIntervalDecoratorItemProvider(
					this);
		}

		return drehwinkelAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DrehwinkelZoomDecoratorItemProvider drehwinkelZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.DrehwinkelZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDrehwinkelZoomDecoratorAdapter() {
		if (drehwinkelZoomDecoratorItemProvider == null) {
			drehwinkelZoomDecoratorItemProvider = new DrehwinkelZoomDecoratorItemProvider(
					this);
		}

		return drehwinkelZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected FontDataAttributeIntervalDecoratorItemProvider fontDataAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFontDataAttributeIntervalDecoratorAdapter() {
		if (fontDataAttributeIntervalDecoratorItemProvider == null) {
			fontDataAttributeIntervalDecoratorItemProvider = new FontDataAttributeIntervalDecoratorItemProvider(
					this);
		}

		return fontDataAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected FontDataAttributeTextDecoratorItemProvider fontDataAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.FontDataAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFontDataAttributeTextDecoratorAdapter() {
		if (fontDataAttributeTextDecoratorItemProvider == null) {
			fontDataAttributeTextDecoratorItemProvider = new FontDataAttributeTextDecoratorItemProvider(
					this);
		}

		return fontDataAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected FontDataZoomDecoratorItemProvider fontDataZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.FontDataZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFontDataZoomDecoratorAdapter() {
		if (fontDataZoomDecoratorItemProvider == null) {
			fontDataZoomDecoratorItemProvider = new FontDataZoomDecoratorItemProvider(
					this);
		}

		return fontDataZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ForegroundAttributeTextDecoratorItemProvider foregroundAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForegroundAttributeTextDecoratorAdapter() {
		if (foregroundAttributeTextDecoratorItemProvider == null) {
			foregroundAttributeTextDecoratorItemProvider = new ForegroundAttributeTextDecoratorItemProvider(
					this);
		}

		return foregroundAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ForegroundAttributeIntervalDecoratorItemProvider foregroundAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.ForegroundAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForegroundAttributeIntervalDecoratorAdapter() {
		if (foregroundAttributeIntervalDecoratorItemProvider == null) {
			foregroundAttributeIntervalDecoratorItemProvider = new ForegroundAttributeIntervalDecoratorItemProvider(
					this);
		}

		return foregroundAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ForegroundZoomDecoratorItemProvider foregroundZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ForegroundZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createForegroundZoomDecoratorAdapter() {
		if (foregroundZoomDecoratorItemProvider == null) {
			foregroundZoomDecoratorItemProvider = new ForegroundZoomDecoratorItemProvider(
					this);
		}

		return foregroundZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected LineAttributeAttributeIntervalDecoratorItemProvider lineAttributeAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLineAttributeAttributeIntervalDecoratorAdapter() {
		if (lineAttributeAttributeIntervalDecoratorItemProvider == null) {
			lineAttributeAttributeIntervalDecoratorItemProvider = new LineAttributeAttributeIntervalDecoratorItemProvider(
					this);
		}

		return lineAttributeAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected LineAttributeAttributeTextDecoratorItemProvider lineAttributeAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLineAttributeAttributeTextDecoratorAdapter() {
		if (lineAttributeAttributeTextDecoratorItemProvider == null) {
			lineAttributeAttributeTextDecoratorItemProvider = new LineAttributeAttributeTextDecoratorItemProvider(
					this);
		}

		return lineAttributeAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected LineAttributeZoomDecoratorItemProvider lineAttributeZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.LineAttributeZoomDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLineAttributeZoomDecoratorAdapter() {
		if (lineAttributeZoomDecoratorItemProvider == null) {
			lineAttributeZoomDecoratorItemProvider = new LineAttributeZoomDecoratorItemProvider(
					this);
		}

		return lineAttributeZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SichtbarkeitAttributeTextDecoratorItemProvider sichtbarkeitAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSichtbarkeitAttributeTextDecoratorAdapter() {
		if (sichtbarkeitAttributeTextDecoratorItemProvider == null) {
			sichtbarkeitAttributeTextDecoratorItemProvider = new SichtbarkeitAttributeTextDecoratorItemProvider(
					this);
		}

		return sichtbarkeitAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SichtbarkeitAttributeIntervalDecoratorItemProvider sichtbarkeitAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSichtbarkeitAttributeIntervalDecoratorAdapter() {
		if (sichtbarkeitAttributeIntervalDecoratorItemProvider == null) {
			sichtbarkeitAttributeIntervalDecoratorItemProvider = new SichtbarkeitAttributeIntervalDecoratorItemProvider(
					this);
		}

		return sichtbarkeitAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected SichtbarkeitZoomDecoratorItemProvider sichtbarkeitZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitZoomDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSichtbarkeitZoomDecoratorAdapter() {
		if (sichtbarkeitZoomDecoratorItemProvider == null) {
			sichtbarkeitZoomDecoratorItemProvider = new SichtbarkeitZoomDecoratorItemProvider(
					this);
		}

		return sichtbarkeitZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StringAttributeIntervalDecoratorItemProvider stringAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringAttributeIntervalDecoratorAdapter() {
		if (stringAttributeIntervalDecoratorItemProvider == null) {
			stringAttributeIntervalDecoratorItemProvider = new StringAttributeIntervalDecoratorItemProvider(
					this);
		}

		return stringAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StringAttributeTextDecoratorItemProvider stringAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.StringAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringAttributeTextDecoratorAdapter() {
		if (stringAttributeTextDecoratorItemProvider == null) {
			stringAttributeTextDecoratorItemProvider = new StringAttributeTextDecoratorItemProvider(
					this);
		}

		return stringAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StringZoomDecoratorItemProvider stringZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.StringZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createStringZoomDecoratorAdapter() {
		if (stringZoomDecoratorItemProvider == null) {
			stringZoomDecoratorItemProvider = new StringZoomDecoratorItemProvider(
					this);
		}

		return stringZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ZoomVerhaltenAttributeIntervalDecoratorItemProvider zoomVerhaltenAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZoomVerhaltenAttributeIntervalDecoratorAdapter() {
		if (zoomVerhaltenAttributeIntervalDecoratorItemProvider == null) {
			zoomVerhaltenAttributeIntervalDecoratorItemProvider = new ZoomVerhaltenAttributeIntervalDecoratorItemProvider(
					this);
		}

		return zoomVerhaltenAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ZoomVerhaltenAttributeTextDecoratorItemProvider zoomVerhaltenAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZoomVerhaltenAttributeTextDecoratorAdapter() {
		if (zoomVerhaltenAttributeTextDecoratorItemProvider == null) {
			zoomVerhaltenAttributeTextDecoratorItemProvider = new ZoomVerhaltenAttributeTextDecoratorItemProvider(
					this);
		}

		return zoomVerhaltenAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ZoomVerhaltenZoomDecoratorItemProvider zoomVerhaltenZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenZoomDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZoomVerhaltenZoomDecoratorAdapter() {
		if (zoomVerhaltenZoomDecoratorItemProvider == null) {
			zoomVerhaltenZoomDecoratorItemProvider = new ZoomVerhaltenZoomDecoratorItemProvider(
					this);
		}

		return zoomVerhaltenZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EmbeddedDoFormItemProvider embeddedDoFormItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EmbeddedDoForm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEmbeddedDoFormAdapter() {
		if (embeddedDoFormItemProvider == null) {
			embeddedDoFormItemProvider = new EmbeddedDoFormItemProvider(this);
		}

		return embeddedDoFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExternalDoFormItemProvider externalDoFormItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExternalDoFormAdapter() {
		if (externalDoFormItemProvider == null) {
			externalDoFormItemProvider = new ExternalDoFormItemProvider(this);
		}

		return externalDoFormItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DoEditorDiagrammItemProvider doEditorDiagrammItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.DoEditorDiagramm}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDoEditorDiagrammAdapter() {
		if (doEditorDiagrammItemProvider == null) {
			doEditorDiagrammItemProvider = new DoEditorDiagrammItemProvider(
					this);
		}

		return doEditorDiagrammItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EditorDoTypItemProvider editorDoTypItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEditorDoTypAdapter() {
		if (editorDoTypItemProvider == null) {
			editorDoTypItemProvider = new EditorDoTypItemProvider(this);
		}

		return editorDoTypItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected EditorDoTypReferenzItemProvider editorDoTypReferenzItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEditorDoTypReferenzAdapter() {
		if (editorDoTypReferenzItemProvider == null) {
			editorDoTypReferenzItemProvider = new EditorDoTypReferenzItemProvider(
					this);
		}

		return editorDoTypReferenzItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderColorAttributeTextDecoratorItemProvider borderColorAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBorderColorAttributeTextDecoratorAdapter() {
		if (borderColorAttributeTextDecoratorItemProvider == null) {
			borderColorAttributeTextDecoratorItemProvider = new BorderColorAttributeTextDecoratorItemProvider(
					this);
		}

		return borderColorAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderColorAttributeIntervalDecoratorItemProvider borderColorAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBorderColorAttributeIntervalDecoratorAdapter() {
		if (borderColorAttributeIntervalDecoratorItemProvider == null) {
			borderColorAttributeIntervalDecoratorItemProvider = new BorderColorAttributeIntervalDecoratorItemProvider(
					this);
		}

		return borderColorAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderColorZoomDecoratorItemProvider borderColorZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.BorderColorZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createBorderColorZoomDecoratorAdapter() {
		if (borderColorZoomDecoratorItemProvider == null) {
			borderColorZoomDecoratorItemProvider = new BorderColorZoomDecoratorItemProvider(
					this);
		}

		return borderColorZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderWidthAttributeTextDecoratorItemProvider borderWidthAttributeTextDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeTextDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBorderWidthAttributeTextDecoratorAdapter() {
		if (borderWidthAttributeTextDecoratorItemProvider == null) {
			borderWidthAttributeTextDecoratorItemProvider = new BorderWidthAttributeTextDecoratorItemProvider(
					this);
		}

		return borderWidthAttributeTextDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderWidthAttributeIntervalDecoratorItemProvider borderWidthAttributeIntervalDecoratorItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthAttributeIntervalDecorator}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBorderWidthAttributeIntervalDecoratorAdapter() {
		if (borderWidthAttributeIntervalDecoratorItemProvider == null) {
			borderWidthAttributeIntervalDecoratorItemProvider = new BorderWidthAttributeIntervalDecoratorItemProvider(
					this);
		}

		return borderWidthAttributeIntervalDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected BorderWidthZoomDecoratorItemProvider borderWidthZoomDecoratorItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.doeditor.model.BorderWidthZoomDecorator}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createBorderWidthZoomDecoratorAdapter() {
		if (borderWidthZoomDecoratorItemProvider == null) {
			borderWidthZoomDecoratorItemProvider = new BorderWidthZoomDecoratorItemProvider(
					this);
		}

		return borderWidthZoomDecoratorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.doeditor.model.Identidy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentidyItemProvider identidyItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.doeditor.model.Identidy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIdentidyAdapter() {
		if (identidyItemProvider == null) {
			identidyItemProvider = new IdentidyItemProvider(this);
		}

		return identidyItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory
				.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
					|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (bildFormItemProvider != null)
			bildFormItemProvider.dispose();
		if (textFormItemProvider != null)
			textFormItemProvider.dispose();
		if (polylineFormItemProvider != null)
			polylineFormItemProvider.dispose();
		if (polygonFormItemProvider != null)
			polygonFormItemProvider.dispose();
		if (ellipseFormItemProvider != null)
			ellipseFormItemProvider.dispose();
		if (rechteckFormItemProvider != null)
			rechteckFormItemProvider.dispose();
		if (decoratorItemProvider != null)
			decoratorItemProvider.dispose();
		if (zoomDecoratorItemProvider != null)
			zoomDecoratorItemProvider.dispose();
		if (editorDoModelItemProvider != null)
			editorDoModelItemProvider.dispose();
		if (attributeTextDecoratorItemProvider != null)
			attributeTextDecoratorItemProvider.dispose();
		if (backgroundAttributeIntervalDecoratorItemProvider != null)
			backgroundAttributeIntervalDecoratorItemProvider.dispose();
		if (backgroundAttributeTextDecoratorItemProvider != null)
			backgroundAttributeTextDecoratorItemProvider.dispose();
		if (backgroundZoomDecoratorItemProvider != null)
			backgroundZoomDecoratorItemProvider.dispose();
		if (drehwinkelAttributeTextDecoratorItemProvider != null)
			drehwinkelAttributeTextDecoratorItemProvider.dispose();
		if (drehwinkelAttributeIntervalDecoratorItemProvider != null)
			drehwinkelAttributeIntervalDecoratorItemProvider.dispose();
		if (drehwinkelZoomDecoratorItemProvider != null)
			drehwinkelZoomDecoratorItemProvider.dispose();
		if (fontDataAttributeIntervalDecoratorItemProvider != null)
			fontDataAttributeIntervalDecoratorItemProvider.dispose();
		if (fontDataAttributeTextDecoratorItemProvider != null)
			fontDataAttributeTextDecoratorItemProvider.dispose();
		if (fontDataZoomDecoratorItemProvider != null)
			fontDataZoomDecoratorItemProvider.dispose();
		if (foregroundAttributeTextDecoratorItemProvider != null)
			foregroundAttributeTextDecoratorItemProvider.dispose();
		if (foregroundAttributeIntervalDecoratorItemProvider != null)
			foregroundAttributeIntervalDecoratorItemProvider.dispose();
		if (foregroundZoomDecoratorItemProvider != null)
			foregroundZoomDecoratorItemProvider.dispose();
		if (lineAttributeAttributeIntervalDecoratorItemProvider != null)
			lineAttributeAttributeIntervalDecoratorItemProvider.dispose();
		if (lineAttributeAttributeTextDecoratorItemProvider != null)
			lineAttributeAttributeTextDecoratorItemProvider.dispose();
		if (lineAttributeZoomDecoratorItemProvider != null)
			lineAttributeZoomDecoratorItemProvider.dispose();
		if (sichtbarkeitAttributeTextDecoratorItemProvider != null)
			sichtbarkeitAttributeTextDecoratorItemProvider.dispose();
		if (sichtbarkeitAttributeIntervalDecoratorItemProvider != null)
			sichtbarkeitAttributeIntervalDecoratorItemProvider.dispose();
		if (sichtbarkeitZoomDecoratorItemProvider != null)
			sichtbarkeitZoomDecoratorItemProvider.dispose();
		if (stringAttributeIntervalDecoratorItemProvider != null)
			stringAttributeIntervalDecoratorItemProvider.dispose();
		if (stringAttributeTextDecoratorItemProvider != null)
			stringAttributeTextDecoratorItemProvider.dispose();
		if (stringZoomDecoratorItemProvider != null)
			stringZoomDecoratorItemProvider.dispose();
		if (zoomVerhaltenAttributeIntervalDecoratorItemProvider != null)
			zoomVerhaltenAttributeIntervalDecoratorItemProvider.dispose();
		if (zoomVerhaltenAttributeTextDecoratorItemProvider != null)
			zoomVerhaltenAttributeTextDecoratorItemProvider.dispose();
		if (zoomVerhaltenZoomDecoratorItemProvider != null)
			zoomVerhaltenZoomDecoratorItemProvider.dispose();
		if (embeddedDoFormItemProvider != null)
			embeddedDoFormItemProvider.dispose();
		if (externalDoFormItemProvider != null)
			externalDoFormItemProvider.dispose();
		if (doEditorDiagrammItemProvider != null)
			doEditorDiagrammItemProvider.dispose();
		if (editorDoTypItemProvider != null)
			editorDoTypItemProvider.dispose();
		if (editorDoTypReferenzItemProvider != null)
			editorDoTypReferenzItemProvider.dispose();
		if (borderColorAttributeTextDecoratorItemProvider != null)
			borderColorAttributeTextDecoratorItemProvider.dispose();
		if (borderColorAttributeIntervalDecoratorItemProvider != null)
			borderColorAttributeIntervalDecoratorItemProvider.dispose();
		if (borderColorZoomDecoratorItemProvider != null)
			borderColorZoomDecoratorItemProvider.dispose();
		if (borderWidthAttributeTextDecoratorItemProvider != null)
			borderWidthAttributeTextDecoratorItemProvider.dispose();
		if (borderWidthAttributeIntervalDecoratorItemProvider != null)
			borderWidthAttributeIntervalDecoratorItemProvider.dispose();
		if (borderWidthZoomDecoratorItemProvider != null)
			borderWidthZoomDecoratorItemProvider.dispose();
		if (identidyItemProvider != null)
			identidyItemProvider.dispose();
	}

}
