/**
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 *  
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 * 
 * 
 */
package de.bsvrz.buv.plugin.doeditor.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import com.bitctrl.lib.eclipse.emf.eclipse.model.provider.NamedItemProvider;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class EditorDoTypItemProvider extends NamedItemProvider implements
		IEditingDomainItemProvider, IStructuredItemContentProvider,
		ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EditorDoTypItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addLocationPropertyDescriptor(object);
			addSizePropertyDescriptor(object);
			addSystemObjektPropertyDescriptor(object);
			addSystemObjectTypePropertyDescriptor(object);
			addHotspotPropertyDescriptor(object);
			addAnLinieAusrichtenPropertyDescriptor(object);
			addDoTypPidPropertyDescriptor(object);
			addLastUsedLevelIdPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Location feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLocationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_Located_location_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Located_location_feature", "_UI_Located_type"),
				GefPackage.Literals.LOCATED__LOCATION, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the System Objekt feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addSystemObjektPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_EditorDoTyp_systemObjekt_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_EditorDoTyp_systemObjekt_feature",
						"_UI_EditorDoTyp_type"),
				DoeditorPackage.Literals.EDITOR_DO_TYP__SYSTEM_OBJEKT, true,
				false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null,
				null));
	}

	/**
	 * This adds a property descriptor for the Size feature.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSizePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_Sized_size_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Sized_size_feature", "_UI_Sized_type"),
				GefPackage.Literals.SIZED__SIZE, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Hotspot feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addHotspotPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_EditorDoTyp_hotspot_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_EditorDoTyp_hotspot_feature",
						"_UI_EditorDoTyp_type"),
				DoeditorPackage.Literals.EDITOR_DO_TYP__HOTSPOT, true, false,
				false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the An Linie Ausrichten feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addAnLinieAusrichtenPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_EditorDoTyp_anLinieAusrichten_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_EditorDoTyp_anLinieAusrichten_feature",
						"_UI_EditorDoTyp_type"),
				DoeditorPackage.Literals.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN,
				true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Do Typ Pid feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addDoTypPidPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_EditorDoTyp_doTypPid_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_EditorDoTyp_doTypPid_feature",
						"_UI_EditorDoTyp_type"),
				DoeditorPackage.Literals.EDITOR_DO_TYP__DO_TYP_PID, true,
				false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null,
				null));
	}

	/**
	 * This adds a property descriptor for the Last Used Level Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addLastUsedLevelIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_EditorDoTyp_lastUsedLevelId_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_EditorDoTyp_lastUsedLevelId_feature",
						"_UI_EditorDoTyp_type"),
				DoeditorPackage.Literals.EDITOR_DO_TYP__LAST_USED_LEVEL_ID,
				true, false, false,
				ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the System Object Type feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addSystemObjectTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_EditorDoTyp_systemObjectType_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_EditorDoTyp_systemObjectType_feature",
						"_UI_EditorDoTyp_type"),
				DoeditorPackage.Literals.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(
			Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures
					.add(DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns EditorDoTyp.gif. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object,
				getResourceLocator().getImage("full/obj16/EditorDoTyp"));
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	@Override
	public String getText(final Object object) {
		String label = ((EditorDoTyp) object).getName();

		if (label == null || label.isEmpty()) {
			label = getString("_UI_EditorDoTyp_type");
		}

		return label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(EditorDoTyp.class)) {
		case DoeditorPackage.EDITOR_DO_TYP__LOCATION:
		case DoeditorPackage.EDITOR_DO_TYP__SIZE:
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJEKT:
		case DoeditorPackage.EDITOR_DO_TYP__SYSTEM_OBJECT_TYPE:
		case DoeditorPackage.EDITOR_DO_TYP__HOTSPOT:
		case DoeditorPackage.EDITOR_DO_TYP__AN_LINIE_AUSRICHTEN:
		case DoeditorPackage.EDITOR_DO_TYP__DO_TYP_PID:
		case DoeditorPackage.EDITOR_DO_TYP__LAST_USED_LEVEL_ID:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		case DoeditorPackage.EDITOR_DO_TYP__FORMEN:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), true, false));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createBildForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createTextForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createPolylineForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createPolygonForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createEllipseForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createRechteckForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createEmbeddedDoForm()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.EDITOR_DO_TYP__FORMEN,
				DoeditorFactory.eINSTANCE.createExternalDoForm()));
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DoeditorEditPlugin.INSTANCE;
	}

}
