/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import com.bitctrl.lib.eclipse.emf.eclipse.model.provider.NamedItemProvider;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.doeditor.model.ExternalDoForm} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class ExternalDoFormItemProvider extends NamedItemProvider implements
		IEditingDomainItemProvider, IStructuredItemContentProvider,
		ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ExternalDoFormItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addLocationPropertyDescriptor(object);
			addVisiblePropertyDescriptor(object);
			addIdPropertyDescriptor(object);
			addDarstellungsObjektTypPropertyDescriptor(object);
			addExtensionPointIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Location feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLocationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_Located_location_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Located_location_feature", "_UI_Located_type"),
				GefPackage.Literals.LOCATED__LOCATION, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Visible feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addVisiblePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_VisibleForm_visible_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_VisibleForm_visible_feature",
						"_UI_VisibleForm_type"),
				DoeditorPackage.Literals.VISIBLE_FORM__VISIBLE, true, false,
				false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_Identidy_id_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Identidy_id_feature", "_UI_Identidy_type"),
				DoeditorPackage.Literals.IDENTIDY__ID, true, false, false,
				ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Darstellungs Objekt Typ feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDarstellungsObjektTypPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_ExternalDoForm_darstellungsObjektTyp_feature"),
						getString(
								"_UI_PropertyDescriptor_description",
								"_UI_ExternalDoForm_darstellungsObjektTyp_feature",
								"_UI_ExternalDoForm_type"),
						DoeditorPackage.Literals.EXTERNAL_DO_FORM__DARSTELLUNGS_OBJEKT_TYP,
						true, false, true, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Extension Point ID feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addExtensionPointIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_ExternalDoForm_extensionPointID_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_ExternalDoForm_extensionPointID_feature",
						"_UI_ExternalDoForm_type"),
				DoeditorPackage.Literals.EXTERNAL_DO_FORM__EXTENSION_POINT_ID,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(
			Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures
					.add(DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns ExternalDoForm.gif.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object,
				getResourceLocator().getImage("full/obj16/ExternalDoForm"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((ExternalDoForm) object).getName();
		return label == null || label.length() == 0 ? getString("_UI_ExternalDoForm_type")
				: getString("_UI_ExternalDoForm_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ExternalDoForm.class)) {
		case DoeditorPackage.EXTERNAL_DO_FORM__LOCATION:
		case DoeditorPackage.EXTERNAL_DO_FORM__VISIBLE:
		case DoeditorPackage.EXTERNAL_DO_FORM__ID:
		case DoeditorPackage.EXTERNAL_DO_FORM__EXTENSION_POINT_ID:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		case DoeditorPackage.EXTERNAL_DO_FORM__DECORATORS:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), true, false));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBackgroundAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBackgroundAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createBackgroundZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createDrehwinkelAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createDrehwinkelAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createDrehwinkelZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createFontDataAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createFontDataAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createFontDataZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createForegroundAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createForegroundAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createForegroundZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createLineAttributeAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createLineAttributeAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createLineAttributeZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createSichtbarkeitAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createSichtbarkeitAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createSichtbarkeitZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createStringAttributeIntervalDecorator()));

		newChildDescriptors
				.add(createChildParameter(
						DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
						DoeditorFactory.eINSTANCE
								.createStringAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createStringZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createZoomVerhaltenAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createZoomVerhaltenAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createZoomVerhaltenZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderColorAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderColorAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createBorderColorZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderWidthAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderWidthAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createBorderWidthZoomDecorator()));
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DoeditorEditPlugin.INSTANCE;
	}

}
