/*
 * Rahmenwerk-Plug-in "Darstellungsobjekttyp-Editor"
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.doeditor.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import com.bitctrl.lib.eclipse.emf.eclipse.model.provider.NamedItemProvider;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorPackage;
import de.bsvrz.buv.plugin.doeditor.model.FlaechenForm;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.doeditor.model.FlaechenForm} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class FlaechenFormItemProvider extends NamedItemProvider implements
		IEditingDomainItemProvider, IStructuredItemContentProvider,
		ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public FlaechenFormItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addLocationPropertyDescriptor(object);
			addVisiblePropertyDescriptor(object);
			addAnglePropertyDescriptor(object);
			addZoomVerhaltenPropertyDescriptor(object);
			addPositionierungPropertyDescriptor(object);
			addBoundsPropertyDescriptor(object);
			addForegroundColorPropertyDescriptor(object);
			addLineAttributesPropertyDescriptor(object);
			addSizePropertyDescriptor(object);
			addBackgroundPatternPropertyDescriptor(object);
			addFilledPropertyDescriptor(object);
			addBackgroundColorPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Location feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLocationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_Located_location_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Located_location_feature", "_UI_Located_type"),
				GefPackage.Literals.LOCATED__LOCATION, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Visible feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addVisiblePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_VisibleForm_visible_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_VisibleForm_visible_feature",
						"_UI_VisibleForm_type"),
				DoeditorPackage.Literals.VISIBLE_FORM__VISIBLE, true, false,
				false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Zoom Verhalten feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addZoomVerhaltenPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_ZoomableForm_zoomVerhalten_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_ZoomableForm_zoomVerhalten_feature",
						"_UI_ZoomableForm_type"),
				DoeditorPackage.Literals.ZOOMABLE_FORM__ZOOM_VERHALTEN, true,
				false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null,
				null));
	}

	/**
	 * This adds a property descriptor for the Angle feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addAnglePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_RotatableForm_angle_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_RotatableForm_angle_feature",
						"_UI_RotatableForm_type"),
				DoeditorPackage.Literals.ROTATABLE_FORM__ANGLE, true, false,
				false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Foreground Color feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addForegroundColorPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_PunktForm_foregroundColor_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_PunktForm_foregroundColor_feature",
						"_UI_PunktForm_type"),
				DoeditorPackage.Literals.PUNKT_FORM__FOREGROUND_COLOR, true,
				false, false, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Positionierung feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addPositionierungPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_PunktForm_positionierung_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_PunktForm_positionierung_feature",
						"_UI_PunktForm_type"),
				DoeditorPackage.Literals.PUNKT_FORM__POSITIONIERUNG, true,
				false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null,
				null));
	}

	/**
	 * This adds a property descriptor for the Bounds feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addBoundsPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_PunktForm_bounds_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_PunktForm_bounds_feature", "_UI_PunktForm_type"),
				DoeditorPackage.Literals.PUNKT_FORM__BOUNDS, true, false,
				false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Line Attributes feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addLineAttributesPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_LinienForm_lineAttributes_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_LinienForm_lineAttributes_feature",
						"_UI_LinienForm_type"),
				DoeditorPackage.Literals.LINIEN_FORM__LINE_ATTRIBUTES, true,
				false, false, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Background Color feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addBackgroundColorPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_FlaechenForm_backgroundColor_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_FlaechenForm_backgroundColor_feature",
						"_UI_FlaechenForm_type"),
				DoeditorPackage.Literals.FLAECHEN_FORM__BACKGROUND_COLOR, true,
				false, false, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Background Pattern feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addBackgroundPatternPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_FlaechenForm_backgroundPattern_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_FlaechenForm_backgroundPattern_feature",
						"_UI_FlaechenForm_type"),
				DoeditorPackage.Literals.FLAECHEN_FORM__BACKGROUND_PATTERN,
				true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				null, null));
	}

	/**
	 * This adds a property descriptor for the Filled feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addFilledPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_FlaechenForm_filled_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_FlaechenForm_filled_feature",
						"_UI_FlaechenForm_type"),
				DoeditorPackage.Literals.FLAECHEN_FORM__FILLED, true, false,
				false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Size feature.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSizePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_Sized_size_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_Sized_size_feature", "_UI_Sized_type"),
				GefPackage.Literals.SIZED__SIZE, true, false, false,
				ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(
			Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures
					.add(DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns FlaechenForm.gif. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object,
				getResourceLocator().getImage("full/obj16/FlaechenForm"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((FlaechenForm) object).getName();
		return label == null || label.length() == 0 ? getString("_UI_FlaechenForm_type")
				: getString("_UI_FlaechenForm_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(FlaechenForm.class)) {
		case DoeditorPackage.FLAECHEN_FORM__LOCATION:
		case DoeditorPackage.FLAECHEN_FORM__VISIBLE:
		case DoeditorPackage.FLAECHEN_FORM__ANGLE:
		case DoeditorPackage.FLAECHEN_FORM__ZOOM_VERHALTEN:
		case DoeditorPackage.FLAECHEN_FORM__POSITIONIERUNG:
		case DoeditorPackage.FLAECHEN_FORM__BOUNDS:
		case DoeditorPackage.FLAECHEN_FORM__FOREGROUND_COLOR:
		case DoeditorPackage.FLAECHEN_FORM__LINE_ATTRIBUTES:
		case DoeditorPackage.FLAECHEN_FORM__SIZE:
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_PATTERN:
		case DoeditorPackage.FLAECHEN_FORM__FILLED:
		case DoeditorPackage.FLAECHEN_FORM__BACKGROUND_COLOR:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		case DoeditorPackage.FLAECHEN_FORM__DECORATORS:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), true, false));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBackgroundAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBackgroundAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createBackgroundZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createDrehwinkelAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createDrehwinkelAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createDrehwinkelZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createFontDataAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createFontDataAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createFontDataZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createForegroundAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createForegroundAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createForegroundZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createLineAttributeAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createLineAttributeAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createLineAttributeZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createSichtbarkeitAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createSichtbarkeitAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createSichtbarkeitZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createStringAttributeIntervalDecorator()));

		newChildDescriptors
				.add(createChildParameter(
						DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
						DoeditorFactory.eINSTANCE
								.createStringAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createStringZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createZoomVerhaltenAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createZoomVerhaltenAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createZoomVerhaltenZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderColorAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderColorAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createBorderColorZoomDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderWidthAttributeTextDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE
						.createBorderWidthAttributeIntervalDecorator()));

		newChildDescriptors.add(createChildParameter(
				DoeditorPackage.Literals.VISIBLE_FORM__DECORATORS,
				DoeditorFactory.eINSTANCE.createBorderWidthZoomDecorator()));
	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return DoeditorEditPlugin.INSTANCE;
	}

}
