/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DarstellungStatus
extends StatusLineContributionItem {
    private final IWorkbenchPage page;
    private final IPartListenerImplementation listener;
    private IWorkbenchPart currentPart;
    private GraphicalViewer viewer;
    private ZoomManager zoomManager;
    private Darstellung darstellung;

    public DarstellungStatus(IWorkbenchPage page, String id, int charWidth) {
        super(id, charWidth);
        this.page = page;
        this.listener = new IPartListenerImplementation();
        page.addPartListener((IPartListener)this.listener);
    }

    private void updateStatus(IWorkbenchPart part) {
        IEditorPart activeEditor = this.page.getActiveEditor();
        if (this.currentPart != null && this.currentPart != activeEditor) {
            this.deactivate();
            this.viewer = null;
            this.zoomManager = null;
            this.darstellung = null;
            this.currentPart = null;
        }
        if (activeEditor != null && this.currentPart != activeEditor) {
            GraphicalViewer v = (GraphicalViewer)this.page.getActiveEditor().getAdapter(GraphicalViewer.class);
            ZoomManager zm = (ZoomManager)this.page.getActiveEditor().getAdapter(ZoomManager.class);
            Darstellung d = (Darstellung)this.page.getActiveEditor().getAdapter(Darstellung.class);
            if (v != null && d != null && zm != null) {
                this.currentPart = part;
                this.darstellung = d;
                this.zoomManager = zm;
                this.viewer = v;
                this.activate();
            }
        }
    }

    protected GraphicalViewer getViewer() {
        return this.viewer;
    }

    protected ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    protected Darstellung getDarstellung() {
        return this.darstellung;
    }

    protected abstract void activate();

    protected abstract void deactivate();

    public void dispose() {
        this.page.removePartListener((IPartListener)this.listener);
        super.dispose();
    }

    private final class IPartListenerImplementation
    implements IPartListener {
        private IPartListenerImplementation() {
        }

        public void partOpened(IWorkbenchPart part) {
            DarstellungStatus.this.updateStatus(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            DarstellungStatus.this.updateStatus(part);
        }

        public void partClosed(IWorkbenchPart part) {
            DarstellungStatus.this.updateStatus(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            DarstellungStatus.this.updateStatus(part);
        }

        public void partActivated(IWorkbenchPart part) {
            DarstellungStatus.this.updateStatus(part);
        }
    }
}

