/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.darstellung.internal.DarstellungMessages;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.PartEventAction;

public class SelectionFilterAction
extends PartEventAction
implements IMenuCreator {
    private Menu menu;

    public SelectionFilterAction() {
        super(DarstellungMessages.SelectionFilter_Label);
        this.setImageDescriptor(DarstellungIcons.ActionSelectionFilter.getImageDescriptor());
        this.setToolTipText(DarstellungMessages.SelectionFilter_Tooltip);
        this.setId(((Object)((Object)this)).getClass().toString());
        this.setActionDefinitionId(((Object)((Object)this)).getClass().toString());
        this.setMenuCreator(this);
    }

    private void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private Darstellung getDarstellung() {
        return (Darstellung)this.getActivePart().getAdapter(Darstellung.class);
    }

    private SelectionProperties getSelectionProperties() {
        GraphicalViewer viewer = (GraphicalViewer)this.getActivePart().getAdapter(GraphicalViewer.class);
        return (SelectionProperties)viewer.getProperty(SelectionProperties.class.toString());
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        ArrayList<DoTyp> doTypenAlle = new ArrayList<DoTyp>((Collection<DoTyp>)this.getDarstellung().getDoTypen());
        ArrayList<DoTyp> doTypen = new ArrayList<DoTyp>();
        for (DoTyp doTyp : doTypenAlle) {
            if (doTypen.contains(doTyp)) continue;
            doTypen.add(doTyp);
        }
        Collections.sort(doTypen, Comparator.comparing(Named::getName));
        for (DoTyp doTyp : doTypen) {
            this.addActionToMenu(this.menu, new DoTypAction(doTyp));
        }
        return this.menu;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    private class DoTypAction
    extends Action {
        private final DoTyp doTyp;

        DoTypAction(DoTyp doTyp) {
            super(doTyp.getName(), 2);
            this.doTyp = doTyp;
            this.setChecked(SelectionFilterAction.this.getSelectionProperties().getMatchDoTypen().contains(doTyp));
        }

        public void run() {
            if (this.isChecked()) {
                SelectionFilterAction.this.getSelectionProperties().getMatchDoTypen().add(this.doTyp);
            } else {
                SelectionFilterAction.this.getSelectionProperties().getMatchDoTypen().remove(this.doTyp);
            }
        }
    }
}

