/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import de.bsvrz.buv.plugin.darstellung.actions.DarstellungActionFactory;
import de.bsvrz.buv.plugin.darstellung.dialogs.EbenenWindow;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleEbenenAction
extends Action {
    private final IWorkbenchPart part;
    private EbenenWindow window;
    private final Control control;

    public ToggleEbenenAction(IWorkbenchPart part, Control control) {
        super("Ebenen ein-/ausblenden", 2);
        this.part = part;
        this.control = control;
        this.setImageDescriptor(DarstellungIcons.ActionToggleEbenen.getImageDescriptor());
        this.setToolTipText("Blendet den Ebenenmanager ein und aus.");
        this.setId(DarstellungActionFactory.TOGGLE_EBENEN.getCommandId());
        this.setActionDefinitionId(DarstellungActionFactory.TOGGLE_EBENEN.getCommandId());
    }

    public void run() {
        if (this.window != null) {
            this.window.close();
            this.window = null;
        } else {
            this.window = new EbenenWindow(this.part, this.control);
            this.window.open();
            this.window.getShell().addDisposeListener(e -> {
                this.setChecked(false);
                this.window = null;
            });
        }
    }
}

