/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.editors.AnsichtEditor;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.editors.EmfEinstellungenEditorInput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ZeigeAnsichtAction
extends Action {
    private final IWorkbenchPart part;

    public ZeigeAnsichtAction(IWorkbenchPart part) {
        super("Ansicht \u00f6ffnen");
        this.setId("de.bsvrz.buv.plugin.darstellung.command.zeigeAnsicht");
        this.setActionDefinitionId("de.bsvrz.buv.plugin.darstellung.command.zeigeAnsicht");
        this.part = part;
    }

    public void run() {
        ITreeSelection selection = (ITreeSelection)this.part.getSite().getSelectionProvider().getSelection();
        TreePath[] treePathArray = selection.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            SpeicherKey einstellungsArt = (SpeicherKey)path.getFirstSegment();
            if (path.getLastSegment() instanceof Ansicht) {
                Ansicht ansicht = (Ansicht)path.getLastSegment();
                IStatus status = EmfUtil.validate((EObject)ansicht, (String)"de.bsvrz.buv.plugin.dobj");
                if (status.isOK()) {
                    EmfEinstellungenEditorInput input = new EmfEinstellungenEditorInput((EObject)ansicht, einstellungsArt);
                    input.setExists(true);
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, AnsichtEditor.EDITOR_ID);
                    }
                    catch (PartInitException ex) {
                        DObjPlugin.getDefault().getLog().error("Die Ansicht \"" + String.valueOf(ansicht) + "\" konnte nicht ge\u00f6ffnet werden.", (Throwable)ex);
                    }
                }
                ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)"Ansicht nicht darstellbar", (String)("Die Ansicht \"" + ansicht.getName() + "\" kann nicht ge\u00f6ffnet werden, weil sie nicht lesbar ist."), (IStatus)status);
            }
            ++n2;
        }
    }
}

