/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.commands.CommandUtil;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddDoTypToAutoEbeneCommand
extends Command {
    private final AutoEbene ebene;
    private DoTyp doTyp;
    private boolean useExistsDoTyp;

    public AddDoTypToAutoEbeneCommand(DoTyp doTyp, AutoEbene ebene) {
        Assert.isNotNull((Object)doTyp, (String)"doTyp");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.doTyp = doTyp;
        this.ebene = ebene;
        this.setLabel("Darstellungsobjekttyp zur Autoebene hinzuf\u00fcgen");
    }

    public boolean canExecute() {
        return !CommandUtil.contains(this.ebene.getDoTypen(), this.doTyp);
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.doTyp = this.mergeDoTypAndCheckIfMustBeHandled(this.doTyp);
        this.redo();
    }

    private DoTyp mergeDoTypAndCheckIfMustBeHandled(DoTyp dot) {
        Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
        DoTyp existsDot = CommandUtil.getDoTyp(darstellung.getDoTypen(), dot);
        if (existsDot != null) {
            this.useExistsDoTyp = true;
            return existsDot;
        }
        this.useExistsDoTyp = false;
        return dot;
    }

    public void redo() {
        this.ebene.getDoTypen().add((Object)this.doTyp);
        if (!this.useExistsDoTyp) {
            Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
            darstellung.getDoTypen().add((Object)this.doTyp);
        }
    }

    public void undo() {
        if (!this.useExistsDoTyp) {
            Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
            darstellung.getDoTypen().remove((Object)this.doTyp);
        }
        this.ebene.getDoTypen().remove((Object)this.doTyp);
    }
}

