/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

public class CreateDarstellungsSpalteCommand
extends Command {
    private final StilisierteDarstellung darstellung;
    private DarstellungsSpalte spalte;

    public CreateDarstellungsSpalteCommand(StilisierteDarstellung darstellung) {
        Assert.isNotNull((Object)darstellung, (String)"darstellung");
        this.darstellung = darstellung;
    }

    public void execute() {
        this.spalte = this.createDarstellungsspalte();
        this.redo();
    }

    private DarstellungsSpalte createDarstellungsspalte() {
        DarstellungsSpalte ds = DarstellungFactory.eINSTANCE.createDarstellungsSpalte();
        Object name = "Spalte";
        if (!this.isErsteSpalte()) {
            name = this.darstellung.getSpalten().size() + 1 + ". " + (String)name;
        }
        ds.setName((String)name);
        return ds;
    }

    public void redo() {
        if (this.isErsteSpalte()) {
            this.addObjekteToSpalte();
        } else {
            this.vergroessereDarstellungUmSpaltenBreite();
        }
        this.addDarstellungsSpalteToDarstellung();
    }

    private boolean isErsteSpalte() {
        return this.darstellung.getSpalten().isEmpty();
    }

    private void addDarstellungsSpalteToDarstellung() {
        this.darstellung.getSpalten().add((Object)this.spalte);
    }

    private void addObjekteToSpalte() {
        this.spalte.setWidth(this.darstellung.getSize().width);
        for (Ebene ebene : this.darstellung.getEbenen()) {
            for (DoModel doModel : ebene.getDoObjekte()) {
                this.spalte.getDoObjekte().add((Object)doModel);
            }
        }
    }

    private void vergroessereDarstellungUmSpaltenBreite() {
        Dimension size = this.darstellung.getSize();
        this.darstellung.setSize(new Dimension(size.width + this.spalte.getWidth(), size.height));
    }

    public void undo() {
        this.removeDarstellungsSpalteFromDarstellung();
        if (this.darstellung.getSpalten().isEmpty()) {
            this.removeObjekteFromSpalte();
        } else {
            this.verkleinereDarstellungUmSpaltenBreite();
        }
    }

    private void removeDarstellungsSpalteFromDarstellung() {
        this.darstellung.getSpalten().remove((Object)this.spalte);
    }

    private void removeObjekteFromSpalte() {
        for (Ebene ebene : this.darstellung.getEbenen()) {
            for (DoModel doModel : ebene.getDoObjekte()) {
                this.spalte.getDoObjekte().remove((Object)doModel);
            }
        }
    }

    private void verkleinereDarstellungUmSpaltenBreite() {
        Dimension size = this.darstellung.getSize();
        this.darstellung.setSize(new Dimension(size.width - this.spalte.getWidth(), size.height));
    }
}

