/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

public class DeleteDarstellungsSpalteCommand
extends Command {
    private StilisierteDarstellung darstellung;
    private final DarstellungsSpalte spalte;
    private int spaltenIndexInDarstellung;
    private SortedSet<DoIdentifier> objekte;

    public DeleteDarstellungsSpalteCommand(DarstellungsSpalte spalte) {
        Assert.isNotNull((Object)spalte, (String)"spalte");
        this.spalte = spalte;
    }

    public void execute() {
        this.darstellung = this.getDarstellung();
        this.spaltenIndexInDarstellung = this.darstellung.getSpalten().indexOf((Object)this.spalte);
        this.objekte = this.getObjekte();
        this.redo();
    }

    private StilisierteDarstellung getDarstellung() {
        StilisierteDarstellung d = this.spalte.getDarstellung();
        Assert.isNotNull((Object)d, (String)"darstellung");
        return d;
    }

    private SortedSet<DoIdentifier> getObjekte() {
        TreeSet<DoIdentifier> result = new TreeSet<DoIdentifier>();
        for (DoModel model : this.spalte.getDoObjekte()) {
            for (Ebene ebene : this.darstellung.getEbenen()) {
                if (!ebene.getDoObjekte().contains((Object)model)) continue;
                int index = ebene.getDoObjekte().indexOf((Object)model);
                result.add(new DoIdentifier(model, ebene, index));
            }
        }
        return result;
    }

    public void redo() {
        this.removeDarstellungsSpalteFromDarstellung();
        if (!this.isLetzteSpalte()) {
            this.deleteObjekte();
            this.verkleinereDarstellungUmSpaltenBreite();
        }
    }

    private boolean isLetzteSpalte() {
        return this.darstellung.getSpalten().isEmpty();
    }

    private void deleteObjekte() {
        for (Ebene ebene : this.darstellung.getEbenen()) {
            ebene.getDoObjekte().removeAll(this.spalte.getDoObjekte());
        }
    }

    private void removeDarstellungsSpalteFromDarstellung() {
        this.darstellung.getSpalten().remove(this.spaltenIndexInDarstellung);
    }

    private void verkleinereDarstellungUmSpaltenBreite() {
        Dimension size = this.darstellung.getSize();
        this.darstellung.setSize(new Dimension(size.width - this.spalte.getWidth(), size.height));
    }

    public void undo() {
        if (!this.isLetzteSpalte()) {
            this.vergroessereDarstellungUmSpaltenBreite();
            this.addObjekte();
        }
        this.addDarstellungsSpalteToDarstellung();
    }

    private void vergroessereDarstellungUmSpaltenBreite() {
        Dimension size = this.darstellung.getSize();
        this.darstellung.setSize(new Dimension(size.width + this.spalte.getWidth(), size.height));
    }

    private void addObjekte() {
        for (DoIdentifier id : this.objekte) {
            DoModel model = id.model;
            Ebene ebene = id.ebene;
            int index = id.indexInEbene;
            ebene.getDoObjekte().add(index, (Object)model);
        }
    }

    private void addDarstellungsSpalteToDarstellung() {
        this.darstellung.getSpalten().add(this.spaltenIndexInDarstellung, (Object)this.spalte);
    }

    private static class DoIdentifier
    implements Comparable<DoIdentifier> {
        private final DoModel model;
        private final Ebene ebene;
        private final int indexInEbene;

        DoIdentifier(DoModel model, Ebene ebene, int indexInEbene) {
            this.model = model;
            this.ebene = ebene;
            this.indexInEbene = indexInEbene;
        }

        @Override
        public int compareTo(DoIdentifier o) {
            return Integer.compare(this.indexInEbene, o.indexInEbene);
        }
    }
}

