/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class DeleteDoModelCommand
extends Command {
    private final DoModel model;
    private Ebene ebene;
    private int modelIndexInEbenen;
    private DarstellungsSpalte darstellungsSpalte;
    private int modelIndexInDarstellungsSpalte;

    public DeleteDoModelCommand(DoModel model) {
        Assert.isNotNull((Object)model, (String)"model");
        this.model = model;
        this.setLabel("Darstellungsbjekt l\u00f6schen");
    }

    public boolean canExecute() {
        return this.model.eContainer() instanceof Ebene;
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.ebene = this.getEbene();
        this.modelIndexInEbenen = this.getEbenenIndex(this.ebene);
        Darstellung darstellung = this.getDarstellung(this.ebene);
        this.darstellungsSpalte = this.getDarstellungsspalteIfMustBeHandled(darstellung);
        this.modelIndexInDarstellungsSpalte = this.getModelIndexInDarstellungsSpalteIfMustBeHandled(this.darstellungsSpalte);
        this.redo();
    }

    private int getModelIndexInDarstellungsSpalteIfMustBeHandled(DarstellungsSpalte spalte) {
        if (spalte != null) {
            return spalte.getDoObjekte().indexOf((Object)this.model);
        }
        return -1;
    }

    private int getEbenenIndex(Ebene e) {
        return e.getDoObjekte().indexOf((Object)this.model);
    }

    private Darstellung getDarstellung(Ebene e) {
        Darstellung d = DarstellungAdapter.getDarstellung((EObject)e);
        Assert.isNotNull((Object)d, (String)"darstellung");
        return d;
    }

    private Ebene getEbene() {
        Ebene e = (Ebene)this.model.eContainer();
        Assert.isNotNull((Object)e, (String)"ebene");
        return e;
    }

    private DarstellungsSpalte getDarstellungsspalteIfMustBeHandled(Darstellung d) {
        if (d instanceof StilisierteDarstellung) {
            for (DarstellungsSpalte e : ((StilisierteDarstellung)d).getSpalten()) {
                if (!e.getDoObjekte().contains((Object)this.model)) continue;
                return e;
            }
        }
        return null;
    }

    public void redo() {
        this.removeModelFromDarstellungsSpalteIfNecessary();
        this.removeModelFromEbene();
    }

    private void removeModelFromDarstellungsSpalteIfNecessary() {
        if (this.darstellungsSpalte != null) {
            this.darstellungsSpalte.getDoObjekte().remove(this.modelIndexInDarstellungsSpalte);
        }
    }

    private void removeModelFromEbene() {
        this.ebene.getDoObjekte().remove(this.modelIndexInEbenen);
    }

    public void undo() {
        this.addModelToEbene();
        this.addModelToDarstellungsSpalteIfNecessary();
    }

    private void addModelToEbene() {
        this.ebene.getDoObjekte().add(this.modelIndexInEbenen, (Object)this.model);
    }

    private void addModelToDarstellungsSpalteIfNecessary() {
        if (this.darstellungsSpalte != null) {
            this.darstellungsSpalte.getDoObjekte().add(this.modelIndexInDarstellungsSpalte, (Object)this.model);
        }
    }
}

